PROGRAM MIDIPlay;

{$F+}

(******************************************************

   MIDIPlay.pas written by Peter Horn, December 1994
   for Multimedia Windows

******************************************************)

USES
  WinTypes, WinProcs, Objects, OMemory, OWindows, ODialogs,
  Strings, OStdDlgs, OStdWnds,  BWCC, MMSystem,
  DrumMIDI, MIDIPIANO, MIDIconst, MIDIIds,
  MIDInterface;

{$R MIDIMUSC.RES}

VAR
          hInst : THANDLE ;
          Devicenumber : Word;

TYPE

  TMyApplication = OBJECT (TApplication)
                     PROCEDURE InitMainWindow; VIRTUAL;
                     Procedure InitInstance; Virtual;
                   END; {TApplication}




  PFenster = ^TFenster;
  TFenster = OBJECT (TWindow)
                    {Data}
                    Piano : PPianowindow;
                    DRUM  : PDrumwindow;

                    {Methods}
                    CONSTRUCTOR Init (AParent: PWindowsObject;
                    zTitel: PChar);
                    PROCEDURE   SetupWindow; VIRTUAL;

                    PROCEDURE   CMShowDrum (var Msg :TMessage);
                    virtual cm_First + cm_DRUM;
                    PROCEDURE CMShowPiano (var Msg :TMessage);
                    virtual cm_First + cm_Piano;

                    Function    CanClose: Boolean ;
                    Virtual;

                    PROCEDURE WMShowDrum (var Msg :TMessage);
                    virtual wm_First + WM_USER_SWITCHDRUM;
                    PROCEDURE WMShowPiano (var Msg :TMessage);
                    virtual wm_First + WM_USER_SWITCHPIANO;

                    PROCEDURE WMUserExit (var Msg :TMessage);
                    virtual wm_First + WM_USER_EXIT;
                    {Selfdefined Methods}
                    procedure CMHelpHelp(var Message: TMessage);
                    virtual cm_First + cm_HelpHelp;
                    procedure CMHelp(var Message: TMessage);
                    virtual cm_First + cm_Help;
                    procedure CMHelpPiano (var Message: TMessage);
                    virtual cm_First + cm_Help_Piano;
                    procedure CMHelpDrum (var Message: TMessage);
                    virtual cm_First + cm_Help_Drum;
                    procedure CMHelpList (var Message: TMessage);
                    virtual cm_First + cm_Help_List;
                    procedure CMHelpNotes (var Message: TMessage);
                    virtual cm_First + cm_Help_Notes;
                    procedure CMHelpPianoRoll (var Message: TMessage);
                    virtual cm_First + cm_Help_PianoRoll;
                    procedure CMHelpListEdit (var Message: TMessage);
                    virtual cm_First + cm_Help_ListEdit;


                    procedure CMQuickHelp(var Message: TMessage);
                    virtual cm_First + cm_quickHelp;
                    procedure CMIndexHelp(var Message: TMessage);
                    virtual cm_First + cm_indexHelp;
                    procedure CMKeyboardHelp(var Message: TMessage);
                    virtual cm_First + cm_KeyboardHelp;
                    procedure CMMIDIHelp(var Message: TMessage);
                    virtual cm_First + cm_midiHelp;
                    procedure CMDRUMHelp(var Message: TMessage);
                    virtual cm_First + cm_drum_fileHelp;
                    procedure CMInstallHelp(var Message: TMessage);
                    virtual cm_First + cm_Install_Board;
                    PROCEDURE HelpAboutList (VAR Msg: TMESSAGE);
                    VIRTUAL cM_FIRST + cm_AboutList;
                    PROCEDURE HelpAboutDrum (VAR Msg: TMESSAGE);
                    VIRTUAL cM_FIRST + cm_AboutDrum;
                    PROCEDURE HelpAboutPiano (VAR Msg: TMESSAGE);
                    VIRTUAL cM_FIRST + cm_AboutPiano;
                    PROCEDURE HelpAboutNotes (VAR Msg: TMESSAGE);
                    VIRTUAL cM_FIRST + cm_AboutNotes;

                    PROCEDURE HelpAbout (VAR Msg: TMESSAGE);
                    VIRTUAL cM_FIRST + cm_About;

           END; {TFenster}

    {---------------------------------------------------------}
    {  TFenster Methods                                       }
    {---------------------------------------------------------}

    CONSTRUCTOR TFenster. Init (AParent: PWindowsObject;
                 zTitel: PChar);
    var i : integer; uDeviceId : Word;


     BEGIN
       TWindow. Init (AParent, zTitel);
       With attr do begin
            Menu := LoadMenu (HInstance, 'MENU');
            MainInstance := HInstance;
            X :=  0;
            Y :=  0;
            W := 640;
            H := 480;
            Style := Style or ws_ClipChildren;
       end;
       new (szTitleName);

       Lib := LoadLibrary(DLLName);


       SetUPwindow;
       Devicenumber := midiOutGetNumDevs;
       (*
       Devices (Devicenumber : Word; var MyDevice: PMidiOutCaps);

       with Mydevice^ do begin
           mMid := wMid;                 { manufacturer ID }
           mPid := wPid;                 { product ID }
           mVers:= vDriverVersion;       { version of the driver }
           devNM := szPname;             { product name (NULLterminated string) }
           mTech := wTechnology;         { type of device }
           mVoice := wVoices;            { # of voices (internal synth only) }
           mNote  := wNotes;             { max # of notes (internal synth only) }
           mChM   := wChannelMask;       { channels used (internal synth only) }
           mSup   := dwSupport;          { functionality supported by driver }
       end;*)

       uDeviceId := 0; new (lpdwVolume);
       Currentvolume := midiOutGetVolume(uDeviceID, lpdwVolume);
       For i:= 0 to 15 do ChannelInstruments[i] := 1;
       new (lphMidiOut);
       StartMIDI(Hwindow, lphMidiOut);
       DRUM := new (PDRUMWindow, Init (@Self, 'Drum Machine [Vers. 1.00 24th December 1994]'));
       Piano := new (PPianowindow, Init (@Self, 'Piano Window  [Vers. 1.00 24th December 1994]'));
       Piano^.Show (sw_ShowMaximized);

     end;

     PROCEDURE TFenster. SetupWindow;
     BEGIN

       Inherited SetupWindow;
       DoCaption (HWindow, szTitleName);
       ParentNotify := HWindow;

     END; {SetupWindow}

     Function   TFenster. CanClose: Boolean ;
     begin
        FreeLibrary (Lib);
        EndMIDI (lphMidiOut);
     end;

     PROCEDURE TFenster. WMUserExit (var Msg :TMessage);
     begin
        TFenster. Canclose;
        Done;
     end;

     PROCEDURE TFenster. CMShowDrum (var Msg :TMessage);
     begin

      piano^.Show (sw_Hide);
      drum^. ATTR. X :=  0;
      drum^. ATTR. Y :=  0;
      drum^. ATTR. W := 640;
      drum^. ATTR. H := 480;
      drum^.Show (sw_ShowNormal);
     end;

     PROCEDURE TFenster. CMShowPiano (var Msg :TMessage);
     begin
      drum^.Show (sw_Hide);

      piano^. ATTR. X :=  0;
      piano^. ATTR. Y :=  0;
      piano^. ATTR. W := 640;
      piano^. ATTR. H := 480;
      piano^.Show (sw_ShowNormal);

     end;


     PROCEDURE TFenster. WMShowPiano (var Msg :TMessage);
     begin
      drum^.Show (sw_Hide);
      piano^.Show (sw_ShowNormal);
     end;

     PROCEDURE TFenster. WMShowDrum (var Msg :TMessage);
     begin
      piano^.Show (sw_Hide);
      drum^.Show  (sw_ShowNormal);
     end;

     procedure TFenster. CMHelpHelp(var Message: TMessage);
     begin
       WinHelp(HWindow, 'WINHELP.HLP', Help_Index, 0);
     end;

     procedure TFenster. CMHelp(var Message: TMessage);
     begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Index')));
     end;

     procedure TFenster. CMHelpPiano (var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Piano')));
     end;


     procedure TFenster. CMHelpDrum (var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Drum')));
     end;

     procedure TFenster. CMHelpNotes (var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Staff')));
     end;


     procedure TFenster. CMHelpPianoRoll (var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Index')));
     end;


     procedure TFenster. CMHelpListEdit (var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Index')));
     end;


     procedure TFenster. CMHelpList (var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Lister')));
     end;


     procedure TFenster. CMQuickHelp(var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Quick')));
     end;

     procedure TFenster. CMIndexHelp(var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Index')));
     end;

     procedure TFenster. CMKeyboardHelp(var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Keyboard')));
     end;

     procedure TFenster. CMMIDIHelp(var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('midi_file')));
     end;

     procedure TFenster. CMDrumHelp(var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Drum_file')));
     end;
     procedure TFenster.CMInstallHelp(var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Install')));
     end;

     PROCEDURE TFenster. HelpAboutList (VAR Msg: TMESSAGE);
        BEGIN
          AboutProc := MakeProcInstance (@About, HINSTANCE);
          DialogBox (HINSTANCE, 'AboutList', HWindow, AboutProc);
          FREEPROCINSTANCE (AboutProc);
          EXIT;
        END;
     PROCEDURE TFenster. HelpAboutDrum (VAR Msg: TMESSAGE);
     BEGIN
          AboutProc := MakeProcInstance (@About, HINSTANCE);
          DialogBox (HINSTANCE, 'AboutDrum', HWindow, AboutProc);
          FREEPROCINSTANCE (AboutProc);
          EXIT;
     END;

     PROCEDURE TFenster. HelpAboutPiano (VAR Msg: TMESSAGE);
        BEGIN
          AboutProc := MakeProcInstance (@About, HINSTANCE);
          DialogBox (HINSTANCE, 'AboutPiano', HWindow, AboutProc);
          FREEPROCINSTANCE (AboutProc);
          EXIT;
        END;

     PROCEDURE TFenster. HelpAboutNotes (VAR Msg: TMESSAGE);
        BEGIN
          AboutProc := MakeProcInstance (@About, HINSTANCE);
          DialogBox (HINSTANCE, 'AboutNotes', HWindow, AboutProc);
          FREEPROCINSTANCE (AboutProc);
          EXIT;
        END;


     PROCEDURE TFenster. HelpAbout (VAR Msg: TMESSAGE);
        BEGIN
          AboutProc := MakeProcInstance (@About, HINSTANCE);
          DialogBox (HINSTANCE, 'AboutBox', HWindow, AboutProc);
          FREEPROCINSTANCE (AboutProc);
          EXIT;
        END;

    {---------------------------------------------------------}
    { Main program :   InitMainWindow                         }
    {---------------------------------------------------------}

     PROCEDURE TMyApplication. InitMainWindow;


     BEGIN
       MainWindow := NEW (PFenster, Init (NIL, WINDOWTITLE) );


     END; {InitMainWindow}

     Procedure TMyApplication. Initinstance;
     begin
        inherited Initinstance;
        HAccTable := LoadAccelerators (HInstance, 'PIANOACC');
     end;
    {---------------------------------------------------------}
    { Vereinbarung des Applikations-Objekts.                  }
    {---------------------------------------------------------}

     VAR
       Appl: TMyApplication;


    {---------------------------------------------------------}
    { Main program                                            }
    {---------------------------------------------------------}

     BEGIN
       Appl. Init ('MIDIMusic');
       Appl. Run;
       Appl. Done;

     END. {MIDIMusic}

* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
