VERSION 2.00
Begin Form Atomic 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Call the Atomic Clock"
   ClientHeight    =   3975
   ClientLeft      =   2475
   ClientTop       =   945
   ClientWidth     =   4695
   ClipControls    =   0   'False
   Height          =   4410
   Left            =   2400
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3975
   ScaleWidth      =   4695
   Top             =   585
   Width           =   4845
   Begin MSComm Comm1 
      InBufferSize    =   2048
      Interval        =   1000
      Left            =   3390
      NullDiscard     =   -1  'True
      OutBufferSize   =   2048
      RTSEnable       =   -1  'True
      Top             =   1125
   End
   Begin SSCheck DST 
      Caption         =   "Use Daylight Savings Time"
      Height          =   285
      Left            =   225
      TabIndex        =   4
      Top             =   960
      Width           =   2640
   End
   Begin ComboBox TimeZone 
      BackColor       =   &H00FFFFFF&
      Height          =   300
      Left            =   375
      Style           =   2  'Dropdown List
      TabIndex        =   3
      Top             =   450
      Width           =   4065
   End
   Begin CommandButton Command1 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   345
      Index           =   2
      Left            =   2370
      TabIndex        =   1
      Top             =   3300
      Width           =   2085
   End
   Begin CommandButton Command1 
      Caption         =   "Dial"
      Default         =   -1  'True
      Height          =   345
      Index           =   1
      Left            =   2370
      TabIndex        =   0
      Top             =   2790
      Width           =   2070
   End
   Begin CommandButton Command1 
      Caption         =   "Reset Defaults"
      Height          =   345
      Index           =   0
      Left            =   2370
      TabIndex        =   12
      Top             =   2280
      Width           =   2070
   End
   Begin SSFrame Frame3D1 
      Caption         =   "COM Port"
      ForeColor       =   &H00000000&
      Height          =   1530
      Left            =   255
      TabIndex        =   7
      Top             =   2190
      Width           =   1965
      Begin SSOption ComPort 
         Caption         =   "COM&4:"
         ForeColor       =   &H00000000&
         Height          =   240
         Index           =   3
         Left            =   135
         TabIndex        =   11
         Top             =   1185
         Width           =   780
      End
      Begin SSOption ComPort 
         Caption         =   "COM&3:"
         ForeColor       =   &H00000000&
         Height          =   240
         Index           =   2
         Left            =   135
         TabIndex        =   10
         Top             =   885
         Width           =   780
      End
      Begin SSOption ComPort 
         Caption         =   "COM&2:"
         ForeColor       =   &H00000000&
         Height          =   240
         Index           =   1
         Left            =   135
         TabIndex        =   9
         Top             =   585
         Width           =   780
      End
      Begin SSOption ComPort 
         Caption         =   "COM&1:"
         ForeColor       =   &H00000000&
         Height          =   240
         Index           =   0
         Left            =   135
         TabIndex        =   8
         Top             =   285
         Width           =   780
      End
   End
   Begin TextBox DialString 
      Height          =   300
      Left            =   375
      TabIndex        =   6
      Text            =   "ATDT 1 303 494-4774"
      Top             =   1710
      Width           =   4080
   End
   Begin Label Status 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Height          =   240
      Left            =   1125
      TabIndex        =   13
      Top             =   15
      Width           =   3300
   End
   Begin Label Label1 
      BackStyle       =   0  'Transparent
      Caption         =   "Modem Dial String"
      Height          =   210
      Index           =   1
      Left            =   225
      TabIndex        =   5
      Top             =   1440
      Width           =   2145
   End
   Begin Label Label1 
      BackStyle       =   0  'Transparent
      Caption         =   "Time Zone"
      Height          =   240
      Index           =   0
      Left            =   195
      TabIndex        =   2
      Top             =   165
      Width           =   1320
   End
End
Option Explicit

Dim ControlsDisabled As Integer
Dim InString As String
Dim TString As String
Dim Aborted As Integer

'
                             'DESCRIPTION OF THE
                 'AUTOMATED COMPUTER TELEPHONE SERVICE (ACTS)
'
'
'The following is transmitted (at 1200 Baud) after completion of the
'telephone connection.
'
             '? = HELP
             'National Institute of Standards and Technology
             'Telephone Time Service
'
                                     'D  L D
              'MJD  YR MO DA H  M  S  ST S UT1 msADV        <OTM>
             '47999 90-04-18 21:39:15 50 0 +.1 045.0 UTC(NIST) *
             '47999 90-04-18 21:39:16 50 0 +.1 045.0 UTC(NIST) *
             '47999 90-04-18 21:39:17 50 0 +.1 045.0 UTC(NIST) *
             '47999 90-04-18 21:39:18 50 0 +.1 045.0 UTC(NIST) *
             '47999 90-04-18 21:39:19 50 0 +.1 037.6 UTC(NIST) #
             '47999 90-04-18 21:39:20 50 0 +.1 037.6 UTC(NIST) #
             'etc..etc...etc.......
'
'UTC = Universal Time Coordinated, the official world time referred to the
'zero meridian.
'_________________________________________________________________________
'
'DST = Daylight savings time characters, valid for the continental U.S., are
'set as follows:
  '00 = We are on standard time (ST).    50 = We are on DST.
  '99 to 51 = Now on ST, go to DST when your local time is 2:00 am and the
    'count is 51.  The count is decremented daily at 00 (UTC).
  '49 to 01 = Now on DST, go to ST when your local time is 2:00 am and the
    'count is 01.  The count is decremented daily at 00 (UTC).
'The two DST characters provide up to 48 days advance notice of a change in
'time.  The count remains at 00 or 50 at other times.
'_________________________________________________________________________
'
'LS = Leap second flag is set to "1" to indicate that a leap second is to be
'added as 23:59:60 (UTC) on the last day of the current UTC month.  The LS
'flag will be reset to "0" starting with 23:59:60 (UTC).  The flag will
'remain on for the entire month before the second is added.  Leap seconds
'are added as needed at the end of any month.  Usually June and/or December
'are chosen.
'
'__________________________________________________________________________
''
'DUT1 = Approximate difference between earth rotation time (UT1) and UTC, in
'steps of 0.1 second.         DUT1 = UT1 - UTC
'___________________________________________________________________________
''
'MJD = Modified Julian Date, often used to tag certain scientific data.
'___________________________________________________________________________
''
'The full time format is sent at 1200 Baud, 8 bit, 1 stop, no parity.
'The format at 300 Baud is also 8 bit, 1 stop, no parity.
'At 300 Baud the MJD and DUT1 values are deleted and the
'time is transmitted only on even seconds.
'___________________________________________________________________________
''
'Maximum on line time will be 56 seconds.  If all lines are busy at any time,
'the oldest call will be terminated if it has been on line more than 28
'seconds, else, the call that first reaches 28 seconds will be terminated.
'___________________________________________________________________________
''
'Current time is valid at the "on-time" marker (OTM), either "*" or "#".
'The nominal on-time marker (*) will be transmitted 45 ms early to account
'for the 8 ms required to send 1 character at 1200 Baud, plus an additional
'7 ms for delay from NIST to the user, and approximately 30 ms "scrambler"
'delay inherent in 1200 Baud modems.  If the caller echoes all characters,
'NIST will measure the round trip delay and advance the on-time marker so
'that the midpoint of the stop bit arrives at the user on time.  The amount
'of msADV will reflect the actual required advance in milliseconds and the
'OTM will be a "#".  The NIST system requires 4 or 5 consecutive delay
'measurements which are consistent before switching from "*" to "#".
'If the user has a 1200 Baud modem with the same internal delay as that used
'by NIST, then the "#" OTM should arrive at the user within +-2 ms of the
'correct time.  However, NIST has studied different brands of 1200 Baud
'modems and found internal delays from 24 ms to 40 ms and offsets of the
'"#" OTM of +-10 ms.  For many computer users, +-10 ms accuracy should be
'more than adequate since many computer internal clocks can only be set with
'granularity of 20 to 50 ms.  In any case, the repeatability of the offset
'for the "#" OTM should be within +-2 ms, if the dial-up path is reciprocal
'and the user doesn't change the brand or model of modem used. This should
'be true even if the dial-up path on one day is a land-line of less than
'40 ms (one way) and on the next day is a satellite link of 260 to 300 ms.
'In the rare event that the path is one way by satellite and the other way
'by land line with a round trip measurement in the range of 90 to 260 ms,
'the OTM will remain a "*" indicating 45 ms advance.
'___________________________________________________________________________
'''
'For user comments write:
'NIST-ACTS
'Time and Frequency Division
'Mail Stop 524
'325 Broadway
'Boulder, CO  80303
'
'Software for setting (PC)DOS compatable machines is available
'on a 360-kbyte diskette for $35.00 from:
'NIST Office of Standard Reference Materials
'B311-Chemistry Bldg, NIST, Gaithersburg, MD, 20899, (301) 975-6776
'
'--------------------------------------------------------------------------

Sub Command1_Click (Index As Integer)
Dim StartTime As Double
Dim I As Integer
Dim NewD As Double
Dim OldD As Double
Dim DSTFlag As String
Dim OffBy As String

If Index = 0 Then  'Reset Defaults
   ResetDefaults
   Status.Caption = ""
End If

If Index = 1 Then  'Dial
   SaveModemSettings
   Aborted = False
   Status.Caption = ""

   Command1(0).Enabled = False
   Command1(1).Enabled = False
   TimeZone.Enabled = False
   DST.Enabled = False
   DialString.Enabled = False
   Frame3D1.Enabled = False
   ControlsDisabled = True
   On Local Error GoTo ErrHndl
   For I% = 0 To 3
     If ComPort(I%).Value Then comm1.CommPort = I% + 1
   Next I%
   If Aborted Then Exit Sub
   comm1.Settings = "1200,N,8,1"
   If Aborted Then Exit Sub
   comm1.PortOpen = True
   If Aborted Then Exit Sub
   comm1.Output = DialString.Text + Chr$(13) + Chr(10)
   StartTime = Timer
   LastTime = 0
   Do
      DoEvents
      If LastTime <> Int(Timer) Then
         If Not Aborted Then Status.Caption = "Connecting - " + Format$(75 - Int(Timer - StartTime)) + " seconds until timeout."
         LastTime = Int(Timer)
      End If
   Loop Until comm1.InBufferCount >= 600 Or ((Timer - StartTime) > 75) Or Aborted
   If Aborted Then Exit Sub
   
   If (Timer - StartTime) > 75 Then
         Status.Caption = "Timed out."
         Exit Sub
   End If
   
   Status.Caption = "Setting time."
   InString$ = comm1.Input
   If Aborted Then Exit Sub
   InString$ = Mid$(InString$, InStr(InString$, "*") + 1, 80)
    

   NewD = DateValue(Mid$(InString$, 12, 2) + "/" + Mid$(InString$, 15, 2) + "/" + Mid$(InString$, 9, 2))
   NewD = NewD + TimeValue(Mid$(InString$, 18, 8))
   
   NewD = NewD - (TimeZone.ListIndex - 11) * (1 / 24)
   DSTFlag$ = Mid$(InString$, 27, 2)
   'If ((DSTFlag >= "01") And (DSTFlag <= "50")) Then
   '   NewD = NewD - (1 / 24)
   'End If
   If DST.Value Then
      NewD = NewD + (1 / 24)
   End If
   OldD = Date + Time
   If Year(NewD) >= 1993 Then
      Date = Format$(NewD, "mm/dd/yy")
      Time = Format$(NewD, "hh:mm:ss")
      If OldD > NewD Then
         OffBy = "fast"
      Else
         OffBy = "slow"
      End If
      MsgBox "Time set to " + Format$(NewD, "hh:mm:ss") + ".  Clock was " + OffBy$ + " by " + Format$(Abs(NewD - OldD), "hh:mm:ss") + "."
      Screen.MousePointer = 11
      AtomicTimeWasSet = True
      Status.Caption = "Time set."
   Else
      MsgBox "Error getting date and time."
   End If
   
   If Aborted Then Exit Sub
   Screen.MousePointer = 11
   HangUp
   If Aborted Then Exit Sub
   On Local Error Resume Next
   
   Screen.MousePointer = 0
   Unload Atomic

End If

If Index = 2 Then  'Cancel
   If ControlsDisabled Then
      HangUp
      EnableControls
      Aborted = True
      Status.Caption = "Aborted."
   Else
      Unload Atomic
   End If
End If

EnableControls
Exit Sub


ErrHndl:
MsgBox "Error: " + Error(Err)
EnableControls
Exit Sub
End Sub

Sub EnableControls ()
   Command1(0).Enabled = True
   Command1(1).Enabled = True
   TimeZone.Enabled = True
   DST.Enabled = True
   DialString.Enabled = True
   Frame3D1.Enabled = True
   ControlsDisabled = False
End Sub

Sub Form_Load ()
Atomic.Left = Settings.Left + (Settings.Width / 2) - (Atomic.Width / 2)
Atomic.Top = Settings.Top + (Settings.Height / 2) - (Atomic.Height / 2)

TimeZone.AddItem "Greenwich + 11"
TimeZone.AddItem "Greenwich + 10"
TimeZone.AddItem "Greenwich + 9"
TimeZone.AddItem "Greenwich + 8"
TimeZone.AddItem "Greenwich + 7"
TimeZone.AddItem "Greenwich + 6"
TimeZone.AddItem "Greenwich + 5"
TimeZone.AddItem "Greenwich + 4"
TimeZone.AddItem "Greenwich + 3"
TimeZone.AddItem "Greenwich + 2"
TimeZone.AddItem "Greenwich + 1"
TimeZone.AddItem "Greenwich"
TimeZone.AddItem "Greenwich - 1"
TimeZone.AddItem "Greenwich - 2"
TimeZone.AddItem "Greenwich - 3"
TimeZone.AddItem "Atlantic Standard Time (4)"
TimeZone.AddItem "Eastern Standard Time"
TimeZone.AddItem "Central Time"
TimeZone.AddItem "Mountain Time"
TimeZone.AddItem "Pacific Time"
TimeZone.AddItem "Yukon Standard Time"
TimeZone.AddItem "Alaska-Hawaii Standard Time"
TimeZone.AddItem "Nome Standard Time"
TimeZone.AddItem "Greenwich - 12"
ResetDefaults
LoadModemSettings
'Atomic.Show 1
'Command1(1).SetFocus
End Sub

Sub HangUp ()
   Dim StartTime As Double
   Dim I As Integer
   Dim Ret As Integer

   'Josh version  -
   'comm1.PortOpen = False
   'Exit Sub




   'Beep
   On Local Error GoTo ErrHndl2
   'comm1.Output = "+++"
   'StartTime = Timer
   'While Timer - StartTime < .5
   '  DoEvents
   'Wend
   'comm1.Output = "ATH0" + Chr$(13) + Chr(10)
   comm1.Output = ""
   For I% = 1 To 3
   StartTime = Timer
   TString$ = comm1.Input
   comm1.Output = "+"
   While Timer - StartTime < .25
     DoEvents
   Wend
   Next I%

   'Do
   '   DoEvents
   'Loop Until comm1.InBufferCount >= 2

   StartTime = Timer
   While Timer - StartTime < 3#
     DoEvents
   Wend
   
   TString$ = comm1.Input
   comm1.Output = "ATH0" + Chr(13) + Chr(10)
   StartTime = Timer
   Do
      DoEvents
   Loop Until comm1.InBufferCount >= 2 Or (Timer - StartTime) > 5
   TString$ = comm1.Input

   StartTime = Timer
   While Timer - StartTime < 1#
     DoEvents
   Wend
   
   '3/28/92 version
   comm1.PortOpen = False
   Exit Sub

   
   comm1.Output = "+++"
   StartTime = Timer
   While Timer - StartTime < .5
     DoEvents
   Wend
   comm1.Output = "ATH0" + Chr$(13) + Chr(10)

   Ret = comm1.DTREnable     'Save current setting
   comm1.DTREnable = True    'Turn DTR on
     DoEvents
   comm1.DTREnable = False   'Turn DTR off
     DoEvents
   comm1.DTREnable = Ret     'Restore old setting
   
   comm1.PortOpen = False

ErrHndl2:
  EnableControls
  Exit Sub
End Sub

Sub LoadModemSettings ()
Dim lpReturnedString As String * 100
Dim a As Integer

lpReturnedString = Space$(100)
a% = MyGetProfileString("AllTheTime", "TimeZoneIndex", "16", lpReturnedString$, 100)
TimeZone.ListIndex = Val(lpReturnedString)

a% = MyGetProfileString("AllTheTime", "DST", "0", lpReturnedString$, 100)
DST.Value = Val(lpReturnedString)

a% = MyGetProfileString("AllTheTime", "DialString", "ATDT 1 303 494-4774", lpReturnedString$, 100)
DialString.Text = lpReturnedString

a% = MyGetProfileString("AllTheTime", "ComPort", "0", lpReturnedString$, 100)
ComPort(Val(lpReturnedString)).Value = True
End Sub

Sub ResetDefaults ()
   TimeZone.ListIndex = 16
   DST.Value = 0
   DialString.Text = "ATDT 1 303 494-4774"
   ComPort(0).Value = True
   'LoadModemSettings
End Sub

Sub SaveModemSettings ()
Dim a As Integer
Dim M As String
Dim I As Integer

a% = WritePrivateProfileString("AllTheTime", "TimeZoneIndex", TimeZone.ListIndex, "ATT.INI")
a% = WritePrivateProfileString("AllTheTime", "DST", DST.Value, "ATT.INI")
a% = WritePrivateProfileString("AllTheTime", "DialString", DialString.Text, "ATT.INI")
M$ = "0"
For I% = 0 To 3
   If ComPort(I%).Value Then M$ = Str$(I%)
Next I%
a% = WritePrivateProfileString("AllTheTime", "ComPort", M$, "ATT.INI")

End Sub

