// Copyright (c) 1994, William Wagner
// All Rights reserved.
//
// This source is a portion of a shareware program.  It may be distributed
// only in its entirety.  The copyright statements must be included with any 
// reproduction of this source.
// 

// cassette.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "cassette.h"

#include "mainfrm.h"
#include "cassedoc.h"
#include "tapeview.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

// This is the help ID for about...
const DWORD HID_APP_ABOUT=0x1E140;

/////////////////////////////////////////////////////////////////////////////
// CCassetteApp

BEGIN_MESSAGE_MAP(CCassetteApp, CWinApp)
	//{{AFX_MSG_MAP(CCassetteApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_HELP_SEARCH, OnHelpSearch)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
	// Global help commands
	ON_COMMAND(ID_HELP_INDEX, CWinApp::OnHelpIndex)
	ON_COMMAND(ID_HELP_USING, CWinApp::OnHelpUsing)
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CWinApp::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CWinApp::OnHelpIndex)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCassetteApp construction

//Simple default constructor.
CCassetteApp::CCassetteApp()
{
ASSERT_VALID (this);
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CCassetteApp object

CCassetteApp NEAR theApp;

/////////////////////////////////////////////////////////////////////////////
// CCassetteApp initialization

// Standard initialization
// Register the application's document templates.  Document templates
//  serve as the connection between documents, frame windows and views.
// Here, use the tapeview view class.  The frame window will handle
// the creation of the multiple views.
// simple command line parsing
BOOL CCassetteApp::InitInstance()
{
SetDialogBkColor();        // set dialog background color to gray
LoadStdProfileSettings();  // Load standard INI file options (including MRU)

AddDocTemplate(new CSingleDocTemplate(IDR_MAINFRAME,
		RUNTIME_CLASS(CCassetteDoc),
		RUNTIME_CLASS(CMainFrame),     // main SDI frame window
		RUNTIME_CLASS(CTapeView)));

if (m_lpCmdLine[0] == '\0')
	// create a new (empty) document
	OnFileNew();
else
	// open an existing document
	OpenDocumentFile(m_lpCmdLine);

return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	//Default Constructor.
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	// Standard data exchange.
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	
	// Map for the Register button.
	//{{AFX_MSG(CAboutDlg)
	afx_msg void OnClickedRegister();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//Constructor.  Construct the base class.
CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
//{{AFX_DATA_INIT(CAboutDlg)
//}}AFX_DATA_INIT
	
ASSERT_VALID (this);
}

//The Data Exchanger.  There is 
// nothing here.
void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
ASSERT_VALID (this);

CDialog::DoDataExchange(pDX);
//{{AFX_DATA_MAP(CAboutDlg)
//}}AFX_DATA_MAP

ASSERT_VALID (this);
}

//Register button clicked in the dialog.
// Bring up the help screen associated with
// registration.
void CAboutDlg::OnClickedRegister()
{
ASSERT_VALID (this);
ASSERT_VALID (::AfxGetApp ());

::AfxGetApp ()->WinHelp (HID_APP_ABOUT, HELP_CONTEXT);   

ASSERT_VALID (this);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	ON_BN_CLICKED(IDC_REGISTER, OnClickedRegister)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
// Just put the dialog on the screen.
void CCassetteApp::OnAppAbout()
{
ASSERT_VALID (this);
	
CAboutDlg aboutDlg;
ASSERT_VALID (&aboutDlg);

VERIFY (-1 != aboutDlg.DoModal());

ASSERT_VALID (this);
}

/////////////////////////////////////////////////////////////////////////////
// CCassetteApp commands

// Help Search command.  
// Invoke WinHelp with a general search.
void CCassetteApp::OnHelpSearch()
{
ASSERT_VALID (this);

char Unused = '\0';
WinHelp (DWORD (&Unused), HELP_PARTIALKEY);   

ASSERT_VALID (this);
}
