// Copyright (c) 1994, William Wagner
// All Rights reserved.
//
// This source is a portion of a shareware program.  It may be distributed
// only in its entirety.  The copyright statements must be included with any 
// reproduction of this source.
// 

// tapeview.cpp : implementation file
//

#include "stdafx.h"
#include "cassette.h"

#include "tapeview.h"
#include "cassedoc.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTapeView

IMPLEMENT_DYNCREATE(CTapeView, CFormView)

//Create this object.  Initialize the base class, and 
//initialize the brush handle.
CTapeView::CTapeView()
	: CFormView(CTapeView::IDD),
	m_hCtlBrush (::CreateSolidBrush (RGB (192, 192, 192)))
{
	//{{AFX_DATA_INIT(CTapeView)
	//}}AFX_DATA_INIT
}

//Destroy this object.  Delete the control brush.
CTapeView::~CTapeView()
{
ASSERT_VALID (this);
DeleteObject (m_hCtlBrush);
}

//Data Exchanger.  This transfers data between the document object,
// and the form controls.  This view object acts as a conduit 
// between them.
void CTapeView::DoDataExchange(CDataExchange* pDX)
{
	ASSERT_VALID (this);
	ASSERT_VALID (GetDocument ());
	
	CFormView::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_ALBUM1, GetDocument ()->m_csAlbum1);
	DDV_MaxChars(pDX, GetDocument ()->m_csAlbum1, 256);
	DDX_Text(pDX, IDC_ALBUM2, GetDocument ()->m_csAlbum2);
	DDV_MaxChars(pDX, GetDocument ()->m_csAlbum2, 256);
	DDX_Text(pDX, IDC_ARTIST1, GetDocument ()->m_csArtist1);
	DDV_MaxChars(pDX, GetDocument ()->m_csArtist1, 128);
	DDX_Text(pDX, IDC_ARTIST2, GetDocument ()->m_csArtist2);
	DDV_MaxChars(pDX, GetDocument ()->m_csArtist2, 128);
	DDX_Text(pDX, IDC_SONGS1, GetDocument ()->m_csSongs1);
	DDV_MaxChars(pDX, GetDocument ()->m_csSongs1, 1024);
	DDX_Text(pDX, IDC_SONGS2, GetDocument ()->m_csSongs2);
	DDV_MaxChars(pDX, GetDocument ()->m_csSongs2, 1024);
	DDX_Text(pDX, IDC_NOTES, GetDocument ()->m_csNotes);
	DDV_MaxChars(pDX, GetDocument ()->m_csNotes, 1024);
	//{{AFX_DATA_MAP(CTapeView)
	//}}AFX_DATA_MAP

	//If this is changing data in the document, then 
	//set the document modified flags.   
   	if (pDX->m_bSaveAndValidate)
		GetDocument ()->SetModifiedFlag (TRUE);

	ASSERT_VALID (GetDocument ());
}

//Get a pointer to this document.
#ifdef _DEBUG
CCassetteDoc* CTapeView::GetDocument() // non-debug version is inline
{
ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CCassetteDoc)));
return (CCassetteDoc*) m_pDocument;
}
#endif

//Initial Update.  
// Use the Data Exchange mechanism to transfer data from the 
// document to the controls in the view.
void CTapeView::OnInitialUpdate ()
{
ASSERT_VALID (this);
UpdateData (FALSE);
}

//Update Data
// If one of the document members changed, update the data in the
// view.
void CTapeView::OnUpdate (CView*, LPARAM lHint, CObject*)
{
ASSERT_VALID (this);

switch (lHint)
	{
	case FONT_ALBUM_CHANGE:
	case FONT_ARTIST_CHANGE:
	case FONT_NOTES_CHANGE:
	case FONT_SONGS_CHANGE:
		break;
		
	case ALBUM1_CHANGE:
	case ALBUM2_CHANGE:
	case ARTIST1_CHANGE:
	case ARTIST2_CHANGE:
	case SONGS1_CHANGE:
	case SONGS2_CHANGE:
	case NOTES_CHANGE:
	default:
		UpdateData (FALSE);
		break;
	}
}

BEGIN_MESSAGE_MAP(CTapeView, CFormView)
	//{{AFX_MSG_MAP(CTapeView)
	ON_WM_CTLCOLOR()
	ON_EN_CHANGE(IDC_ALBUM1, OnChangeAlbum1)
	ON_EN_CHANGE(IDC_ALBUM2, OnChangeAlbum2)
	ON_EN_CHANGE(IDC_ARTIST1, OnChangeArtist1)
	ON_EN_CHANGE(IDC_ARTIST2, OnChangeArtist2)
	ON_EN_CHANGE(IDC_NOTES, OnChangeNotes)
	ON_EN_CHANGE(IDC_SONGS1, OnChangeSongs1)
	ON_EN_CHANGE(IDC_SONGS2, OnChangeSongs2)
	//}}AFX_MSG_MAP
   // Standard printing commands
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTapeView message handlers

//OnCtlColor.
// This comes right out of the MFC tech notes.  The purpose is to
// set the background color in the form window to gray.
HBRUSH CTapeView::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
ASSERT_VALID (this);
ASSERT_VALID (pDC);
// ASSERT_VALID (pWnd);
// That assert will always fail.  It is not a window yet.

COLORREF hCtlText = RGB (0, 0, 0);

LRESULT lResult;
if (pWnd->SendChildNotifyLastMsg(&lResult))
	return (HBRUSH)lResult;     // eat it

if (!GrayCtlColor(pDC->m_hDC, pWnd->GetSafeHwnd(), nCtlColor, m_hCtlBrush, hCtlText))
	return (HBRUSH)Default();
return m_hCtlBrush;
}

///////////////////////////////////////////////////////////////////////////
//EN_CHANGE members.
//
// I am covering these with one block comment.  They all do the same
// thing.  Get the data from the form.  Update all the views.
 
void CTapeView::OnChangeAlbum1()
{
ASSERT_VALID (this);
UpdateData (TRUE);
GetDocument ()->UpdateAllViews (this, ALBUM1_CHANGE, NULL);	
}

void CTapeView::OnChangeAlbum2()
{
ASSERT_VALID (this);
UpdateData (TRUE);
GetDocument ()->UpdateAllViews (this, ALBUM2_CHANGE, NULL);	
}

void CTapeView::OnChangeArtist1()
{
ASSERT_VALID (this);
UpdateData (TRUE);
GetDocument ()->UpdateAllViews (this, ARTIST1_CHANGE, NULL);	
}

void CTapeView::OnChangeArtist2()
{
ASSERT_VALID (this);
UpdateData (TRUE);
GetDocument ()->UpdateAllViews (this, ARTIST2_CHANGE, NULL);	
}

void CTapeView::OnChangeNotes()
{
ASSERT_VALID (this);
UpdateData (TRUE);
GetDocument ()->UpdateAllViews (this, NOTES_CHANGE, NULL);	
}

void CTapeView::OnChangeSongs1()
{
ASSERT_VALID (this);
UpdateData (TRUE);
GetDocument ()->UpdateAllViews (this, SONGS1_CHANGE, NULL);	
}

void CTapeView::OnChangeSongs2()
{
ASSERT_VALID (this);
UpdateData (TRUE);
GetDocument ()->UpdateAllViews (this, SONGS2_CHANGE, NULL);	
}
