// Copyright (c) 1994, William Wagner
// All Rights reserved.
//
// This source is a portion of a shareware program.  It may be distributed
// only in its entirety.  The copyright statements must be included with any 
// reproduction of this source.
// 

// tapeview.h : header file
//

#ifndef __TAPEVIEW_H__
#define __TAPEVIEW_H__
/////////////////////////////////////////////////////////////////////////////
// CTapeView form view
//
//This class defines the form used to enter data in the tape label.
//There is one trick being employed here: All the form data exchange is done
// via document member variables.
//There is one other area of interest:
// This class overrides the OnCtlColor member in order to set the default
// gray background.

class CTapeView : public CFormView
{
	DECLARE_DYNCREATE(CTapeView)
protected:
	CTapeView();			// protected constructor used by dynamic creation

// Form Data
public:
	//{{AFX_DATA(CTapeView)
	enum { IDD = IDD_CASSETTE };
	//}}AFX_DATA

// Attributes
public:
	//Get a pointer to our document.
	CCassetteDoc* GetDocument();


private:
	//Handle to the brush to use for the background drawing.
	HBRUSH  m_hCtlBrush;

// Operations
public:
	//return a pointer to our frame.
	inline CMainFrame* GetParentFrame () const
		{ return (CMainFrame*) CFormView::GetParentFrame ();};

// Implementation
protected:
	//Handle the initial update message.
	virtual void OnInitialUpdate ();
	//Handle other update messages.  
	virtual void OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint);
	//Destruction.
	virtual ~CTapeView();
	//Data Exchange
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//Our message maps handles the control color message.  In addition,
	// we accept EN_CHANGE messages on all of the edit controls.
	//{{AFX_MSG(CTapeView)                                      
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	afx_msg void OnChangeAlbum1();
	afx_msg void OnChangeAlbum2();
	afx_msg void OnChangeArtist1();
	afx_msg void OnChangeArtist2();
	afx_msg void OnChangeNotes();
	afx_msg void OnChangeSongs1();
	afx_msg void OnChangeSongs2();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG // debug version in tapeview.cpp
inline CCassetteDoc* CTapeView::GetDocument()
   { return (CCassetteDoc*) m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
#endif
