/*
	misc.c
	======
	
	Functions not present on some systems
	For Example MS Windows

	Copyright (c) 1994 Michael Taylor
*/

#include <stdlib.h>
#include <string.h>

#ifdef WINDOWS
int
stricmp (const char *a, const char *b)
{
	int	t;

	for (; 0 == (t = toupper(*(unsigned char*)a) - toupper(*(unsigned char*)b)); ++a,++b) {
		if ('\0' == *a)
			return (0);
	}
	return (t > 0 ? 1 : -1);
}

int
strnicmp (const char *a, const char *b, size_t n)
{
	int	t;

	for (; 0 < n; --n, ++a, ++b) {
		if (0 != (t = toupper (*(unsigned char *)a) - toupper (*(unsigned char *)b)))
			return (t > 0 ? 1 : -1);
		else if ('\0' == *a)
			return (0);
	}
	return (0);
}
#endif
