Option Explicit

' Index information for 'person' in db
Type tperson
    LNAME As String * 20
    FNAME As String * 20
End Type
' Index information for 'company name' in db
Type tCompany
    cName As String * 30
End Type
' Index information for a reference in db (just to
' show integer access to the database...)  Note: we
' can 'concatenate' integers if we wanted to.  MF will
' not 'add' the value of 2 (or more) integers.  It
' will create 'sub-groups' within each integer.
' To demonstrate, remove the "'" from the second
' piece of data (ref2) and if you assign ref2 to
' different #'s, you will see that they are subgrouped
' in ref.
Type tRef
    ref As Integer
    'ref2 As Integer
End Type
' More 'actual' data for the DB
Type tData
    Street As String * 30
    City As String * 20
    State As String * 2
    Zip As String * 9
    Voice As String * 13
    Fax As String * 13
End Type

' This is the ENTIRE record... it is made up of
' the 3 index types and the 'data' type
Type tcard
    person As tperson
    company As tCompany
    ref As tRef
    data As tData
End Type

Global person  As tperson
Global card  As tcard

' We have another database - REFERENCE -
' In this case, we don't want to bother having a
' whole bunch of type definitions -- we are just
' going to hard-code the structure.  This is a
' 'less' portable design (e.g. in the CARD example,
' above) if we modify  a field or WIDTH, it will
' automatically adjust the size of the database.
' this example will not automatically adjust.
' ---
' This database demonstrates 'grouping' withing
' integer fields.
Type tReference
    'Index 0
    ref As Integer
    refsub As Integer
    ' Data
    name As String * 25

End Type

' Global reference to the reference database
Global refDBHndl As Integer    ' Hndl to reference DB

Global PassL As Long
Global Const ASMODAL = 1    ' Display a form modally
Global Const PHOURGLASS = 11
Global Const PNORMAL = 0

' Nice variables to have around...when using VB...
Global junk As Integer
Global junki As Integer
Global junkl As Long

' semi-Generic LOAD COMBO BOX routine
Sub load_refs (ctrl As Control)
    Dim lCurRec As Long, ref As tReference

    ' remove old junk in the control
    ctrl.Clear
    ' load list with data
    ' Get the first record in index order
    lCurRec = mfTop(TaskHndl, refDBHndl, 0)
    ' Loop until EOF, basically...
    Do While lCurRec > 0
        junk = mfRead(lCurRec, ref, TaskHndl, refDBHndl, MFRW_ALL)
        If junk <> 0 Then
            MsgBox "Error on read: " + Str$(junk)
        End If
        ctrl.AddItem Format$(ref.ref, "##") + " " + Format$(ref.refsub, "##") + " " + ref.name

        ' Get the next record in index order
        lCurRec = mfSkip(lCurRec, 1, TaskHndl, refDBHndl, 0)
    Loop

End Sub

