/*

	Quick example of SP functions in C

*/


#include <windows.h>
#include "..\..\mf.h"


typedef struct {
	char name[20];
} TEST_K0;

typedef struct {
	char otherStuff[10];
} TEST_DATA;

typedef struct {
	TEST_K0		k0;
    TEST_DATA	data;
} TEST_REC;

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    
    hMF_TASK 	mf_TASK;
	hMF_DB		mf_TESTDB;
	tmfExtDLL	mfExt;
    
    if (hPrevInstance)          /* Other instances of app running? Dont restart */
    	return(0);
	if (lstrlen(lpCmdLine) == 0)
    	{
    	MessageBox(NULL, "Parameters: <DB_PATH> to store temp databases in \ne.g. C:\\ or c:\\test\\\n(backslash REQUIRED!)", "WARNING", MB_OK);
        return (0);
        }
        
		/*
        	mf_TASK is a global in abDB.h
        */
	mfExt.extType = -1;		/* No extensions */
	mf_TASK = mfInit((ptmfExtDLL)&mfExt);
	{
    char 	szdbPath[128];
    int		idxSize[1];
    int		idxType[1];
    /* db to use */
    lstrcpy(szdbPath, lpCmdLine);
    lstrcat(szdbPath, "TESTDB");
    
    /* DB statistics */
    idxSize[0]=sizeof(TEST_K0);
    idxType[0]=MFCOMP_CHARIC;
    if (mfCreateDB(szdbPath, sizeof(TEST_DATA), 1, idxSize, idxType) < 0)
    	{
        MessageBox(NULL, "Create Failed", "ERROR", MB_OK);
        return (-1);
        }
    
	mf_TESTDB = mfOpen(szdbPath, mf_TASK);
    if (mf_TESTDB < 0)
    	{
    	MessageBox(NULL, "Open database failed", "ERROR", MB_OK);
        return (0);
        }
    }
	/*
    	Create some data to read
    */
    {
    TEST_REC	dbRecord;
    int			n;
    
    lstrcpy((LPSTR)dbRecord.data.otherStuff, (LPSTR)"Whatever");
    
    /*
    	Create 60 alternating, yet repeated, identical items...
        (This keeps the same items from being next to eachother (record # wise...)
    */
    for(n=0; n < 30; n++)
    	{
	    lstrcpy((LPSTR)dbRecord.k0.name, (LPSTR)"Brown");
		mfWrite(mfAppendData((FPDATA)&dbRecord.data, mf_TASK, mf_TESTDB),
			 	(FPDATA)&dbRecord, 
			 	mf_TASK, 
			 	mf_TESTDB, 
			 	MFRW_ALL);
	    lstrcpy((LPSTR)dbRecord.k0.name, (LPSTR)"Smith");
		mfWrite(mfAppendData((FPDATA)&dbRecord.data, mf_TASK, mf_TESTDB),
			 	(FPDATA)&dbRecord, 
			 	mf_TASK, 
			 	mf_TESTDB, 
			 	MFRW_ALL);
    	}
    }
    
    /*
    
    	Read a list...
    */
    {
    #define	hits	6
    RPTR	hitArray[hits];
    long	hitCount;
    char	display[256];
    hitCount = mfReadList(  0,
    						"Brown",
                            5,
                            &hitArray[0],
                            hits,
                            mf_TASK,
                            mf_TESTDB,
                            0);
	wsprintf(display,
			"Hits: %ld\nRecs:\n %ld\n %ld \n %ld\n %ld\n %ld",
            hitCount,
            hitArray[0],
            hitArray[1],
            hitArray[2],
            hitArray[3],
            hitArray[4]);
	MessageBox(NULL, display, "Pass 1", MB_OK);
    
    /*
    	Contiune to read...
        NOTE:
        We made the hitArray ONE bigger than we want.  This allows us to
        pre-seed the next hit into the system.
        We only use the first 5 of the records...  This will also work on the
        LAST record (e.g. if there are 6 final matches) because it
        will automatically wrap the loop 1 more time to pick up the final record...
    */
    while(hitCount == hits)
    	{
	    hitCount = mfReadList(  hitArray[5],
	    						"Brown",
	                            5,
	                            &hitArray[0],
	                            hits,
	                            mf_TASK,
	                            mf_TESTDB,
	                            0);
		/*
        	This may not be politically correct, however,
            this is a demo.  Obviously, if there are only
            3 matches, it will print more than there really are.
            
            Oh well...
        */
		wsprintf(display,
				"Hits: %ld\nRecs:\n %ld\n %ld \n %ld\n %ld\n %ld",
	            hitCount,
	            hitArray[0],
	            hitArray[1],
	            hitArray[2],
	            hitArray[3],
	            hitArray[4]);
		MessageBox(NULL, display, "More Passes", MB_OK);
        
        }
        
                            
    
	}
    
    
    /*
    	Closes all DB's and deallocs stuff
    */
    mfDeInit(mf_TASK);
    
	return (0);
}
