/******************************************************************************
*                                   XExecD                                    *
*                                                                             *
* Interface unit to XEXEC.DLL.                                                *
*                                                                             *
* Written by Golan Yaniv (C) 1994                                             *
*                                                                             *
* This file is part of the XSpawn package.                                    *
*                                                                             *
******************************************************************************/
#if !defined (XEXECD_H)
#define XEXECD_H

#include <windows.h>

#ifdef __cplusplus
extern "C" {
#endif /* _cplusplus */

    // options in WXSpawn's wOptions field. this values are also 
    // returned by WXGetFileOS : 
#define    WXO_OSTYPEMASK  0x000F    // bits mask dedicated to os type 
#define    WXO_AUTO        0x0000    // auto-detect os type from file 
#define    WXO_WIN         0x0001    // force type = windows 
#define    WXO_DOS         0x0002    // force type = dos 
#define    WXO_OS2         0x0003    // force type = os2 
#define    WXO_NT          0x0004    // force type = nt 
#define    WXO_USESHELL    0x0010    // use shell to execute 

	// error codes (in low word) 
	// errors marked with (*) return additional info in high word 
#define    WX_APPEXEC      0x0001    // application exec error (*) 
#define    WX_AGENTEXEC    0x0002    // agent exec error (*) 
#define    WX_OUTOFMEM     0x0003    // not enough memory 
#define    WX_AGENTCOMM    0x0004    // unable to establish agent communication 
#define    WX_PIFFILE      0x0005    // unable to create PIF file (*)
#define    WX_NOAGENT      0x0006    // agent not installed (*)
#define    WX_UNKNOWNOS    0x0007    // unknown os type 
#define    WX_BADVER       0x00F1    // version mismatch (*) 
#define    WX_AGENTKILLED  0x00F2    // agent was killed while waiting 
#define    WX_INVALIDHEXEC 0x00F3    // invalid hExec handle 

    // for WX_APPEXEC, high word contains WinExec error or : 
#define    WX_NOTFOUND     0x0101     // path or file not found 
#define    WX_NOMEM        0x0102     // not enough memory 
#define    WX_ARGLIST      0x0103     // args list too long 
#define    WX_BADFORMAT    0x0104     // bad exec format 
#define    WX_UNKNOWN      0x010F     // unknown error 

    // returned by WXGetHostOS() : }
#define    WX_OS_WIN3X     0x0001     // Windows 3.X 
#define    WX_OS_WINNT     0x0002     // Windows NT 
#define    WX_OS_WINOS2    0x0003     // Win-OS/2 
#define    WX_OS_UNKNOWN   0xFFFF     // Unknown Host OS 


DWORD WINAPI    WXSpawn(LPCSTR lpszFileName,
                        LPCSTR lpszArgs,
                        LPCSTR lpszDirectory,
                        WORD   nCmdShow,
                        WORD   wOptions,
                        DWORD *hExec);

BOOL  WINAPI    WXIsDone(DWORD hExec,
                         DWORD *lpdwErrorCode,
                         DWORD *lpdwExitCode);

VOID  WINAPI    WXStopTracking(DWORD hExec);

VOID  WINAPI    WXSetDebugMode(BOOL bDebugFlag);

WORD  WINAPI    WXGetVersion();

HINSTANCE WINAPI WXGetInstance(DWORD hExec);

WORD  WINAPI    WXGetFileOS(LPCSTR lpszFileName);

VOID  WINAPI    WXGetError(DWORD dwErrorCode,
                           WORD *wError,
                           WORD *eReason);

DWORD WINAPI    WXGetHostOS();

#ifdef __cplusplus
}
#endif   /* _cplusplus */

#endif   /* XEXECD_H */

