///////////////////////////////////////////////////////////////////////////////////
// Internet Global Phone Project
// talksock.h : declaration of the CTalkClient, CTalkListenServer, and CTalkServer
//              classes
//
// The CTalk... classes implements protocol specific behaviours on top of the
// CSocketOwner, CSockServer, CSockClient, and CSockListenServer base classes.
// See the main text of article in Dr. Dobb's Journal for a discussion of the
// class hierachy.
//
////////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 1993-1994	microWonders Inc.  All rights reserved.
//                                                                         
// AN OPEN INVITION TO BUILD UPON AND CONTRIBUTE TO THE PUBLIC TECHNOLOGY POOL:
// You are encouraged to redistribute, and build upon the technologies presented 
// in this source module and the accompanying article in Dr. Dobb's Journal provided 
// all the conditions listed in the MUSTREAD.TXT file, included with this 
// distribution, are met.
////////////////////////////////////////////////////////////////////////////////////

// play within limit of an integer, send/receive chunk blocks
// most WINSOCK implementation can only take 32k max at a time anyway
#define DATACHUNKSIZE    16000  
#define SENDSIZE		 72323     
#define DONE			999  // third state in additional to TRUE and FALSE
                                            
//
// enumerated protocol states, this is a minor experimentation to see
// if it is somehow possible to generalize and automate the protocol 
// handling process (via code generation).  As of printing deadline,
// experiment still on-going.
//                                            
enum TalkStates {
	S_RESET,
	S_ACK1,
	S_READTYPE,
	S_ACK2,    
	S_READSIZE,
	S_ACK3,    
	S_READDATA,
	S_ACK4
	} ;
	
///////////////////////////////////////////////////////////////////////////// 
class CPhoneView;          

class CTalkServer: public CSocketOwner
{                                
public:
	CTalkServer(); 
	~CTalkServer();

    WSSOCKET StartServer(HWND, NOTIFYPROC);
    WSSOCKET EndServer(WSSOCKET);
    BOOL GetBuffer(void);
    UINT DataRead(void);    
    void SendAck(void);
    virtual void OnOtherMsgs(int, int);
    virtual void OnReceiveCompleted(int, int);
    virtual void OnSendCompleted(int, int);
    virtual void OnDisconnected(int, int);

public:  
  CPhoneView * m_PhoneView;
private:  
  WSPORTID    m_uPort;
  WSADDRESS   m_lAddress;
  char        m_szBuffer[DATACHUNKSIZE];
  HGLOBAL	  m_hspeechBuffer;    
  HPSTR		  m_pBuffer;
  HPSTR		  m_pCurBuf; 
  ULONG		  m_bufSize;
  UINT		  m_compressionType;  
  BOOL		  m_speechReady;
  TalkStates  m_state; 

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

}; 


class CTalkListenServer: public CSockListenServer
{                                
public:
	CTalkListenServer(); 
	~CTalkListenServer();
	WSSOCKET StartListener(LPCSTR, WSPORTID, LPWSADDRESS, HWND, NOTIFYPROC,  CPhoneView *);

	virtual void OnOtherMsgs(int, int);
	                                         
protected:
     CPhoneView * m_PhoneView;
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
	
};

class CTalkClient: public CSocketOwner
{ 

public: // create from serialization only
	CTalkClient(); 
	~CTalkClient(); 
	// overload to connect by name or address
    WSSOCKET Connect( UINT prot, WSADDRESS, WSPORTID, UINT, HWND,
     NOTIFYPROC, UINT, HPSTR, ULONG);
	BOOL SetTimeout(WSSOCKET, UINT);
	BOOL End();

	UINT SendData(void); 
	void GetAck(void); 
	
	virtual void OnConnected(int, int);
	virtual void OnSendCompleted(int, int);
	virtual void OnReceiveCompleted(int, int);
	virtual void OnTimerExpired(int, int);	   
	virtual void OnDisconnected(int, int);

private:  
  BOOL        m_bConnected;
  WSADDRESS   m_lAddress;
  // some legacy variables from performance statistic gathering
  WSPORTID    m_uPort;
  WSADDRESS   m_lRecvAddress;
  WSPORTID    m_uRecvPort;
  UINT        m_uAttempts;
  UINT        m_uFailures;
  DWORD       m_dMin;
  DWORD       m_dAvg;
  DWORD       m_dMax;
  long double m_ldTotalTime;
  UINT        m_uSequence;     
  BOOL        m_bInProgress;
  UINT        m_uInterval;
  UINT        m_uLateReplies;
  UINT        m_uLimit;

  UINT        m_uErrorCount;
  ECHOPACKET  m_Packet;

  HPSTR	  	  m_talkBuffer;	
  HPSTR		  m_pCurBuf;  // sliding pointer for 'chunk' sending
  ULONG		  m_bufLen;  
  char		  m_szBuffer[WSTALKBUFFERSIZE];
  TalkStates  m_state;   
  UINT		  m_lastSentSize;
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

};
