#	This is a self-loading procedure that can tell whether a MasterCard
#	or Visa credit card number is plausible by constructing a special
#	checksum of the digits.   The checksum used for credit cards is
#	designed to catch transposed or incorrect digits.  For fun, try it
#	on the cards in your wallet!

#	Copyright (c) 1990 by Hamilton Laboratories.  All rights reserved.

proc mcvisa(card)
	local i, j, sum
	@ sum = 0
	# reverse the digits and discard any spaces.
	@ card = reverse(card)
	if (card =~ "* *") @ card = $card:gs/ //
	if (card =~ "*[^0-9]*") return "bad"
	for i = 1 to strlen(card) do
		@ j = substr(card, i, 1)
		if (i % 2 == 0) then
			@ j *= 2
			if (j >= 10) @ j -= 9;
		end
		@ sum += j
	end
	return sum % 10 == 0 ? "good" : "bad"
end

mcvisa $argv
