/*-------------------------------------------------------------------------
 AppRun.c

 A File run utility for AppBar.

 by
 GMP van kempen
 NEVERnever Software 1993

History:
4.00.1 First Beta release

4.00.2 Added Minimized/Normal/Maximized Buttons. Changed handling of command
       line parameters. Is now used as initial executable string. Fixed some
       small bugs.
4.00.3 Increased vertical size of editbox.

---------------------------------------------------------------------------*/
//compile with the strictest error checking
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <shellapi.h>
#include <ctl3d.h>
#include "apprun.h"

#define MAKECHILD(a,b,c,d,e,f,g,h) CreateWindow(a,b,WS_CHILD | WS_VISIBLE | c,d,e,f,g,hWnd,h,hInst,(LPSTR) NULL)
#define MAKEBUTTON(a,b,c,d,e,f)    MAKECHILD("button",a,BS_PUSHBUTTON,b,c,d,e,f)
#define MAKEDEFBUTTON(a,b,c,d,e,f)    MAKECHILD("button",a,BS_DEFPUSHBUTTON,b,c,d,e,f)
#define MAKERADIO(a,b,c,d,e,f)	   MAKECHILD("button",a,BS_RADIOBUTTON,b,c,d,e,f)
#define MAKETEXT(a,b,c,d,e)	   MAKECHILD("static",a,SS_LEFT,b,c,d,e,(HMENU) -1)
#define MAKESTATIC(a,b,c,d)	   MAKECHILD("static",NULL,SS_BLACKRECT,a,b,c,d,(HMENU) -1)
#define MAKEBORDER(a,b,c,d)	   MAKECHILD("static",NULL,SS_WHITERECT,a,b,c,d,(HMENU) -1)
#define MAKEEDIT(a,b,c,d,e)	   MAKECHILD("edit", "  ",WS_BORDER | ES_LEFT | ES_AUTOHSCROLL | ES_LOWERCASE,a,b,c,d,e)

char	    szAppName[] = "AppRun";
HINSTANCE   hInst;
HWND	    hWndEdit;
UINT	    ProgShow = SW_SHOWNORMAL;
int	    radiocheck = 1;
HWND	    hWndButton[3], hWndRadio[3];
FARPROC     lpfnOldEdit;


int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
		   LPSTR lpszCmdLine, int nCmdShow)
    {
    HWND	hWnd;
    MSG 	msg;
    WNDCLASS	wndclass;
    int 	xScreen, yScreen, yCaption, xSize, ySize;

    if(!hPrevInstance)
	{
	wndclass.style		    = CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc	    = WndProc;
	wndclass.cbClsExtra	    = 0;
	wndclass.cbWndExtra	    = 0;
	wndclass.hInstance	    = hInstance;
	wndclass.hIcon		    = LoadIcon(hInstance, szAppName);
	wndclass.hCursor	    = LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground	    = GetStockBrush(LTGRAY_BRUSH);
	wndclass.lpszMenuName	    = NULL;
	wndclass.lpszClassName	    = szAppName;

	RegisterClass(&wndclass);
	}

    hInst = hInstance;

    lstrcpy(szBuffer, lpszCmdLine);
    if(!strlen(szBuffer))
	szBuffer[0] = '\0';

    xScreen = GetSystemMetrics(SM_CXSCREEN);
    yScreen = GetSystemMetrics(SM_CYSCREEN);
    yCaption = GetSystemMetrics(SM_CYCAPTION);

    Ctl3dRegister(hInstance);
    Ctl3dAutoSubclass(hInstance);

    xSize = 280;
    ySize = 139 + yCaption;


    hWnd = CreateWindow(szAppName, "AppRun 4.0",
			WS_POPUP | WS_SYSMENU | WS_CAPTION |
			WS_MINIMIZEBOX | WS_VISIBLE,
			(xScreen - xSize)/2, yScreen/2 - ySize,
			xSize, ySize,
			NULL, (HMENU) NULL, hInstance, NULL);

    ShowWindow(hWnd, SW_SHOWNORMAL);
    UpdateWindow(hWnd);

    while(GetMessage(&msg, NULL, 0, 0))
	{
	TranslateMessage(&msg);
	DispatchMessage(&msg);
	}

    Ctl3dUnregister(hInstance);

    return msg.wParam;
    } /* end WinMain */

/*------------------------------------------------------------------------/
   FUNCTION: WndProc()
/------------------------------------------------------------------------*/
long WINAPI WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
    {
    char *Button[3] = {"&Cancel","&OK","&Browse"};
    char *Radio[3] = {"&Minimize","&Normal","M&aximize"};
    char EditBox[256];
    int i, DroppedFiles;
    HBRUSH hbrush;

    switch (message)
	{
	case WM_CREATE:
	    // create static frame around text fields
	    Ctl3dSubclassCtl(MAKEBORDER(0, 0, 278, 138));
	    Ctl3dSubclassCtl(MAKESTATIC(9, 9, 262, 88));
	    hWndButton[0] = MAKEBUTTON(Button[0], 20, 106, 80, 24, IDC_BUTTONS);
	    hWndButton[1] = MAKEBUTTON(Button[1], 100, 106, 80, 24, IDC_BUTTONS+1);
	    hWndButton[2] = MAKEBUTTON(Button[2], 180, 106, 80, 24, IDC_BUTTONS+2);
	    hWndRadio[0] = MAKERADIO(Radio[0], 15, 70, 80, 24, IDC_RADIO);
	    hWndRadio[1] = MAKERADIO(Radio[1], 105, 70, 75, 24, IDC_RADIO+1);
	    hWndRadio[2] = MAKERADIO(Radio[2], 180, 70, 85, 24,IDC_RADIO+2);
	    for(i=0;i<3;i++)
		Ctl3dSubclassCtl(hWndRadio[i]);
	    Ctl3dSubclassCtl(MAKETEXT("Program:", 20, 16, 100, 20));
	    hWndEdit = MAKEEDIT(20, 38, 240, 28, IDC_EDIT);
	    Ctl3dSubclassCtl(hWndEdit);
	    lpfnOldEdit = (FARPROC) GetWindowLong(hWndEdit, GWL_WNDPROC);
	    SetWindowLong(hWndEdit, GWL_WNDPROC,
		  (LONG) MakeProcInstance( (FARPROC) EditProc,
		  (HINSTANCE) GetWindowWord(hWnd, GWW_HINSTANCE)));
	    Edit_SetText(hWndEdit, szBuffer);
	    UpdateRadioButtons(radiocheck);
	    DragAcceptFiles(hWnd, TRUE);
	    SetFocus(hWndEdit);
	    return 0;

	case WM_SYSCOLORCHANGE:
           Ctl3dColorChange();
	   break;

	case WM_CTLCOLOR:
	    hbrush = Ctl3dCtlColorEx(message, wParam, lParam);
	    if(hbrush != (HBRUSH) FALSE)
		return hbrush;
	    else
		return DefWindowProc(hWnd, message, wParam, lParam);

       case WM_DROPFILES:
	    DroppedFiles = DragQueryFile((HANDLE) wParam, 0xFFFF, (LPSTR) NULL, 0);
	    for(i=0;i<DroppedFiles;i++)
		{
		DragQueryFile((HANDLE) wParam, i, szBuffer, sizeof(szBuffer));
		WinExec(szBuffer, SW_SHOWNORMAL);
		}
	    DragFinish((HANDLE) wParam);
	    return 0;

       case WM_COMMAND:
	    switch(wParam)
		{
		case IDC_EDIT:
		    if(HIWORD(lParam) == EN_KILLFOCUS)
			Edit_GetText(hWndEdit, EditBox, 255);
		    break;

		case IDC_BUTTONS:  /* Cancel */
		    SendMessage(hWnd, WM_DESTROY, 0, 0);
		    break;

		case IDC_BUTTONS+1:  /* Ok */
		    Edit_GetText(hWndEdit, EditBox, 255);
		    if(WinExec(EditBox, ProgShow) > 32)
			SendMessage(hWnd, WM_DESTROY, 0, 0);
		    break;

		case IDC_BUTTONS+2: /* Browse */
		    if(BrowseFile(hWnd, EditBox))
			Edit_SetText(hWndEdit, EditBox);
		    SetFocus(hWndEdit);
		    break;

		case IDC_RADIO: /* Minimized */
		    radiocheck = 0;
		    UpdateRadioButtons(0);
		    ProgShow = SW_SHOWMINIMIZED;
		    //SetFocus(hWndEdit);
		    break;

		case IDC_RADIO+1: /* Normal */
		    radiocheck = 1;
		    UpdateRadioButtons(1);
		    ProgShow = SW_SHOWNORMAL;
		    //SetFocus(hWndEdit);
		    break;

		case IDC_RADIO+2: /* Maximized */
		    radiocheck = 2;
		    UpdateRadioButtons(2);
		    ProgShow = SW_SHOWMAXIMIZED;
		    //SetFocus(hWndEdit);
		    break;
		}
	    break;

       case WM_DESTROY:	// kill the whole program
	    DragAcceptFiles(hWnd, FALSE);
	    PostQuitMessage(0);
	    return 0;
	}
    return DefWindowProc(hWnd, message, wParam, lParam);
    } /* end WndProc */

/*--------------------------------------------------------------------------*/
VOID UpdateRadioButtons(int iCurrentRB)
    {
    int i;

    for(i=0;i<3;i++)
	{
	if(i != iCurrentRB)
	    Button_SetCheck(hWndRadio[i], 0);
	else
	    Button_SetCheck(hWndRadio[i], 1);
	}
    }
