#define STRICT
#include <windows.h>
#include <shellapi.h>
#include <stdarg.h>
#include <stdio.h>
#include <ctype.h>
#include <direct.h>
#include <string.h>
#include "appmore.h"

/*--------------------------------------------------------------------------*/
/* FUNCTION: ProgExec(LPSTR lpCmdLine, int nCmdShow)			    */
/*									    */
/* PURPOSE:  changes current drive & directory and executes a program	    */
/*--------------------------------------------------------------------------*/
BOOL PASCAL ProgExec(HWND hWndParent, LPSTR lpszFile, LPSTR lpszParams, LPSTR lpszDir, int nCmdShow)
    {
    UINT ExecStatus;
    UINT ShowMode[3] = {SW_SHOWNORMAL, SW_SHOWMAXIMIZED, SW_SHOWMINIMIZED};

    // show maximum sized files as normal, resizing is done later
    if(nCmdShow == 3)
	nCmdShow = 0;
    // execute file
    ExecStatus = ShellExecute(hWndParent, "open", lpszFile, lpszParams, lpszDir, ShowMode[nCmdShow]);
    if(ExecStatus <= 32)
	{
	ExecuteErrorHandle(ExecStatus);
	return FALSE;
	}
    else
	return TRUE;
    }


/*---------------------------------------------------------------------------/
   Function : StartOrCloseProgram()
/---------------------------------------------------------------------------*/
VOID PASCAL StartOrCloseProgram(int iClose)
    {
    CheckProgStatus();
    if(AppButton[iClose].ProgStatus == NOTALIVE || !AppButton[iClose].Close)
	{
	iActive = iClose+1;
	if(AppSound.EnableSound != 0)
	    if(stricmp(AppSound.ProgramStart, "<none>") != 0)
		sndPlaySound(AppSound.ProgramStart, SND_ASYNC | SND_NODEFAULT);
	ProgExec(hWndMain, (LPSTR)AppButton[iClose].ProgName, (LPSTR)AppButton[iClose].Params, (LPSTR)AppButton[iClose].StartDir, AppButton[iClose].ShowMode);
	if(AppSystem.OneLaunch)
	    SendMessage(hWndMain, WM_DESTROY, 0, 0L);
	}
    else
	{
	if(IsWindow(AppButton[iClose].hWndApp))	//if program still exists, kill it.
	    {
	    if(AppSound.EnableSound != 0)
		if(stricmp(AppSound.ProgramClose, "<none>") != 0)
		    sndPlaySound(AppSound.ProgramClose, SND_ASYNC | SND_NODEFAULT);
	    if(CloseApp(AppButton[iClose].hWndApp))
		AppButton[iClose].ProgStatus = NOTALIVE;
	    InvalidateRect(hWndCurrentButton, (LPRECT) NULL, FALSE);
	    UpdateWindow(hWndCurrentButton);
	    }
	else	    // program doesn't exist anymore, start it again.
	    {
	    iActive = iClose+1;
	    if(AppSound.EnableSound != 0)
		if(stricmp(AppSound.ProgramStart, "<none>") != 0)
		    sndPlaySound(AppSound.ProgramStart, SND_ASYNC | SND_NODEFAULT);
	    ProgExec(hWndMain, (LPSTR)AppButton[iClose].ProgName, (LPSTR)AppButton[iClose].Params, (LPSTR)AppButton[iClose].StartDir, AppButton[iClose].ShowMode);
	    }
	}
    }

/*---------------------------------------------------------------------------/
/									     /
/  Function : CheckProgStatus() 					     /
/									     /
/  Purpose  : Updates the status of a program to the current status.	     /
/									     /
/---------------------------------------------------------------------------*/
VOID PASCAL CheckProgStatus(VOID)
    {
    int iCheck;

    for(iCheck=0;iCheck<AppWindow.nButtons;iCheck++)
	{
	if(AppButton[iCheck].ProgStatus == ALIVE)	   // AppMore thinks app[i] exists
	    {
	    if(!IsWindow(AppButton[iCheck].hWndApp))	   // app[i] doesn't exists anymore
		{
		AppButton[iCheck].ProgStatus = NOTALIVE;   // AppMore knows that now
		InvalidateRect(hWndButton[iCheck+1], (LPRECT) NULL, FALSE);
		}
	    }
	}
    }

/*--------------------------------------------------------------------------*/
VOID ExecuteErrorHandle(int iError)
    {
    switch(iError)
	{
	case 0:
	    strcpy(szBuffer,"Out of memory.");
	    break;

	case 2:
	    strcpy(szBuffer,"File not found.");
	    break;

	case 3:
	    strcpy(szBuffer,"Path not found.");
	    break;

	case 5:
	    strcpy(szBuffer,"Attempt to dynamically link to a task.");
	    break;

	case 6:
	    strcpy(szBuffer,"Library requires separate data segments\nfor each task.");
	    break;

	case 8:
	    strcpy(szBuffer,"Insufficient memory to start application.");
	    break;

	case 10:
	    strcpy(szBuffer,"Incorrect Windows version.");
	    break;

	case 11:
	    strcpy(szBuffer,"Invalid .EXE file.");
	    break;

	case 12:
	    strcpy(szBuffer,"OS/2 application.");
	    break;

	case 13:
	    strcpy(szBuffer,"DOS 4.0 application.");
	    break;

	case 14:
	    strcpy(szBuffer,"Unknown .EXE type.");
	    break;

	case 15:
	    strcpy(szBuffer,"Attempt to load a Windows 2.x .EXE in protected mode.");
	    break;

	case 16:
	    strcpy(szBuffer,"Attempt to load a 2nd instance of\nan .EXE with writeable data.");
	    break;

	case 17:
	    strcpy(szBuffer,"Attempt to link already used nonshareable DLLs\nin large-frame EMS mode.");
	    break;

	case 19:
	    strcpy(szBuffer,"Attempt to load compressed .EXE file.");
	    break;

	case 20:
	    strcpy(szBuffer,"Invalid DLL file.");
	    break;

	default:
	    sprintf(szBuffer,"Unknown File Execution Error (%d)",iError);
	    break;
	}
	OkMsgBox("AppMore - File Execution", "%s", szBuffer);
    }
