#define STRICT
#include <windows.h>
#include <windowsx.h>
#include "appsetup.h"

/*************************************************************************/
/*  FUNCTION: DlgAboutProc()						 */
/*									 */
/*  WindowProc for the AboutBox						 */
/*************************************************************************/
BOOL WINAPI AboutDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
    {
    HDC hDC;
    PAINTSTRUCT ps;
    RECT rc;

    switch(message)
	{
	case WM_INITDIALOG:
	    return TRUE;

	case WM_PAINT:
	    hDC = BeginPaint(hDlg, &ps);
	    rc = ps.rcPaint;
	    // draw a Bitmap in the AboutBox
	    DrawBitmap(hDC, rc.left+3*cxChar, rc.top+cyChar, hAppSetup);
	    EndPaint(hDlg, &ps);
	    break;

	case WM_COMMAND:
	    switch(wParam)
		{
		case IDOK:
		    EndDialog(hDlg, 0);
		    return TRUE;
		}
	    break;
	}
    return FALSE;
    } /* end DlgAboutProc */
