/*--------------------------------------------------------------------------/
 AppSetup.c

 AppBar Setup, Setup program for AppBar.exe.
 by
 GMP van kempen
 NEVERnever Software 1992

 history:
    1.0     initial release 
    1.0.1   added intialization window.	improved IniSave().
    1.0.2   added browse function (only for win31), added StartupInitalization
	    Improved ExitDlgBox. Improved redrawing icons and whole window.
	    changed ini-file (read and write).
    1.1     ported source to Windows 3.1. Made it STRICT and MACRO API compatible.
	    Uses ExtractIcon and DrawIcon to load and display icons. Optimized
	    IniRead() and IniSave(). Added IconNumber and ButtonLook options.
	    Added Directory Browse to InitDlg and StartDir. Improved InitEndDlg.
	    Changed SystemDlg's look. Added Sound Dlg. Fixed an annying bug, when
	    Appsetup was launched from AppBar. Fixed some little bugs. Got wrong
	    hDC after recieving WM_PAINT message. Improved looks main Window.
    2.0     Changed Button placement. Add Insert/Delete/MoveUp/MoveDown buttons.
	    Max Apps = 48. Add Params Edit Window. Changed look of Edit window
	    slightly. Made editwindows and static texts higher. Add 5th icon.
	    add maximum size option. Made Drag&Drop aware. Fixed problem with
	    browse programs and max columns. Fixed problems with saving new
	    settings in the Delete/Insert/MoveUp/MoveDown and parameter edit
	    Window functions. And also in the LoadExeIcon(). Exit/No will not
	    restart AppBar. If Save button is pushed, Exit Window is shown.
	    Make AppBar shell, will now give full path to AppBar if it can
	    find appbar, else just appbar.exe in a editwindow. Fixed problem
	    with Delete().
    4.0     Implemented use of Ctl3d.dll. Added Shell and About dialogwindows.
	    Added ExtraSystemButton buttongroup. Added browse to save shell
	    dialog. Added load=&run= lines to shellDialog. Added Help
	    Fixed bug, now possible to uninstall AppBar as shell.
	    Added No Sound for each program option.
	    Removed QuickExit option, this is now implemented in AppExit.
	    Increased size of the textstring of the radiobuttons (Normal-Max
	    Size). Solved some problems with the NoSound CheckBox.
	    Changed save method: now all buttonssettings are saved, not
	    just the buttons of which the properties are changed.  Made ude of
	    the AppLib.dll library. Change the behaviour of the EXIT button:
	    the restart dialog is now always displayed.

/--------------------------------------------------------------------------*/
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <shellapi.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "appsetup.h"

/* usefull global things */

HINSTANCE	hInst;	 /* global instance handle */
char		szAppName[] = "AppBar Setup";
HWND		hWnd;
HWND		hwndIcon[NUMICONS], hwndScroll, hwndEdit[NUMEDITS], hwndButton[NUMBUTTONS];
HWND		hwndText[NUMEDITS], hwndRadioButton[3], hwndCloseProg, hwndNext[2];
HWND		hwndButtonLook, hwndNoSound;
BOOL		bCurrentIcon[NUMICONS], bSave = FALSE;
BOOL		bNewDir = FALSE;
int		iCurrent = 0, iBlackIcon = 0, iPrevBlackIcon = 0, cxChar, cyChar;
int		MaxIconNumber[MAXAPPS];
FOCUS		nFocus = ICONFOCUS;
HBITMAP 	hAppSetup;
HICON		hIcon[MAXAPPS], hBlank, hIconTemp;
FARPROC 	lpfnOldEdit[NUMEDITS];
APPBARBUTTONS	AppButton[MAXAPPS], AppButtonDefault, AppButtonTemp;
APPSYSTEM	AppSystem, AppSystemNew;
APPSOUND	AppSound, AppSoundNew;
char		Directory[256] = "c:", TempStr[256];

/*------------ main window message handler -----------------------------*/

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int cmdShow)
{
    MSG msg;
    WNDCLASS wc;
    int	yCaption, xSize, ySize;

    hInst = hInstance;
    if(!hPrevInstance)
	{
	wc.style	 = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc	 = MainWndProc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = hInstance;
	wc.hCursor	 = LoadCursor(NULL, IDC_ARROW);
	wc.hIcon	 = LoadIcon(hInstance,"Icon");
	wc.hbrBackground = GetStockObject(LTGRAY_BRUSH);
	wc.lpszMenuName	 = NULL;
	wc.lpszClassName = szAppName;

	RegisterClass(&wc);
	}
    else
	{
	OkMsgBox("AppSetup","AppSetup is already running");
	return TRUE;
	}

    Ctl3dRegister(hInst);
    Ctl3dAutoSubclass(hInst);

    yCaption = GetSystemMetrics(SM_CYCAPTION);
    xSize = 514;
    ySize = 360 + yCaption;

    hWnd = CreateWindow(szAppName, szAppName,
			WS_POPUP | WS_SYSMENU | WS_CAPTION |
			WS_MINIMIZEBOX | WS_VISIBLE,
			50, 50, xSize, ySize,
			(HWND)NULL, (HMENU)NULL, hInstance, (LPSTR)NULL);
    
    if (!hWnd)
	return TRUE;

    ShowWindow(hWnd, cmdShow);
    UpdateWindow(hWnd);

    hAppSetup = LoadBitmap(hInst, "AppSetup");
    hBlank = LoadIcon(hInst, "Blank");

    while (GetMessage(&msg, NULL, 0, 0))
	{
	TranslateMessage(&msg);
	DispatchMessage(&msg);
	}

    Ctl3dUnregister(hInst);
    return (msg.wParam);
}
    
/*************************************************************************/
long WINAPI MainWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
    {
    static DLGPROC   lpfnSystemDlgProc, lpfnInitDlgProc, lpfnExitDlgProc;
    static DLGPROC   lpfnInitEndDlgProc, lpfnSelectDirDlgProc;
    static DLGPROC   lpfnUpgradeDlgProc, lpfnSoundDlgProc, lpfnShellDlgProc;
    LPDRAWITEMSTRUCT lpIconDIS;
    TEXTMETRIC	     tm;
    static HBRUSH    hHighLightBrush, hWhiteBrush;
    HBRUSH	     hbrush;
    RECT	     rc;
    BOOL	     bChanged = FALSE, bSavePushed = FALSE;
    char	     szDropFile[MAXFILECHARS];
    POINT	     DropPoint;
    int 	     i, OffsetFromBlackIcon, iDroppedIcon;


    switch(message) {

    case WM_CREATE:
	hHighLightBrush = CreateSolidBrush(GetSysColor(COLOR_HIGHLIGHT));
	hWhiteBrush = GetStockBrush(WHITE_BRUSH);

	IniRead();
	SetCursor(LoadCursor(NULL, IDC_WAIT));

	tm = RetrieveTextMetrics(hWnd);
	cxChar = tm.tmAveCharWidth;
	cyChar = tm.tmHeight;

	for(i=0;i<MAXAPPS;i++)
	     LoadIconFromFile(&hIcon[i], i);

	CreateAllChildWindows(hWnd, hInst);
	for(i=0;i<NUMICONS;i++)
	    bCurrentIcon[i] = FALSE;
	bCurrentIcon[iBlackIcon] = TRUE;
	SetScrollRange(hwndScroll, SB_CTL, 0, MAXAPPS-1, TRUE);
	SetScrollPos(hwndScroll, SB_CTL, 0, TRUE);
	UpdateScrollIcons(iBlackIcon);

	SetCursor(LoadCursor(NULL, IDC_ARROW));
	/*
	   AppSystem.Initialized = 0 : No use of AppBar before
				 = 1 : AppBar 3.20 and earlier
				 = 2 : AppBar 3.30
				 = 400 : AppBar 4.00
	*/
	if(!AppSystem.Initialized)
	    {
	    lpfnInitDlgProc = (DLGPROC) MakeProcInstance(InitDlgProc, hInst);
	    DialogBox(hInst, "InitDlg", hWnd, lpfnInitDlgProc);
	    FreeProcInstance((FARPROC) lpfnInitDlgProc);
	    }
	else
	    {
	    if(AppSystem.Initialized < APPBARVERSION)
		{
		lpfnUpgradeDlgProc = (DLGPROC) MakeProcInstance(UpgradeDlgProc, hInst);
		DialogBox(hInst, "UpgradeDlg", hWnd, lpfnUpgradeDlgProc);
		FreeProcInstance((FARPROC) lpfnUpgradeDlgProc);
		}
	    }
	DragAcceptFiles(hWnd, TRUE);
	bSave = FALSE;
	break;

    case WM_SYSCOLORCHANGE:
	Ctl3dColorChange();
	break;

    case WM_CTLCOLOR:
	hbrush = Ctl3dCtlColorEx(message, wParam, lParam);
	if(hbrush != (HBRUSH) FALSE)
	    return hbrush;
	else
	    return DefWindowProc(hWnd, message, wParam, lParam);

    case WM_VSCROLL:
	iPrevBlackIcon = iBlackIcon;
	switch(wParam)
	    {
	    case SB_LINEUP:
		iBlackIcon--;
		iCurrent--;
		break;

	    case SB_LINEDOWN:
		iBlackIcon++;
		iCurrent++;
		break;

	    case SB_PAGEUP:
		iCurrent -= NUMICONS;
		break;

	    case SB_PAGEDOWN:
		iCurrent += NUMICONS;
		break;

	    case SB_THUMBTRACK:
		iBlackIcon = LOWORD(lParam) % (MAXAPPS/NUMICONS);
		iCurrent = LOWORD(lParam);
		break;

	    default:
		break;
	    }
	iBlackIcon = max(0, min(iBlackIcon, NUMICONS-1));
	iCurrent = max(0, min(iCurrent, MAXAPPS-1));
	if(iCurrent < NUMICONS)
	    iBlackIcon = iCurrent;
	if(iCurrent > MAXAPPS-1 - NUMICONS)
	    iBlackIcon = NUMICONS-MAXAPPS+iCurrent;
	bCurrentIcon[iPrevBlackIcon] = FALSE;
	bCurrentIcon[iBlackIcon] = TRUE;
	UpdateEditWindows(iCurrent);
	UpdateRadioButtons(AppButton[iCurrent].ShowMode);
	UpdateNextButtons(iCurrent);
	UpdateCheckBoxes(iCurrent);
	if(iCurrent != GetScrollPos(hwndScroll, SB_CTL))
	    {
	    ScrollBar_SetPos(hwndScroll, iCurrent, TRUE);
	    for(i=0;i<NUMICONS;i++)
		InvalidateRect(hwndIcon[i], NULL, TRUE);
	    }
	break;

   case WM_SETFOCUS:
	SetFocus(hwndEdit[nFocus]);
	break;

    case WM_DRAWITEM:
	lpIconDIS = (LPDRAWITEMSTRUCT) lParam;
	OffsetFromBlackIcon = (int) (lpIconDIS->CtlID-IDC_ICONS) - iBlackIcon;
	// Draw an user-specified icon inside of the button
	CopyRect((LPRECT) &rc, &(lpIconDIS->rcItem));
	if(bCurrentIcon[lpIconDIS->CtlID-IDC_ICONS])
	    FillRect(lpIconDIS->hDC, (LPRECT) &rc, hHighLightBrush);
	else
	    FillRect(lpIconDIS->hDC, (LPRECT) &rc, hWhiteBrush);
	if(AppButton[iCurrent+OffsetFromBlackIcon].ButtonLook)
	    DrawIcon(lpIconDIS->hDC, rc.left+19, rc.top+18, hBlank);
	if(hIcon[iCurrent+OffsetFromBlackIcon] != NULL)
	    DrawIcon(lpIconDIS->hDC, rc.left+19, rc.top+18, hIcon[iCurrent+OffsetFromBlackIcon]);
	break;

    case WM_COMMAND:
	switch(wParam)
	    {
	    case IDC_ICONS:
		UpdateScrollIcons(0);
		break;

	    case IDC_ICONS+1:
		UpdateScrollIcons(1);
		break;

	    case IDC_ICONS+2:
		UpdateScrollIcons(2);
		break;

	    case IDC_ICONS+3:
		UpdateScrollIcons(3);
		break;

	    case IDC_ICONS+4:
		UpdateScrollIcons(4);
		break;

	    case IDC_RADIOS:
		UpdateRadioButtons(0);
		break;

	    case IDC_RADIOS+1:
		UpdateRadioButtons(1);
		break;

	    case IDC_RADIOS+2:
		UpdateRadioButtons(2);
		break;

	    case IDC_RADIOS+3:
		UpdateRadioButtons(3);
		break;

	    case IDC_CLOSEPROG:
		bSave = TRUE;
		AppButton[iCurrent].Close = Button_GetCheck(hwndCloseProg);
		break;

	    case IDC_NOSOUND:
		bSave = TRUE;
		AppButton[iCurrent].NoSound = Button_GetCheck(hwndNoSound);
		break;

	    case IDC_BUTTONLOOK:
		bSave = TRUE;
		AppButton[iCurrent].ButtonLook = Button_GetCheck(hwndButtonLook);
		InvalidateRect(hwndIcon[iBlackIcon], NULL, TRUE);
		UpdateWindow(hwndIcon[iBlackIcon]);
		break;

	    case IDC_NEXT:
		if(HIWORD(lParam) == BN_CLICKED)
		    Next(DOWN);
		break;

	    case IDC_NEXT+1:
		if(HIWORD(lParam) == BN_CLICKED)
		    Next(UP);
		break;

	    case IDC_EDITS: /* program edit */
		nFocus = EXEFOCUS;
		if(HIWORD(lParam) == EN_KILLFOCUS)
		    {
		    bSave = TRUE;
		    Edit_GetText(hwndEdit[0], AppButton[iCurrent].ProgName, MAXFILECHARS-1);
		    Edit_SetText(hwndEdit[0], AppButton[iCurrent].ProgName);
		    LoadExeIcon(&hIcon[iCurrent], iCurrent);
		    nFocus = EXEFOCUS;
		    }
		break;

	    case IDC_EDITS+1: /* parameter edit */
		nFocus = PARAMFOCUS;
		if(HIWORD(lParam) == EN_KILLFOCUS)
		    {
		    bSave = TRUE;
		    Edit_GetText(hwndEdit[1], AppButton[iCurrent].Params, MAXFILECHARS-1);
		    Edit_SetText(hwndEdit[1], AppButton[iCurrent].Params);
		    }
		break;

	    case IDC_EDITS+2: /* directory edit */
		nFocus = DIRFOCUS;
		if(HIWORD(lParam) == EN_KILLFOCUS)
		    {
		    bSave = TRUE;
		    Edit_GetText(hwndEdit[2], AppButton[iCurrent].StartDir, MAXFILECHARS-1);
		    Edit_SetText(hwndEdit[2], AppButton[iCurrent].StartDir);
		    }
		break;

	    case IDC_EDITS+3: /* icon edit */
		nFocus = ICONFOCUS;
		if(HIWORD(lParam) == EN_KILLFOCUS)
		    {
		    bSave = TRUE;
		    Edit_GetText(hwndEdit[3], AppButton[iCurrent].IcoName, MAXFILECHARS-1);
		    Edit_SetText(hwndEdit[3], AppButton[iCurrent].IcoName);
		    DestroyIcon(hIcon[iCurrent]);
		    LoadIconFromFile(&hIcon[iCurrent], iCurrent);
		    InvalidateRect(hwndIcon[iBlackIcon], NULL, TRUE);
		    UpdateNextButtons(iCurrent);
		    }
		break;

	    case IDC_BUTTONS: /* Save */
		IniSave();
		bSave = FALSE;
		bSavePushed = TRUE;
		break;

	    case IDC_BUTTONS+1:  /* Exit */
		if(AppSystem.Initialized < APPBARVERSION)
		    {
		    lpfnInitEndDlgProc = (DLGPROC) MakeProcInstance(InitEndDlgProc, hInst);
		    DialogBox(hInst, "InitEndDlg", hWnd, lpfnInitEndDlgProc);
		    FreeProcInstance((FARPROC) lpfnInitEndDlgProc);
		    }
		else
		    //if(bSave || bSavePushed)
		    {
		    lpfnExitDlgProc = (DLGPROC) MakeProcInstance(ExitDlgProc, hInst);
		    DialogBox(hInst, "ExitDlg", hWnd, lpfnExitDlgProc);
		    FreeProcInstance((FARPROC) lpfnExitDlgProc);
		    }
		    //else
		      //	SendMessage(hWnd, WM_DESTROY, 0, 0);
		break;

	    case IDC_BUTTONS+2:   /* Browse */
		switch(nFocus)
		    {
		    case DIRFOCUS:
			lpfnSelectDirDlgProc = (DLGPROC) MakeProcInstance(SelectDirDlgProc, hInst);
			DialogBox(hInst, "SelectDirDlg", hWnd, lpfnSelectDirDlgProc);
			FreeProcInstance((FARPROC) lpfnSelectDirDlgProc);
			if(bNewDir)
			    {
			    strcpy(AppButton[iCurrent].StartDir, Directory);
			    UpdateEditWindows(iCurrent);
			    bNewDir = FALSE;
			    }
			break;

		    case EXEFOCUS:
			if(BrowseFile(AppButton[iCurrent].ProgName, hWnd, EXEFILES))
			    {
			    UpdateEditWindows(iCurrent);
			    LoadExeIcon(&hIcon[iCurrent], iCurrent);
			    UpdateNextButtons(iCurrent);
			    }
			break;

		    case ICONFOCUS:
			if(BrowseFile(AppButton[iCurrent].IcoName, hWnd, ICONFILES))
			    {
			    DestroyIcon(hIcon[iCurrent]);
			    AppButton[iCurrent].IconNumber = 0;
			    LoadIconFromFile(&hIcon[iCurrent], iCurrent);
			    InvalidateRect(hwndIcon[iBlackIcon], NULL, FALSE);
			    UpdateNextButtons(iCurrent);
			    UpdateEditWindows(iCurrent);
			    }
			break;
		    }
		break;

	    case IDC_BUTTONS+3: /* system */
		lpfnSystemDlgProc = (DLGPROC) MakeProcInstance(SystemDlgProc, hInst);
		DialogBox(hInst, "SystemDlg", hWnd, lpfnSystemDlgProc);
		FreeProcInstance((FARPROC) lpfnSystemDlgProc);
		break;

	    case IDC_BUTTONS+4: /* shell */
		lpfnShellDlgProc = (DLGPROC) MakeProcInstance(ShellDlgProc, hInst);
		DialogBox(hInst, "ShellDlg", hWnd, lpfnShellDlgProc);
		FreeProcInstance((FARPROC) lpfnShellDlgProc);
		break;

	    case IDC_BUTTONS+5: /* sound */
		lpfnSoundDlgProc = (DLGPROC) MakeProcInstance(SoundDlgProc, hInst);
		DialogBox(hInst, "SoundDlg", hWnd, lpfnSoundDlgProc);
		FreeProcInstance((FARPROC) lpfnSoundDlgProc);
		break;

	    case IDC_BUTTONS+6: /* help */
		WinHelp(hWnd, "AppSetup.hlp",HELP_CONTENTS, 0L);
		break;

	    case IDC_BUTTONS+7: /* insert */
		Insert();
		break;

	    case IDC_BUTTONS+8: /* delete */
		Delete();
		break;

	    case IDC_BUTTONS+9: /* move up */
		MoveUp();
		break;

	    case IDC_BUTTONS+10: /* move down */
		MoveDown();
		break;
	    }
	break;

    case WM_DROPFILES:
	DragQueryPoint((HANDLE) wParam, (LPPOINT) &DropPoint);
	DragQueryFile((HANDLE) wParam, 0, szDropFile, sizeof(szDropFile));
	if(DropPoint.x < 100)
	    {
	    // file dropped over icon scrollbar
	    iDroppedIcon = 0;
	    while((iDroppedIcon*68+78) <= DropPoint.y)
		{
		iDroppedIcon++;
		if(iDroppedIcon > 100)
		    break;
		}
	    iDroppedIcon += (iCurrent-iBlackIcon);
	    strcpy(AppButton[iDroppedIcon].IcoName, szDropFile);
	    LoadIconFromFile(&hIcon[iDroppedIcon],iDroppedIcon);
	    if(iDroppedIcon == iCurrent)
		UpdateScrollIcons(iBlackIcon);
	    else
		{
		iDroppedIcon -= (iCurrent-iBlackIcon);
		InvalidateRect(hwndIcon[iDroppedIcon], NULL, TRUE);
		UpdateWindow(hwndIcon[iDroppedIcon]);
		}
	    }
	else
	    if(DropPoint.x < 400)
		{
		// file dropped over edit windows
		iDroppedIcon = 0;
		while((iDroppedIcon*60+90) <= DropPoint.y)
		    {
		    iDroppedIcon++;
		    if(iDroppedIcon > 10)
			break;
		    }
		if(iDroppedIcon == 0) // program editwindow
		    {
		    strcpy(AppButton[iCurrent].ProgName, szDropFile);
		    Edit_SetText(hwndEdit[0], AppButton[iCurrent].ProgName);
		    LoadExeIcon(&hIcon[iCurrent], iCurrent);
		    InvalidateRect(hwndIcon[iBlackIcon], NULL, TRUE);
		    UpdateWindow(hwndIcon[iDroppedIcon]);
		    }
		if(iDroppedIcon == 1) // params editwindow
		    {
		    strcpy(AppButton[iCurrent].Params, szDropFile);
		    Edit_SetText(hwndEdit[1], AppButton[iCurrent].Params);
		    }
		if(iDroppedIcon == 2) // working directory editwindow
		    {
		    strcpy(AppButton[iCurrent].StartDir, szDropFile);
		    Edit_SetText(hwndEdit[2], AppButton[iCurrent].StartDir);
		    }
		if(iDroppedIcon == 3) // icon editwindow
		    {
		    strcpy(AppButton[iCurrent].IcoName, szDropFile);
		    Edit_SetText(hwndEdit[3], AppButton[iCurrent].IcoName);
		    DestroyIcon(hIcon[iCurrent]);
		    LoadIconFromFile(&hIcon[iCurrent], iCurrent);
		    InvalidateRect(hwndIcon[iBlackIcon], NULL, TRUE);
		    UpdateNextButtons(iCurrent);
		    }
		}
	DragFinish((HANDLE) wParam);
	return 0;

    case WM_DESTROY:
	DragAcceptFiles(hWnd, FALSE);
	DeleteBrush(hHighLightBrush);
	DeleteBitmap(hAppSetup);
	PostQuitMessage(0);
        break;

    default:
        return DefWindowProc(hWnd, message, wParam, lParam);
        break;
    }
    return NULL;
    }
