#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "appsetup.h"

BOOL bAlreadyShell;
char run[256], load[256];

/*-------------------------------------------------------------------------*/
BOOL WINAPI ShellDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
    {
    static DLGPROC   lpfnSaveDlgProc;
    char	     szGroupFiles[8*MAXFILECHARS];
    BOOL	     bSigned = TRUE;

    switch(message)
	{
	case WM_INITDIALOG:
	    AppSystemNew = AppSystem;
	    ReadRunLoadIni((LPSTR) run, (LPSTR) load);
	    SetDlgItemText(hDlg, IDSHL_LOAD, load);
	    SetDlgItemText(hDlg, IDSHL_RUN, run);
	    SetDlgItemText(hDlg, IDSHL_SHELLGROUP, AppSystemNew.ShellGroup);
	    if(IsAppBarShell())
		{
		bAlreadyShell = TRUE;
		CheckDlgButton(hDlg, IDSHL_SHELL, TRUE);
		}
	    else
		bAlreadyShell = FALSE;
	    return TRUE;

	case WM_COMMAND:
	    switch(wParam)
		{
		case IDSHL_SHELLGROUP:
		    if(HIWORD(lParam) == EN_KILLFOCUS)
			{
			GetDlgItemText(hDlg, IDSHL_SHELLGROUP, AppSystemNew.ShellGroup, 4*MAXFILECHARS-1);
			SetDlgItemText(hDlg, IDSHL_SHELLGROUP, AppSystemNew.ShellGroup);
			}
		    return TRUE;

		case IDSHL_LOAD:
		    if(HIWORD(lParam) == EN_KILLFOCUS)
			{
			GetDlgItemText(hDlg, IDSHL_LOAD, load, 255);
			SetDlgItemText(hDlg, IDSHL_LOAD, load);
			}
		    return TRUE;

		case IDSHL_RUN:
		    if(HIWORD(lParam) == EN_KILLFOCUS)
			{
			GetDlgItemText(hDlg, IDSHL_RUN, run, 255);
			SetDlgItemText(hDlg, IDSHL_RUN, run);
			}
		    return TRUE;

		case IDSHL_SHELL:
		    CheckDlgButton(hDlg, IDSHL_SHELL, !IsDlgButtonChecked(hDlg, IDSHL_SHELL));
		    return TRUE;

		case IDSHL_BROWSE:
		    if(BrowseFile(szGroupFiles, hDlg, GROUPFILES))
			{
			strcpy(AppSystemNew.ShellGroup, szGroupFiles);
			SetDlgItemText(hDlg, IDSHL_SHELLGROUP, AppSystemNew.ShellGroup);
			}
		    return TRUE;

		case IDSHL_DEFAULT:
		    strcpy(AppSystemNew.ShellGroup, (LPSTR) SHELLGROUP_DEFAULT);
		    SetDlgItemText(hDlg, IDSHL_SHELLGROUP, (LPSTR) SHELLGROUP_DEFAULT);
		    return TRUE;

		case IDOK:
		    if((IsDlgButtonChecked(hDlg, IDSHL_SHELL) && !bAlreadyShell) ||
		       (!IsDlgButtonChecked(hDlg, IDSHL_SHELL) && bAlreadyShell))
			{
			lpfnSaveDlgProc = (DLGPROC) MakeProcInstance(SaveDlgProc, hInst);
			DialogBox(hInst, "SaveDlg", hDlg, lpfnSaveDlgProc);
			FreeProcInstance((FARPROC) lpfnSaveDlgProc);
			}
		    GetDlgItemText(hDlg, IDSHL_LOAD, load, 255);
		    GetDlgItemText(hDlg, IDSHL_RUN, run, 255);
		    SaveRunLoadIni((LPSTR) run, (LPSTR) load);
		    AppSystem = AppSystemNew;
		    bSave = TRUE;
		    EndDialog(hDlg, 0);
		    return TRUE;

		case IDSHL_HELP:
		    WinHelp(hWnd, "AppSetup.hlp",HELP_CONTENTS, 0L);
		    return TRUE;

		case IDCANCEL:
		    EndDialog(hDlg, 0);
		    return TRUE;
		}
	    break;
	}
    return FALSE;
    }
