#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <shellapi.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "morsetup.h"

char WindowsDir[MAXFILECHARS];
int temp;

#define WITHIN(val, min, max)	  (((temp=val) > max ? max : (temp < min) ? min : temp))
#define ONEORZERO(val)		  WITHIN((BOOL)val, 0, 1)

/*--------------------------------------------------------------------------*/
/* FUNCTION: IniRead(void)						    */
/*									    */
/* PURPOSE:  Read settings in the appbar.ini file.			    */
/*--------------------------------------------------------------------------*/
VOID PASCAL IniRead(VOID)
    {
    char ReadString[MAXDIGITS],IniString[20];
    char SystemSection[256], ButtonSection[256], SoundSection[256];
    int i, itemp;

    SetCursor(LoadCursor(NULL, IDC_WAIT));

    if(AppSystem.SectionNumber == 0)
	{
	for(i=0;i<MAXAPPS;i++)
	    AppButton[i] = AppButtonDefault;
	strcpy(AppSystem.SectionName, "<none>");
	SetCursor(LoadCursor(NULL, IDC_ARROW));
	return;
	}

    sprintf(IniString,"%d", AppSystem.SectionNumber);
    GetPrivateProfileString(INI_APPMORE, IniString, SECTIONNAME_DEFAULT,
			    AppSystem.SectionName, MAXFILECHARS-1, INI_FILE);

    // get ini-settings for AppSystem struct.
    strcpy(SystemSection, AppSystem.SectionName);
    strcat(SystemSection, "_System");
    strcpy(ButtonSection, AppSystem.SectionName);
    strcat(ButtonSection, "_Buttons");
    strcpy(SoundSection, AppSystem.SectionName);
    strcat(SoundSection, "_Sounds");

    for(i=0;i<MAXAPPS;i++)
	{
	bSaveButton[i] = FALSE;
	AppButton[i] = ReadButtonIni(i, (LPSTR)ButtonSection, (LPSTR) INI_FILE);
	}

    // get ini-settings for AppSystem struct.
    itemp = GetPrivateProfileInt(SystemSection, LEFT, LEFT_DEFAULT, INI_FILE);
    AppSystem.Left = WITHIN(itemp, -1, MAXRES);

    itemp = GetPrivateProfileInt(SystemSection, TOP, TOP_DEFAULT, INI_FILE);
    AppSystem.Top = WITHIN(itemp, -1, MAXRES);

    itemp = GetPrivateProfileInt(SystemSection, CLOSEALL, CLOSEALL_DEFAULT, INI_FILE);
    AppSystem.CloseAll = ONEORZERO(itemp);

    itemp = GetPrivateProfileInt(SystemSection, STAYINFRONT, STAYINFRONT_DEFAULT, INI_FILE);
    AppSystem.StayInFront = ONEORZERO(itemp);

    itemp = GetPrivateProfileInt(SystemSection, DOUBLECLICK, DOUBLECLICK_DEFAULT, INI_FILE);
    AppSystem.DoubleClick = ONEORZERO(itemp);

    itemp = GetPrivateProfileInt(SystemSection, BIGBUTTONS, BIGBUTTONS_DEFAULT, INI_FILE);
    AppSystem.BigButtons = ONEORZERO(itemp);

    itemp = GetPrivateProfileInt(SystemSection, INITIALIZED, INITIALIZED_DEFAULT, INI_FILE);
    AppSystem.Initialized = WITHIN(itemp, 0, APPMOREVERSION);

    itemp = GetPrivateProfileInt(SystemSection, BUTTONS, BUTTONS_DEFAULT, INI_FILE);
    AppSystem.Buttons = WITHIN(itemp, 1, MAXAPPS);

    itemp = GetPrivateProfileInt(SystemSection, COLUMNS, COLUMNS_DEFAULT, INI_FILE);
    AppSystem.Columns = WITHIN(itemp, 1, AppSystem.Buttons+1);

    itemp = GetPrivateProfileInt(SystemSection, BORDER, BORDER_DEFAULT, INI_FILE);
    AppSystem.Border = WITHIN(itemp, 0, MAXBORDER);

    GetPrivateProfileString(SystemSection, DEFAULTICONDIR, AppSystem.DefaultIconDir,
			   AppSystem.DefaultIconDir, MAXFILECHARS-1, INI_FILE);

    itemp = GetPrivateProfileInt(SystemSection, ONELAUNCH, ONELAUNCH_DEFAULT, INI_FILE);
    AppSystem.OneLaunch = WITHIN(itemp, 0, MAXBORDER);

    GetPrivateProfileString(SoundSection, SOUNDENABLE, SOUNDENABLE_DEFAULT,
		    ReadString, MAXDIGITS, INI_FILE);
    AppSound.EnableSound = atoi(ReadString);
    AppSound.EnableSound = max(AppSound.EnableSound, 0);
    AppSound.EnableSound = min(AppSound.EnableSound, 1);

    GetPrivateProfileString(SoundSection, PROGSTART, PROGSTART_DEFAULT,
		AppSound.ProgramStart, MAXFILECHARS-1, INI_FILE);

    GetPrivateProfileString(SoundSection, PROGCLOSE, PROGCLOSE_DEFAULT,
		AppSound.ProgramClose, MAXFILECHARS-1, INI_FILE);

    GetPrivateProfileString(SoundSection, DROPFILE, DROPFILE_DEFAULT,
		AppSound.DropFile, MAXFILECHARS-1, INI_FILE);

    GetPrivateProfileString(SoundSection, ERRORMESSAGE, ERRORMESSAGE_DEFAULT,
		AppSound.ErrorMessage, MAXFILECHARS-1, INI_FILE);

    SetCursor(LoadCursor(NULL, IDC_ARROW));
    }

/*--------------------------------------------------------------------------*/
/* FUNCTION: IniSave(void)						    */
/*									    */
/* PURPOSE:  Saves settings to the appbar.ini file.			    */
/*--------------------------------------------------------------------------*/
VOID PASCAL IniSave(VOID)
    {
    char SaveString[MAXDIGITS],IniString[20];
    int i;
    char SystemSection[256], ButtonSection[256], SoundSection[256];

    SetCursor(LoadCursor(NULL, IDC_WAIT));

    // get ini-settings for AppSystem struct.
    strcpy(SystemSection, AppSystem.SectionName);
    strcat(SystemSection, "_System");
    strcpy(ButtonSection, AppSystem.SectionName);
    strcat(ButtonSection, "_Buttons");
    strcpy(SoundSection, AppSystem.SectionName);
    strcat(SoundSection, "_Sounds");

    // Save ini-settings from AppButton struct.
    for(i=0;i<MAXAPPS;i++)
	    SaveButtonIni(AppButton[i], i, (LPSTR)ButtonSection, (LPSTR) INI_FILE);

    // Save ini-settings from AppSystem struct.
    sprintf(SaveString,"%d",AppSystem.Left);
    WritePrivateProfileString(SystemSection, LEFT, SaveString, INI_FILE);
    sprintf(SaveString,"%d",AppSystem.Top);
    WritePrivateProfileString(SystemSection, TOP, SaveString, INI_FILE);
    sprintf(SaveString,"%d",AppSystem.Columns);
    WritePrivateProfileString(SystemSection, COLUMNS, SaveString, INI_FILE);
    sprintf(SaveString,"%d",AppSystem.Buttons);
    WritePrivateProfileString(SystemSection, BUTTONS, SaveString, INI_FILE);
    sprintf(SaveString,"%d",AppSystem.OneLaunch);
    WritePrivateProfileString(SystemSection, ONELAUNCH, SaveString, INI_FILE);
    sprintf(SaveString,"%d",AppSystem.CloseAll);
    WritePrivateProfileString(SystemSection, CLOSEALL, SaveString, INI_FILE);
    sprintf(SaveString,"%d",AppSystem.StayInFront);
    WritePrivateProfileString(SystemSection, STAYINFRONT, SaveString, INI_FILE);
    sprintf(SaveString,"%d",AppSystem.DoubleClick);
    WritePrivateProfileString(SystemSection, DOUBLECLICK, SaveString, INI_FILE);
    sprintf(SaveString,"%d",AppSystem.BigButtons);
    WritePrivateProfileString(SystemSection, BIGBUTTONS, SaveString, INI_FILE);
    sprintf(SaveString,"%d",AppSystem.Border);
    WritePrivateProfileString(SystemSection, BORDER, SaveString, INI_FILE);

    // Save AppSound settings.
    sprintf(SaveString,"%d",AppSound.EnableSound);
    WritePrivateProfileString(SoundSection, SOUNDENABLE, SaveString, INI_FILE);
    WritePrivateProfileString(SoundSection, PROGSTART, AppSound.ProgramStart, INI_FILE);
    WritePrivateProfileString(SoundSection, PROGCLOSE, AppSound.ProgramClose, INI_FILE);
    WritePrivateProfileString(SoundSection, DROPFILE, AppSound.DropFile, INI_FILE);
    WritePrivateProfileString(SoundSection, ERRORMESSAGE, AppSound.ErrorMessage, INI_FILE);
    WritePrivateProfileString(INI_APPMORE, SOUNDDIR, AppSound.SoundDirectory, INI_FILE);
    SetCursor(LoadCursor(NULL, IDC_ARROW));
    }

/*------------------------------------------------------------------------*/
int VerifySectionName(LPSTR SectionName)
    {
    int i;
    char IniString[20];

    GetPrivateProfileString(INI_APPMORE, NUMBEROFSECTIONS, SECTIONS_DEFAULT,
				szBuffer, MAXDIGITS, INI_FILE);
    AppSystem.NumberOfSections = atoi(szBuffer);
    AppSystem.NumberOfSections = max(AppSystem.NumberOfSections, 0);

    if(AppSystem.NumberOfSections == 0)
	return 0;

    for(i=0;i<AppSystem.NumberOfSections;i++)
	{
	sprintf(IniString,"%d",i+1);
	GetPrivateProfileString(INI_APPMORE, IniString, SECTIONNAME_DEFAULT,
				szBuffer, MAXFILECHARS-1, INI_FILE);
	if(strcmp(szBuffer,SectionName) == 0)
	    return (i+1);
	}
    return 0;
    }

/*-------------------------------------------------------------------------*/
VOID AddSectionName(LPSTR NewSectionName)
    {
    char IniString[20];

    AppSystem.NumberOfSections++;
    sprintf(IniString,"%d",AppSystem.NumberOfSections);
    WritePrivateProfileString(INI_APPMORE, IniString, NewSectionName, INI_FILE);
    WritePrivateProfileString(INI_APPMORE, NUMBEROFSECTIONS, IniString, INI_FILE);
    }

/*-------------------------------------------------------------------------*/
VOID DeleteSectionName(LPSTR OldSectionName)
    {
    char IniString[20];
    int SectionNumber, i;

    SectionNumber = VerifySectionName(OldSectionName);
    for(i=SectionNumber;i<AppSystem.NumberOfSections;i++)
	{
	sprintf(IniString,"%d",i+1);
	GetPrivateProfileString(INI_APPMORE, IniString, SECTIONNAME_DEFAULT,
				szBuffer, MAXFILECHARS-1, INI_FILE);
	sprintf(IniString,"%d",i);
	WritePrivateProfileString(INI_APPMORE, IniString, szBuffer, INI_FILE);
	}
    AppSystem.NumberOfSections--;
    sprintf(IniString,"%d",AppSystem.NumberOfSections);
    WritePrivateProfileString(INI_APPMORE, NUMBEROFSECTIONS, IniString, INI_FILE);
    }

/*--------------------------------------------------------------------------*/
VOID InitDefaultButton(VOID)
    {
    char ReadString[MAXDIGITS];

    GetWindowsDirectory(WindowsDir, MAXFILECHARS);

    AppButtonDefault = InitButton();

    AppSound.EnableSound = 0;
    strcpy(AppSound.ProgramStart, PROGSTART_DEFAULT);
    strcpy(AppSound.ProgramClose, PROGCLOSE_DEFAULT);
    strcpy(AppSound.DropFile, DROPFILE_DEFAULT);
    strcpy(AppSound.ErrorMessage, ERRORMESSAGE_DEFAULT);

    GetPrivateProfileString(INI_APPMORE, INITIALIZED, INITIALIZED_DEFAULT,
			    ReadString, MAXDIGITS, INI_FILE);
    AppSystem.Initialized = atoi(ReadString);
    AppSystem.Initialized = max(AppSystem.Initialized, 0);

    strcpy(AppSystem.DefaultIconDir,"");
    GetPrivateProfileString(INI_APPMORE, DEFAULTICONDIR, AppSystem.DefaultIconDir,
		AppSystem.DefaultIconDir, MAXFILECHARS-1, INI_FILE);

    GetPrivateProfileString(INI_APPMORE, SOUNDDIR, WindowsDir,
		AppSound.SoundDirectory, MAXFILECHARS-1, INI_FILE);
    }
