/* Ownerb.h */
#include <ctl3d.h>

#define WM_APPBAR_RESTART	    (WM_USER+1001)

#define IDC_SCROLL		    101
#define IDC_CLOSEPROG		    102
#define IDC_BUTTONLOOK		    103
#define IDC_NOSOUND		    104
#define IDC_ICONS		    110
#define IDC_BUTTONS		    120
#define IDC_EDITS		    140
#define IDC_TEXTS		    150
#define IDC_RADIOS		    160
#define IDC_NEXT		    170

#define IDD_STAYINFRONT 	    200
#define IDD_ONELAUNCH		    201
#define IDD_CLOSEALL		    202
#define IDD_DEFAULT		    203
#define IDD_DOUBLECLICK		    204
#define IDD_BROWSE		    205
#define IDD_BIGBUTTONS		    206
#define IDD_TOP			    210
#define IDD_SCROLLTOP		    211
#define IDD_LEFT		    220
#define IDD_SCROLLLEFT		    221
#define IDD_BUTTONS		    230
#define IDD_SCROLLBUTTONS	    231
#define IDD_BORDER		    242
#define IDD_SCROLLBORDER	    243
#define IDD_HELP		    251
#define IDD_ROWS		    240
#define IDD_SCROLLROWS		    241
#define IDD_ABOUT		    252

#define IDINIT_INIT		    300
#define IDINIT_CANCEL		    301
#define IDINIT_OK		    302
#define IDINIT_BROWSE		    303

#define IDEXIT_NO		    400
#define IDEXIT_CANCEL		    401
#define IDEXIT_OK		    402
#define IDEXIT_RESTART		    403

#define IDDIR_OK		    600
#define IDDIR_CANCEL		    601
#define IDDIR_LIST		    602
#define IDDIR_PATH		    603
#define IDDIR_TEXT		    604

#define IDSOUND_OK		    700
#define IDSOUND_CANCEL		    701
#define IDSOUND_TEST		    702
#define IDSOUND_BROWSE		    703
#define IDSOUND_NONE		    704
#define IDSOUND_ENABLE		    705
#define IDSOUND_PROGSTART	    709
#define IDSOUND_PROGCLOSE	    710
#define IDSOUND_DROPFILE	    711
#define IDSOUND_ERROR		    712
#define IDSOUND_SOUNDDIR	    713
#define IDSOUND_HELP		    714

#define IDSECTION_OK		    801
#define IDSECTION_CANCEL	    802
#define IDSECTION_DELETE	    803
#define IDSECTION_NEW		    804
#define IDSECTION_LIST		    805
#define IDSECTION_ADD		    806
#define IDSECTION_CURRENT	    807

#define IDSAVE_TEXT		    901
#define IDSAVE_OK		    902
#define IDSAVE_NO		    903

#define INI_APPMORE	"AppMore"
#define INI_FILE	"appmore.ini"

#define LEFT		"Left"
#define TOP		"Top"
#define COLUMNS		"Columns"
#define BUTTONS 	"Buttons"
#define ONELAUNCH	"OneLaunch"
#define CLOSEALL	"CloseAll"
#define DOUBLECLICK	"DoubleClick"
#define BIGBUTTONS	"BigButtons"
#define BORDER		"Border"
#define STAYINFRONT	"StayInFront"
#define INITIALIZED	"Initialized"
#define DEFAULTICONDIR	"IconDirectory"
#define NUMBEROFSECTIONS "NumberOfSections"

#define SOUNDENABLE	"EnableSound"
#define PROGSTART	"ProgramStart"
#define PROGCLOSE	"ProgramClose"
#define DROPFILE	"DropFile"
#define ERRORMESSAGE	"ErrorMessage"
#define SOUNDDIR	"SoundDirectory"

#define ONELAUNCH_DEFAULT   0
#define SECTIONS_DEFAULT    "0"
#define SECTIONNAME_DEFAULT "<none>"
#define LEFT_DEFAULT	    -1
#define TOP_DEFAULT	    -1
#define COLUMNS_DEFAULT	    1
#define BUTTONS_DEFAULT     8
#define CLOSEALL_DEFAULT    1
#define NOSOUND_DEFAULT     0
#define CLOSEPROG_DEFAULT   1
#define SHOWMODE_DEFAULT    0
#define STAYINFRONT_DEFAULT 0
#define INITIALIZED_DEFAULT 0
#define ICONNUMBER_DEFAULT  0
#define BUTTONLOOK_DEFAULT  0
#define BIGBUTTONS_DEFAULT  0
#define DOUBLECLICK_DEFAULT 0
#define BORDER_DEFAULT	    0
#define SHELLGROUP_DEFAULT  "startup.grp"

#define SOUNDENABLE_DEFAULT	"0"
#define PROGSTART_DEFAULT	"<none>"
#define PROGCLOSE_DEFAULT	"<none>"
#define DROPFILE_DEFAULT	"<none>"
#define ERRORMESSAGE_DEFAULT	"<none>"


#define MAXFILECHARS	70
#define MAXDIGITS	5
#define NUMICONS	5
#define NUMEDITS	4
#define NUMBUTTONS	11
#define MAXAPPS 	48
#define MAXRES		1280
#define MAXBORDER	15
#define UP		1
#define DOWN		0

#define APPMOREVERSION	400

typedef enum {NOTALIVE = FALSE, ALIVE = TRUE} STATUS;

typedef struct {
	char	IcoName[MAXFILECHARS];
	char	ProgName[MAXFILECHARS];
	char	StartDir[MAXFILECHARS];
	char	Params[MAXFILECHARS];
	HWND	hWndApp;
	int	IconNumber;
	BOOL	ButtonLook;
	STATUS	ProgStatus;
	BOOL	Close;
	short	ShowMode;
	BOOL	NoSound;
	} APPBARBUTTONS;

typedef struct {
	short	Left;
	short	Top;
	int	Columns;
	int	Buttons;
	int	OneLaunch;
	int	CloseAll;
	int	DoubleClick;
	int	StayInFront;
	int	Initialized;
	BOOL	BigButtons;
	int	Border;
	int	SectionNumber;
	int	NumberOfSections;
	char	SectionName[MAXFILECHARS];
	char	DefaultIconDir[MAXFILECHARS];
	} APPSYSTEM;

typedef struct {
	int	EnableSound;
	char	ProgramStart[MAXFILECHARS];
	char	ProgramClose[MAXFILECHARS];
	char	DropFile[MAXFILECHARS];
	char	ErrorMessage[MAXFILECHARS];
	char	SoundDirectory[MAXFILECHARS];
	} APPSOUND;

typedef enum {EXEFOCUS = 0, PARAMFOCUS = 1, DIRFOCUS = 2, ICONFOCUS = 3} FOCUS;
typedef enum {ICONFILES = 0, EXEFILES = 1, WAVEFILES = 2} BROWSEFILES;

char szBuffer[256];
extern APPBARBUTTONS AppButton[MAXAPPS], AppButtonDefault, AppButtonTemp;
extern APPSYSTEM     AppSystem, AppSystemNew;
extern APPSOUND      AppSound, AppSoundNew;
extern HWND	     hwndIcon[NUMICONS], hwndScroll, hwndEdit[NUMEDITS];
extern HWND	     hWnd, hwndButton[NUMBUTTONS], hwndText[NUMEDITS];
extern HWND	     hwndRadioButton[3], hwndCloseProg, hwndNext[2];
extern HWND	     hwndButtonLook, hwndNoSound;
extern HINSTANCE     hInst;
extern HICON	     hIcon[MAXAPPS], hIconTemp;
extern HBITMAP	     hAppSetup;
extern BOOL	     bSave, bCreate, bSaveButton[MAXAPPS];
extern BOOL	     bCurrentIcon[NUMICONS], bNewDir;
extern int	     iCurrent, iBlackIcon, iPrevBlackIcon;
extern int	     MaxIconNumber[MAXAPPS], cxChar, cyChar;
extern FOCUS	     nFocus;
extern FARPROC	     lpfnOldEdit[NUMEDITS];
extern char	     Directory[256], TempStr[256], szSectionName[256];

/* defined in ownerb.c */
long WINAPI MainWndProc(HWND, UINT, WPARAM, LPARAM);

/* defined in appedit.c */
long WINAPI EditProc(HWND, UINT, WPARAM, LPARAM);

/* defined in init.c */
extern BOOL InitFirstInstance(HINSTANCE);

/* defined in border.c */
extern VOID InnerBorder(HDC hDC, RECT rect);

/* defined in AppIni.c */
extern VOID PASCAL IniRead(VOID);
extern VOID PASCAL IniSave(VOID);
extern int VerifySectionName(LPSTR szSectionName);
extern VOID AddSectionName(LPSTR NewSectionName);
extern VOID DeleteSectionName(LPSTR OldSectionName);
extern VOID InitDefaultButton(VOID);

/* defined in AppChild.c */
extern VOID UpdateEditWindows(int iCurrent);
extern VOID UpdateRadioButtons(int iCurrentRB);
extern VOID UpdateCheckBoxes(int iCurrent);
extern VOID UpdateScrollIcons(int iCurrentIcon);
extern VOID UpdateNextButtons(int);
extern VOID CreateAllChildWindows(HWND hWnd, HINSTANCE hInst);
extern VOID Insert(VOID);
extern VOID Delete(VOID);
extern VOID MoveUp(VOID);
extern VOID MoveDown(VOID);
extern VOID Next(int i);

/* defined in AppTools.c */
extern VOID OkMsgBox(char *szCaption, char *szFormat, ...);
extern VOID ErrorMsgBox(char *szCaption, char *szFormat, ...);
extern VOID LoadIconFromFile(HICON *hIcon, int i);
extern HBRUSH SetColorLightGray(HWND, HDC);
extern HBRUSH SetColorStaticText(HWND, HDC);
extern VOID LoadExeIcon(HICON *hIcon, int iCurrent);
VOID PASCAL SetCaption(HWND hWndCaption, LPSTR CaptionName);

/* defined in appsys.c */
BOOL WINAPI SystemDlgProc(HWND, UINT, WPARAM, LPARAM);

/* defined in appinit.c */
BOOL WINAPI InitDlgProc(HWND, UINT, WPARAM, LPARAM);

/* defined in appexit.c */
BOOL WINAPI ExitDlgProc(HWND, UINT, WPARAM, LPARAM);

/* defined in appbrows.c */
extern BOOL PASCAL BrowseFile(char *FileName, HWND hWndCommDlgParent, BROWSEFILES FileType);
BOOL WINAPI SelectDirDlgProc(HWND, UINT, WPARAM, LPARAM);
extern void UpdateListBox(HWND hDlg);
extern UINT GetListBoxIndex(HWND hDlg);
extern void FileErrorHandler(void);

/* defined in appsound.c */
BOOL WINAPI SoundDlgProc(HWND, UINT, WPARAM, LPARAM);

/* defined in appsectn.c */
BOOL WINAPI SectionDlgProc(HWND, UINT, WPARAM, LPARAM);

/* defined in appsave.c */
BOOL WINAPI SaveDlgProc(HWND, UINT, WPARAM, LPARAM);

/* defined in AppAbout.c */
extern BOOL WINAPI AboutDlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

/*defined in AppBar.dll */
extern TEXTMETRIC WINAPI RetrieveTextMetrics(HWND hWnd);
extern void	  WINAPI DrawBitmap(HDC hDC, short x, short y, HBITMAP hBitmap);
extern APPBARBUTTONS WINAPI ReadButtonIni(int i, LPSTR SectionName, LPSTR IniFile);
extern VOID WINAPI SaveButtonIni(APPBARBUTTONS AppButton, int i, LPSTR SectionName, LPSTR IniFile);
extern APPBARBUTTONS WINAPI InitButton(VOID);
