/*-------------------------------------------------------------------------
 AppTask.c

 A Task Manager.

 by
 GMP van kempen
 NEVERnever Software 1993

History:
    4.00.1, first thing
    4.00.2, added setup dialog box, Second Instance is not allowed, but will
	    send a WM_ACTIAVTE to first instance.

---------------------------------------------------------------------------*/

//compile with the strictest error checking
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <shellapi.h>
#include <ctl3d.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "apptask.h"

#define MAKECHILD(a,b,c,d,e,f,g,h) CreateWindow(a,b,WS_CHILD | WS_VISIBLE | c,d,e,f,g,hWnd,h,hInst,(LPSTR) NULL)
#define MAKEBUTTON(a,b,c,d,e,f)    MAKECHILD("button",a,BS_PUSHBUTTON,b,c,d,e,f)
#define MAKELISTBOX(a,b,c,d,e)	   MAKECHILD("listbox",NULL,LBS_NOTIFY | WS_BORDER | WS_VSCROLL,a,b,c,d,e)
#define MAKESTATIC(a,b,c,d)	   MAKECHILD("static",NULL,SS_BLACKRECT,a,b,c,d,(HMENU) -1)
#define MAKEBORDER(a,b,c,d)	   MAKECHILD("static",NULL,SS_WHITERECT,a,b,c,d,(HMENU) -1)

#define NORMALIZE(a)	ShowWindow(a,SW_SHOWNORMAL)
#define ICONIZE(a)	ShowWindow(a,SW_SHOWMINNOACTIVE)
#define MAXIMIZE(a)	ShowWindow(a,SW_MAXIMIZE)

#define MAXAPPS  64

char	    szAppName[] = "AppTask";
HINSTANCE   hInst;
HWND	    hWndAppTask, hWndListBox, hWndApp[MAXAPPS];
BOOL	    bSetupLaunched, bTaskMan = FALSE;

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
		   LPSTR lpszCmdLine, int nCmdShow)
    {
    HWND	hWnd;
    MSG 	msg;
    WNDCLASS	wndclass;
    int 	xScreen, yScreen, yCaption, xSize, ySize;

    if(!hPrevInstance)
	{
	wndclass.style		    = CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc	    = WndProc;
	wndclass.cbClsExtra	    = 0;
	wndclass.cbWndExtra	    = 0;
	wndclass.hInstance	    = hInstance;
	wndclass.hIcon		    = LoadIcon(hInstance, szAppName);
	wndclass.hCursor	    = LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground	    = GetStockBrush(LTGRAY_BRUSH);
	wndclass.lpszMenuName	    = NULL;
	wndclass.lpszClassName	    = szAppName;

	RegisterClass(&wndclass);
	}
    // allow only one instance at one time
    else
	{
	//BringWindowToTop(hWndAppTask);
	//SendMessage(hWndAppTask, WM_QUIT, 0, 0L);
	return TRUE;
	//hInstance = hPrevInstance;
	}

    hInst = hInstance;

    xScreen = GetSystemMetrics(SM_CXSCREEN);
    yScreen = GetSystemMetrics(SM_CYSCREEN);
    yCaption = GetSystemMetrics(SM_CYCAPTION);

    Ctl3dRegister(hInstance);
    Ctl3dAutoSubclass(hInstance);

    xSize = 275;
    ySize = 163 + yCaption;

    hWnd = CreateWindow(szAppName, "AppTask 4.0",
			WS_POPUP | WS_SYSMENU | WS_CAPTION |
			WS_MINIMIZEBOX | WS_VISIBLE,
			(xScreen - xSize)/2, yScreen/2 - ySize,
			xSize, ySize,
			NULL, (HMENU) NULL, hInstance, NULL);

    hWndAppTask = hWnd;

    ShowWindow(hWnd, SW_SHOWNORMAL);
    UpdateWindow(hWnd);

    while(GetMessage(&msg, NULL, 0, 0))
	{
	TranslateMessage(&msg);
	DispatchMessage(&msg);
	}

    Ctl3dUnregister(hInstance);

    return msg.wParam;
    } /* end WinMain */

/*------------------------------------------------------------------------/
   FUNCTION: WndProc()
/------------------------------------------------------------------------*/
long WINAPI WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
    {
    static DLGPROC lpfnSetupDlgProc;
    char *FirstButton[3] = {"&Minimize","To&Front","M&aximize"};
    char *SecondButton[3] = {"&Setup","&Cancel","&End Task"};
    int i;
    HBRUSH hbrush;
    HWND hWndButton[6];


    switch (message)
	{
	case WM_CREATE:
	    /* read ShowAll setting */
	    GetPrivateProfileString("AppTask", "ShowAll", "0", szBuffer, 255, "AppTools.ini");
	    ShowAll = ONEORZERO(atoi(szBuffer));

	    /* read Close on deactivation setting */
	    GetPrivateProfileString("AppTask", "CloseDeAct", "0", szBuffer, 255, "AppTools.ini");
	    CloseDeAct = ONEORZERO(atoi(szBuffer));

	    /* read CloseMode setting */
	    GetPrivateProfileString("AppTask", "CloseMode", "0", szBuffer, 255, "AppTools.ini");
	    CloseMode = WITHIN(atoi(szBuffer),0,2);

	    // create static frame around text fields
	    Ctl3dSubclassCtl(MAKEBORDER(0, 0, 273, 162));
	    hWndListBox = MAKELISTBOX(10, 10, 255, 80, IDC_LISTBOX);
	    Ctl3dSubclassCtl(hWndListBox);
	    for(i=0;i<3;i++)
		hWndButton[i] = MAKEBUTTON(FirstButton[i], 10+i*85, 100, 80, 24,
					   IDC_BUTTONS+i);
	    for(i=0;i<3;i++)
		hWndButton[i+3] = MAKEBUTTON(SecondButton[i], 10+i*85, 130, 80, 24,
					   IDC_BUTTONS+i+3);
	    UpdateListBox(hWndListBox);
	    GetPrivateProfileString("boot", "taskman.exe", "  ", szBuffer, 255, "system.ini");
	    if(strstr(AnsiLower(szBuffer),"apptask.exe"))
		bTaskMan = TRUE;
	    return 0;

	case WM_SYSCOLORCHANGE:
           Ctl3dColorChange();
	   break;

	case WM_CTLCOLOR:
	    hbrush = Ctl3dCtlColorEx(message, wParam, lParam);
	    if(hbrush != (HBRUSH) FALSE)
		return hbrush;
	    else
		return DefWindowProc(hWnd, message, wParam, lParam);

       case WM_COMMAND:
	    switch(wParam)
		{
		case IDC_BUTTONS: /* minimize */
		    ICONIZE(hWndApp[ListBox_GetCurSel(hWndListBox)]);
		    break;

		case IDC_BUTTONS+1:  /* tofront */
		    if(IsIconic(hWndApp[ListBox_GetCurSel(hWndListBox)]))
			NORMALIZE(hWndApp[ListBox_GetCurSel(hWndListBox)]);
		    BringWindowToTop(hWndApp[ListBox_GetCurSel(hWndListBox)]);
		    break;

		case IDC_BUTTONS+2: /* maximize	*/
		    MAXIMIZE(hWndApp[ListBox_GetCurSel(hWndListBox)]);
		    SendMessage(hWnd, WM_DESTROY, 0, 0L);
		    break;

		case IDC_BUTTONS+3: /* setup */
		    bSetupLaunched = TRUE;
		    lpfnSetupDlgProc = (DLGPROC) MakeProcInstance(SetupDlgProc, hInst);
		    DialogBox(hInst, "SetupDlg", hWnd, lpfnSetupDlgProc);
		    FreeProcInstance((FARPROC) lpfnSetupDlgProc);
		    bSetupLaunched = FALSE;
		    UpdateListBox(hWndListBox);
		    break;

		case IDC_BUTTONS+4: /* cancel */
		    SendMessage(hWnd, WM_DESTROY, 0, 0L);
		    break;

		case IDC_BUTTONS+5: /* close task */
		    if(CloseMode == 0)
			CloseApp(hWndApp[ListBox_GetCurSel(hWndListBox)]);
		    if(CloseMode == 1)
			SendMessage(hWndApp[ListBox_GetCurSel(hWndListBox)], WM_DESTROY, 0, 0L);
		    if(CloseMode == 2)
			SendMessage(hWndApp[ListBox_GetCurSel(hWndListBox)], WM_QUIT, 0, 0L);
		    UpdateListBox(hWndListBox);
		    break;
		}
	    break;

       case WM_ACTIVATE:
	    if((wParam == WA_ACTIVE) || (wParam == WA_CLICKACTIVE))
		UpdateListBox(hWndListBox);
	    if((wParam == WA_INACTIVE) && CloseDeAct && !bSetupLaunched)
		SendMessage(hWnd, WM_DESTROY, 0, 0L);
	    if((wParam == WA_INACTIVE) && bTaskMan && !bSetupLaunched)
		SendMessage(hWnd, WM_DESTROY, 0, 0L);
	    return 0;

       case WM_ACTIVATEAPP:
	    UpdateListBox(hWndListBox);
	    return 0;

       case WM_DESTROY:	// kill the whole program
	    PostQuitMessage(0);
	    return 0;
	}
    return DefWindowProc(hWnd, message, wParam, lParam);
    } /* end WndProc */

/*--------------------------------------------------------------------------*/
void UpdateListBox(HWND hWndListBox)
    {
    HWND hWhatEver = GetActiveWindow();
    char szWinText[256];
    int i = 0;

    ListBox_ResetContent(hWndListBox);
    while ((hWhatEver != NULL) && ( i < MAXAPPS))
	{
	if(IsWindowVisible(hWhatEver) || ShowAll)
	    {
	    if(GetWindowText(hWhatEver, (LPSTR) szWinText, 255) != 0)
		{
		if(strstr(szWinText, "AppTask 4.0") == NULL)
		    {
		    hWndApp[i++] = hWhatEver;
		    ListBox_InsertString(hWndListBox, szWinText, -1);
		    }
		}
	    }
	hWhatEver = GetWindow(hWhatEver, GW_HWNDNEXT);
	}
    ListBox_SetCurSel(hWndListBox, 0);
    }
