//----------------------------------------------------------------------
// File name: appgrp.c				  Creation date: 921006
//
// Abstract:  This is a source file to show how to read the Windows 
//            3.1 group file.  Please note that all of this may change 
//            in a future release of the Windows operating system.
//    
//            This program works by going out and finding the PROGMAN.INI
//            file.  A sample PROGMAN.INI file looks like the following:
//
//            [Settings]
//              Window=428 465 1011 733 1
//              SaveSettings=0
//              display.drv=8514.drv
//		Order= 6 4 2 9 3 8 1 7 5
//            [Groups]
//              Group1=C:\WINDOWS\MAIN0.GRP
//              Group2=C:\WINDOWS\ACCESSO0.GRP
//              Group4=C:\WINDOWS\STARTUP.GRP
//              Group5=C:\WINDOWS\DOSAPPS.GRP
//              Group8=C:\WINDOWS\MICROSOF.GRP
//              Group9=C:\WINDEV\SDKTOOLS.GRP
//
//            It uses the information in the PROGMAN.INI file to list 
//            the information in the opening listbox.  In order to get 
//            information about items in the group, the program opens 
//            the file listed in this list box.
//
//            The program then goes out and reads in the entire group
//            file specified in the opening list box and displays the
//            items in a secondary list box.  It uses structures 
//            specified in the group file format document in the 
//            Windows 3.1 SDK to find where the items are located 
//            within the file.  To demonstrate how to read an item,
//            ShowGrp reads in the item's icon and displays it in a 
//            dialog box.
//
// Copyright (c) 1992 Microsoft Corporation. All rights reserved.
//----------------------------------------------------------------------
#include <windows.h>
#include <stdlib.h>
#include <memory.h>
#include <string.h>
#include "appbar.h"
#include "appgrp.h"

#define BUFSIZE 	   256

HGLOBAL	ghMemGroupFileData;   // Handle to global memory which
			      // holds the group file data.
WORD cbGroup;		      // WORD value to specify length of groupfile

int ShouldAppBeMinimized(WORD);

//----------------------------------------------------------------------
//     Function:  SetItemInfo 
//
//	Purpose:  Fills in item data into the list box specified
//                by the hWndList parameter
//
// Return Value:  void 
//--------------------------------------------------------------------
BOOL ExecGroupFile(char *szGroupFileName)
{
  PMGROUPHEADER PMGroupHeader;	      // Header for the group file
  PMITEMDATA    PMItemData;           // Pointer to the group file data
  WORD      FAR *rgiItems;            // Array of item offset in group file
  WORD          cItems;               // Count of items 
  WORD          i;                    // Generic counter
  char		szCommand [BUFSIZE];  // Buffer to hold command
  char		*szTemp;	      // Temporary char pointer


  if (!ReadGroupFile ((LPSTR) szGroupFileName, &ghMemGroupFileData))
      return FALSE;

  // Get the Group File header information

  //**************************************************************
  //  The rgiItems array in the group file may not have valid
  //  information in it because it doesn't get updated fully
  //  when the the user deletes an item from the group file.  That
  //  is, the array doesn't get closed up to only include valid
  //  offsets.  Instead, Windows puts 0 in the offset for the
  //  deleted item.  So, what we're doing here is looking down the 
  //  for non-zero entries in the array to get a true count (cItems)
  //  of items in it.  In this way, we can use cItems as a limit in
  //  the while loop below.
  //**************************************************************

  _fmemcpy (&PMGroupHeader, lpGroupFileData, sizeof (PMGROUPHEADER));

  rgiItems = (WORD FAR *) &lpGroupFileData [sizeof (PMGROUPHEADER)];
  i = cItems = 0;
  while (i++ < PMGroupHeader.cItems)
    {
    if (*rgiItems)
      cItems++;
    rgiItems++;
    }

  i = 0;
  rgiItems = (WORD FAR *) &lpGroupFileData [sizeof (PMGROUPHEADER)];

  //  **************************************************************
  //  Now that we have the count of valid items in the group file,
  //  we cand go through and add the strings to the item list box.
  //  **************************************************************
  while (i < cItems)
    {
    if (*rgiItems)
      {
      i++;
      // Get the item structure filled in
      _fmemcpy (&PMItemData,
                &lpGroupFileData [*rgiItems],
                sizeof (PMITEMDATA));

      //  Do the item command
      szTemp = szCommand;
      do
	*szTemp = lpGroupFileData [PMItemData.pCommand++];
      while (*(szTemp++));
      if(ShouldAppBeMinimized( (WORD) i))
	  WinExec(szCommand, SW_SHOWMINIMIZED);
      else
	  WinExec(szCommand, SW_SHOWNORMAL);
      }
    rgiItems++;
    }

    if(GlobalUnlock(ghMemGroupFileData))
      GlobalFree(ghMemGroupFileData);

    return TRUE;
}

//----------------------------------------------------------------------
//     Function:  BOOL ReadGroupFile 
//
//   Parameters:  LPSTR lpszGroupFileName - Pointer to group file name
//                *HGLOBAL ghMemGroupFileData - a pointer to the memory
//                                              handle used to keep track
//                                              of the global memory 
//                                              allocated in this routine.
// 
//      Purpose:  Reads in the group file all at once. 
//
// Return Value:  Boolean indicating success or failure
//--------------------------------------------------------------------
BOOL ReadGroupFile (LPSTR lpszGroupFileName, PHANDLE ghMemGroupFileData)
{
  HFILE         fhGroupFile;
  OFSTRUCT	OpenBuff;

  
  // Get a handle to the group file

  if ((fhGroupFile = OpenFile (lpszGroupFileName, &OpenBuff, OF_READ)) == NULL)
    return FALSE;

  // ******************************************************************
  // Find out how much memory to allocate to hold the group file by
  // seeking to the end of the file.  This gives us the number of 
  // bytes that we have to allocate in the call to GlobalAlloc.
  // ******************************************************************

  cbGroup = (WORD) _llseek (fhGroupFile, 0L, 2);
  _llseek (fhGroupFile, 0L, 0);

  *ghMemGroupFileData = GlobalAlloc (GMEM_MOVEABLE, cbGroup);
  lpGroupFileData = GlobalLock (*ghMemGroupFileData);
  if (!lpGroupFileData)
    {
    _lclose (fhGroupFile);
    return FALSE;
    }

  if (!_lread (fhGroupFile, lpGroupFileData, cbGroup))
    {
    _lclose (fhGroupFile);

    if(GlobalUnlock (*ghMemGroupFileData))
       GlobalFree (*ghMemGroupFileData);

    return FALSE;
    }

  _lclose (fhGroupFile);
  return TRUE;
}

//----------------------------------------------------------------------
int ShouldAppBeMinimized(WORD x)
    {
    struct tempTAGDATA {
    WORD wID;
    WORD wItem;
    WORD cb;
    } tempData;
    char FAR *ptr; // *********

    tempData.wID = 0x8103; // ********
    tempData.wItem = x - 1; // *********
    tempData.cb = 0x06;

    for(ptr=lpGroupFileData; (ptr<=(lpGroupFileData + cbGroup-6)) &&
        _fmemcmp(ptr,&tempData,sizeof(tempData)); ptr++); /* do nothing */

    return (ptr <= (lpGroupFileData + cbGroup-6));
    }
