/* applib.h */

#define INI_SYSTEM	"System"
#define INI_BUTTON	"Buttons"
#define INI_SOUND	"Sounds"
#define INI_SHELL	"Shell"
#define INI_FILE	"appbar.ini"

#define LEFT		"Left"
#define TOP		"Top"
#define COLUMNS		"Columns"
#define BUTTONS 	"Buttons"
#define CLOSEALL	"CloseAll"
#define STAYINFRONT	"StayInFront"
#define INITIALIZED	"Initialized"
#define BIGBUTTONS	"BigButtons"
#define DOUBLECLICK	"DoubleClick"
#define BORDER		"Border"
#define DEFAULTICONDIR	"DefaultIconDir"
#define SHELLGROUP	"ShellGroup"

#define SOUNDENABLE	"SoundEnable"
#define APPSTART	"AppBarStart"
#define APPEXIT 	"AppBarExit"
#define WINEXIT 	"WindowsExit"
#define PROGSTART	"ProgramStart"
#define PROGCLOSE	"ProgramClose"
#define DROPFILE	"DropFile"
#define ERRORMESSAGE	"ErrorMessage"
#define SOUNDDIR	"SoundDirectory"

#define LEFT_DEFAULT	    -1
#define TOP_DEFAULT	    -1
#define COLUMNS_DEFAULT	    1
#define BUTTONS_DEFAULT     8
#define CLOSEALL_DEFAULT    1
#define NOSOUND_DEFAULT     0
#define CLOSEPROG_DEFAULT   1
#define SHOWMODE_DEFAULT    0
#define STAYINFRONT_DEFAULT 0
#define INITIALIZED_DEFAULT 0
#define ICONNUMBER_DEFAULT  0
#define BUTTONLOOK_DEFAULT  0
#define BIGBUTTONS_DEFAULT  0
#define DOUBLECLICK_DEFAULT 0
#define BORDER_DEFAULT	    0
#define SHELLGROUP_DEFAULT  "startup.grp"

#define SOUNDENABLE_DEFAULT	0
#define APPSTART_DEFAULT	"<none>"
#define APPEXIT_DEFAULT		"<none>"
#define WINEXIT_DEFAULT		"<none>"
#define PROGSTART_DEFAULT	"<none>"
#define PROGCLOSE_DEFAULT	"<none>"
#define DROPFILE_DEFAULT	"<none>"
#define ERRORMESSAGE_DEFAULT	"<none>"
#define SOUNDDIR_DEFAULT	" "

#define MAXFILECHARS	81
#define MAXDIGITS	5
#define NUMICONS	4
#define NUMEDITS	3
#define MAXBUTTONS	49
#define MAXAPPS 	(MAXBUTTONS-1)
#define MAXRES		1280
#define MAXBORDER	15

#define APPBARVERSION	400
#define APPBAR4		400

typedef enum {NOTALIVE = FALSE, ALIVE = TRUE} STATUS;

typedef struct {
	char	IcoName[MAXFILECHARS];
	char	ProgName[MAXFILECHARS];
	char	StartDir[MAXFILECHARS];
	char	Params[MAXFILECHARS];
	HWND	hWndApp;
	int	IconNumber;
	BOOL	ButtonLook;
	STATUS	ProgStatus;
	BOOL	Close;
	short	ShowMode;
	BOOL	NoSound;
	} APPBARBUTTONS;

typedef struct {
	short	Left;
	short	Top;
	int	Columns;
	int	Buttons;
	BOOL	CloseAll;
	BOOL	StayInFront;
	int	Initialized;
	BOOL	BigButtons;
	BOOL	DoubleClick;
	int	Border;
	char	DefaultIconDir[MAXFILECHARS];
	char	ShellGroup[8*MAXFILECHARS];
	} APPSYSTEM;

typedef struct {
	BOOL	EnableSound;
	char	AppBarStart[MAXFILECHARS];
	char	AppBarExit[MAXFILECHARS];
	char	WindowsExit[MAXFILECHARS];
	char	ProgramStart[MAXFILECHARS];
	char	ProgramClose[MAXFILECHARS];
	char	DropFile[MAXFILECHARS];
	char	ErrorMessage[MAXFILECHARS];
	char	SoundDirectory[MAXFILECHARS];
	} APPSOUND;

int temp;

#define WITHIN(val, min, max)	  (((temp=val) > max ? max : (temp < min) ? min : temp))
#define ONEORZERO(val)		  WITHIN((BOOL)val, 0, 1)
