/*************************************************************************/
/* ControlZ.h - header file to support the ControlZ additional controls. */
/* Copyright  1994, C. van Zwynsvoorde. All rights reserved.            */
/*************************************************************************/


/********************************************/
/* Scaler Styles. Combine with the standard */
/* WS_XXX styles when creating the window   */
/********************************************/
#define CZSS_TYPELONG		0x00000000L
#define CZSS_TYPEDOUBLE		0x00008000L
#define CZSS_NOCAPTION		0x00000000L
#define CZSS_CAPTION		0x00004000L

#define CZSS_SLIDER_0		0x00000000L
#define CZSS_SLIDER_1		0x00000001L
#define CZSS_SLIDER_2		0x00000002L
#define CZSS_SLIDER_3		0x00000003L
#define CZSS_SLIDER_4		0x00000004L
#define CZSS_SLIDER_5		0x00000005L
#define CZSS_SLIDER_6		0x00000006L
#define CZSS_SLIDER_7		0x00000007L
#define CZSS_SLIDER_8		0x00000008L
#define CZSS_SLIDER_9		0x00000009L

#define CZSS_TICKS_NORMAL	0x00000000L
#define CZSS_TICKS_RAISED	0x00000100L
#define CZSS_TICKS_DUG		0x00000200L

/******************************************/
/* Dial Styles. Combine with the standard */
/* WS_XXX styles when creating the window */
/******************************************/
#define CZDS_TYPELONG		0x00000000L
#define CZDS_TYPEDOUBLE		0x00008000L
#define CZDS_NOCAPTION		0x00000000L
#define CZDS_CAPTION		0x00004000L

#define CZDS_SLIDERSTART_0	0x00000000L
#define CZDS_SLIDERSTART_1	0x00000100L
#define CZDS_SLIDERSTART_2	0x00000200L
#define CZDS_SLIDERSTART_3	0x00000300L
#define CZDS_SLIDERSTART_4	0x00000400L
#define CZDS_SLIDERSTART_5	0x00000500L
#define CZDS_SLIDERSTART_6	0x00000600L
#define CZDS_SLIDERSTART_7	0x00000700L
#define CZDS_SLIDERSTART_8	0x00000800L
#define CZDS_SLIDERSTART_9	0x00000900L
#define CZDS_SLIDERSTART_10	0x00000A00L
#define CZDS_SLIDERSTART_11	0x00000B00L
#define CZDS_SLIDERSTART_12	0x00000C00L
#define CZDS_SLIDERSTART_13	0x00000D00L
#define CZDS_SLIDERSTART_14	0x00000E00L
#define CZDS_SLIDERSTART_15	0x00000F00L

#define CZDS_SLIDEREND_0	0x00000000L
#define CZDS_SLIDEREND_1	0x00000010L
#define CZDS_SLIDEREND_2	0x00000020L
#define CZDS_SLIDEREND_3	0x00000030L
#define CZDS_SLIDEREND_4	0x00000040L
#define CZDS_SLIDEREND_5	0x00000050L
#define CZDS_SLIDEREND_6	0x00000060L
#define CZDS_SLIDEREND_7	0x00000070L
#define CZDS_SLIDEREND_8	0x00000080L
#define CZDS_SLIDEREND_9	0x00000090L
#define CZDS_SLIDEREND_10	0x000000A0L
#define CZDS_SLIDEREND_11	0x000000B0L
#define CZDS_SLIDEREND_12	0x000000C0L
#define CZDS_SLIDEREND_13	0x000000D0L
#define CZDS_SLIDEREND_14	0x000000E0L
#define CZDS_SLIDEREND_15	0x000000F0L

#define CZDS_NEEDLE_0		0x00000000L
#define CZDS_NEEDLE_1		0x00000001L
#define CZDS_NEEDLE_2		0x00000002L
#define CZDS_NEEDLE_3		0x00000003L
#define CZDS_NEEDLE_4		0x00000004L
#define CZDS_NEEDLE_5		0x00000005L
#define CZDS_NEEDLE_6		0x00000006L
#define CZDS_NEEDLE_7		0x00000007L
#define CZDS_NEEDLE_8		0x00000008L
#define CZDS_NEEDLE_9		0x00000009L
#define CZDS_NEEDLE_10		0x0000000AL
#define CZDS_NEEDLE_11		0x0000000BL
#define CZDS_NEEDLE_12		0x0000000CL
#define CZDS_NEEDLE_13		0x0000000DL
#define CZDS_NEEDLE_14		0x0000000EL
#define CZDS_NEEDLE_15		0x0000000FL

#define CZDS_TICKS_0		0x00000000L
#define CZDS_TICKS_1		0x00001000L
#define CZDS_TICKS_2		0x00002000L
#define CZDS_TICKS_3		0x00003000L


/*******************************************/
/* Tuner Styles. Combine with the standard */
/* WS_XXX styles when creating the window  */
/*******************************************/
#define CZTS_TYPELONG		0x00000000L
#define CZTS_TYPEDOUBLE		0x00008000L
#define CZTS_NOCAPTION		0x00000000L
#define CZTS_CAPTION		0x00004000L

#define CZTS_WHEELDEPTH_0	0x00000000L
#define CZTS_WHEELDEPTH_1	0x00000010L
#define CZTS_WHEELDEPTH_2	0x00000020L
#define CZTS_WHEELDEPTH_3	0x00000030L
#define CZTS_WHEELDEPTH_4	0x00000040L
#define CZTS_WHEELDEPTH_5	0x00000050L
#define CZTS_WHEELDEPTH_6	0x00000060L
#define CZTS_WHEELDEPTH_7	0x00000070L
#define CZTS_WHEELDEPTH_8	0x00000080L
#define CZTS_WHEELDEPTH_9	0x00000090L
#define CZTS_WHEELDEPTH_10	0x000000A0L
#define CZTS_WHEELDEPTH_11	0x000000B0L
#define CZTS_WHEELDEPTH_12	0x000000C0L
#define CZTS_WHEELDEPTH_13	0x000000D0L
#define CZTS_WHEELDEPTH_14	0x000000E0L
#define CZTS_WHEELDEPTH_15	0x000000F0L

#define CZTS_MARK_0		0x00000000L
#define CZTS_MARK_1		0x00000001L
#define CZTS_MARK_2		0x00000002L
#define CZTS_MARK_3		0x00000003L
#define CZTS_MARK_4		0x00000004L
#define CZTS_MARK_5		0x00000005L
#define CZTS_MARK_6		0x00000006L
#define CZTS_MARK_7		0x00000007L
#define CZTS_MARK_8		0x00000008L
#define CZTS_MARK_9		0x00000009L
#define CZTS_MARK_10		0x0000000AL
#define CZTS_MARK_11		0x0000000BL
#define CZTS_MARK_12		0x0000000CL
#define CZTS_MARK_13		0x0000000DL
#define CZTS_MARK_14		0x0000000EL
#define CZTS_MARK_15		0x0000000FL



/***************************************************/
/* Hierarchic Combo Box Styles. Combine with the   */
/* standard WS_XXX styles when creating the window */
/***************************************************/
#define CZCBS_BACKGROUND_0	0x00000000L
#define CZCBS_BACKGROUND_1	0x00000100L
#define CZCBS_BACKGROUND_2	0x00000200L
#define CZCBS_BACKGROUND_3	0x00000300L
#define CZCBS_BACKGROUND_4	0x00000400L
#define CZCBS_BACKGROUND_5	0x00000500L
#define CZCBS_BACKGROUND_6	0x00000600L
#define CZCBS_BACKGROUND_7	0x00000700L
#define CZCBS_BACKGROUND_8	0x00000800L
#define CZCBS_BACKGROUND_9	0x00000900L
#define CZCBS_BACKGROUND_10	0x00000A00L
#define CZCBS_BACKGROUND_11	0x00000B00L
#define CZCBS_BACKGROUND_12	0x00000C00L
#define CZCBS_BACKGROUND_13	0x00000D00L
#define CZCBS_BACKGROUND_14	0x00000E00L
#define CZCBS_BACKGROUND_15	0x00000F00L

#define CZCBS_SELECTED_0	0x00000000L
#define CZCBS_SELECTED_1	0x00000010L
#define CZCBS_SELECTED_2	0x00000020L
#define CZCBS_SELECTED_3	0x00000030L
#define CZCBS_SELECTED_4	0x00000040L
#define CZCBS_SELECTED_5	0x00000050L
#define CZCBS_SELECTED_6	0x00000060L
#define CZCBS_SELECTED_7	0x00000070L
#define CZCBS_SELECTED_8	0x00000080L
#define CZCBS_SELECTED_9	0x00000090L
#define CZCBS_SELECTED_10	0x000000A0L
#define CZCBS_SELECTED_11	0x000000B0L
#define CZCBS_SELECTED_12	0x000000C0L
#define CZCBS_SELECTED_13	0x000000D0L
#define CZCBS_SELECTED_14	0x000000E0L
#define CZCBS_SELECTED_15	0x000000F0L

#define CZCBS_UNSELECTED_0	0x00000000L
#define CZCBS_UNSELECTED_1	0x00000001L
#define CZCBS_UNSELECTED_2	0x00000002L
#define CZCBS_UNSELECTED_3	0x00000003L
#define CZCBS_UNSELECTED_4	0x00000004L
#define CZCBS_UNSELECTED_5	0x00000005L
#define CZCBS_UNSELECTED_6	0x00000006L
#define CZCBS_UNSELECTED_7	0x00000007L
#define CZCBS_UNSELECTED_8	0x00000008L
#define CZCBS_UNSELECTED_9	0x00000009L
#define CZCBS_UNSELECTED_10	0x0000000AL
#define CZCBS_UNSELECTED_11	0x0000000BL
#define CZCBS_UNSELECTED_12	0x0000000CL
#define CZCBS_UNSELECTED_13	0x0000000DL
#define CZCBS_UNSELECTED_14	0x0000000EL
#define CZCBS_UNSELECTED_15	0x0000000FL

#define CZCBS_SIMPLE		0x00000000L
#define CZCBS_DROPDOWNLIST	0x00001000L

#define CZCBS_DEMO		0x00002000L
#define CZCBS_NODEMO		0x00000000L

#define CZCBS_MARKER_0		0x00000000L
#define CZCBS_MARKER_1		0x00004000L
#define CZCBS_MARKER_2		0x00008000L
#define CZCBS_MARKER_3		0x0000C000L


/***************************************************/
/* Hierarchic List Box Styles. Combine with the    */
/* standard WS_XXX styles when creating the window */
/***************************************************/
#define CZLBS_BACKGROUND_0	0x00000000L
#define CZLBS_BACKGROUND_1	0x00000100L
#define CZLBS_BACKGROUND_2	0x00000200L
#define CZLBS_BACKGROUND_3	0x00000300L
#define CZLBS_BACKGROUND_4	0x00000400L
#define CZLBS_BACKGROUND_5	0x00000500L
#define CZLBS_BACKGROUND_6	0x00000600L
#define CZLBS_BACKGROUND_7	0x00000700L
#define CZLBS_BACKGROUND_8	0x00000800L
#define CZLBS_BACKGROUND_9	0x00000900L
#define CZLBS_BACKGROUND_10	0x00000A00L
#define CZLBS_BACKGROUND_11	0x00000B00L
#define CZLBS_BACKGROUND_12	0x00000C00L
#define CZLBS_BACKGROUND_13	0x00000D00L
#define CZLBS_BACKGROUND_14	0x00000E00L
#define CZLBS_BACKGROUND_15	0x00000F00L

#define CZLBS_SELECTED_0	0x00000000L
#define CZLBS_SELECTED_1	0x00000010L
#define CZLBS_SELECTED_2	0x00000020L
#define CZLBS_SELECTED_3	0x00000030L
#define CZLBS_SELECTED_4	0x00000040L
#define CZLBS_SELECTED_5	0x00000050L
#define CZLBS_SELECTED_6	0x00000060L
#define CZLBS_SELECTED_7	0x00000070L
#define CZLBS_SELECTED_8	0x00000080L
#define CZLBS_SELECTED_9	0x00000090L
#define CZLBS_SELECTED_10	0x000000A0L
#define CZLBS_SELECTED_11	0x000000B0L
#define CZLBS_SELECTED_12	0x000000C0L
#define CZLBS_SELECTED_13	0x000000D0L
#define CZLBS_SELECTED_14	0x000000E0L
#define CZLBS_SELECTED_15	0x000000F0L

#define CZLBS_UNSELECTED_0	0x00000000L
#define CZLBS_UNSELECTED_1	0x00000001L
#define CZLBS_UNSELECTED_2	0x00000002L
#define CZLBS_UNSELECTED_3	0x00000003L
#define CZLBS_UNSELECTED_4	0x00000004L
#define CZLBS_UNSELECTED_5	0x00000005L
#define CZLBS_UNSELECTED_6	0x00000006L
#define CZLBS_UNSELECTED_7	0x00000007L
#define CZLBS_UNSELECTED_8	0x00000008L
#define CZLBS_UNSELECTED_9	0x00000009L
#define CZLBS_UNSELECTED_10	0x0000000AL
#define CZLBS_UNSELECTED_11	0x0000000BL
#define CZLBS_UNSELECTED_12	0x0000000CL
#define CZLBS_UNSELECTED_13	0x0000000DL
#define CZLBS_UNSELECTED_14	0x0000000EL
#define CZLBS_UNSELECTED_15	0x0000000FL

#define CZLBS_DEMO		0x00002000L
#define CZLBS_NODEMO		0x00000000L

#define CZLBS_SCROLLCAPTION	0x00000000L
#define CZLBS_FIXEDCAPTION	0x00001000L

#define CZLBS_MARKER_0		0x00000000L
#define CZLBS_MARKER_1		0x00004000L
#define CZLBS_MARKER_2		0x00008000L
#define CZLBS_MARKER_3		0x0000C000L


/******************************************/
/* Link Styles. Combine with the standard */
/* WS_XXX styles when creating the window */
/******************************************/
#define CZLS_TLCORNER	0x00000000L
#define CZLS_BRCORNER	0x00000001L
#define CZLS_TRCORNER	0x00000002L
#define CZLS_BLCORNER	0x00000003L
#define CZLS_HLINE	(CZLS_TLCORNER | CZLS_DIRECT)
#define CZLS_VLINE	(CZLS_TRCORNER | CZLS_DIRECT)
#define CZLS_DIAGUP	(CZLS_BLCORNER | CZLS_DIRECT)
#define CZLS_DIAGDOWN	(CZLS_BRCORNER | CZLS_DIRECT)

#define CZLS_RECT	0x00000000L
#define CZLS_ELLIPTIC	0x00000004L
#define CZLS_ROUNDRECT	0x00000008L
#define CZLS_DIRECT	0x0000000CL

#define CZLS_COLOR_0	0x00000000L
#define CZLS_COLOR_1	0x00000010L
#define CZLS_COLOR_2	0x00000020L
#define CZLS_COLOR_3	0x00000030L
#define CZLS_COLOR_4	0x00000040L
#define CZLS_COLOR_5	0x00000050L
#define CZLS_COLOR_6	0x00000060L
#define CZLS_COLOR_7	0x00000070L
#define CZLS_COLOR_8	0x00000080L
#define CZLS_COLOR_9	0x00000090L
#define CZLS_COLOR_10	0x000000A0L
#define CZLS_COLOR_11	0x000000B0L
#define CZLS_COLOR_12	0x000000C0L
#define CZLS_COLOR_13	0x000000D0L
#define CZLS_COLOR_14	0x000000E0L
#define CZLS_COLOR_15	0x000000F0L

#define CZLS_START_0	0x00000000L
#define CZLS_START_1	0x00000100L
#define CZLS_START_2	0x00000200L
#define CZLS_START_3	0x00000300L
#define CZLS_START_4	0x00000400L
#define CZLS_START_5	0x00000500L
#define CZLS_START_6	0x00000600L
#define CZLS_START_7	0x00000700L
#define CZLS_START_8	0x00000800L
#define CZLS_START_9	0x00000900L
#define CZLS_START_10	0x00000A00L
#define CZLS_START_11	0x00000B00L
#define CZLS_START_12	0x00000C00L
#define CZLS_START_13	0x00000D00L
#define CZLS_START_14	0x00000E00L
#define CZLS_START_15	0x00000F00L

#define CZLS_END_0	0x00000000L
#define CZLS_END_1	0x00001000L
#define CZLS_END_2	0x00002000L
#define CZLS_END_3	0x00003000L
#define CZLS_END_4	0x00004000L
#define CZLS_END_5	0x00005000L
#define CZLS_END_6	0x00006000L
#define CZLS_END_7	0x00007000L
#define CZLS_END_8	0x00008000L
#define CZLS_END_9	0x00009000L
#define CZLS_END_10	0x0000A000L
#define CZLS_END_11	0x0000B000L
#define CZLS_END_12	0x0000C000L
#define CZLS_END_13	0x0000D000L
#define CZLS_END_14	0x0000E000L
#define CZLS_END_15	0x0000F000L


/******************************************/
/* Text Styles. Combine with the standard */
/* WS_XXX styles when creating the window */
/******************************************/
#define CZSTS_TEXTCOLOR_0	0x00000000L
#define CZSTS_TEXTCOLOR_1	0x00001000L
#define CZSTS_TEXTCOLOR_2       0x00002000L
#define CZSTS_TEXTCOLOR_3	0x00003000L
#define CZSTS_TEXTCOLOR_4	0x00004000L
#define CZSTS_TEXTCOLOR_5	0x00005000L
#define CZSTS_TEXTCOLOR_6	0x00006000L
#define CZSTS_TEXTCOLOR_7	0x00007000L
#define CZSTS_TEXTCOLOR_8	0x00008000L
#define CZSTS_TEXTCOLOR_9	0x00009000L
#define CZSTS_TEXTCOLOR_10	0x0000A000L
#define CZSTS_TEXTCOLOR_11	0x0000B000L
#define CZSTS_TEXTCOLOR_12	0x0000C000L
#define CZSTS_TEXTCOLOR_13	0x0000D000L
#define CZSTS_TEXTCOLOR_14	0x0000E000L
#define CZSTS_TEXTCOLOR_15	0x0000F000L

#define CZSTS_BACKCOLOR_0	0x00000000L
#define CZSTS_BACKCOLOR_1	0x00000100L
#define CZSTS_BACKCOLOR_2	0x00000200L
#define CZSTS_BACKCOLOR_3	0x00000300L
#define CZSTS_BACKCOLOR_4	0x00000400L
#define CZSTS_BACKCOLOR_5	0x00000500L
#define CZSTS_BACKCOLOR_6	0x00000600L
#define CZSTS_BACKCOLOR_7	0x00000700L
#define CZSTS_BACKCOLOR_8	0x00000800L
#define CZSTS_BACKCOLOR_9	0x00000900L
#define CZSTS_BACKCOLOR_10	0x00000A00L
#define CZSTS_BACKCOLOR_11	0x00000B00L
#define CZSTS_BACKCOLOR_12	0x00000C00L
#define CZSTS_BACKCOLOR_13	0x00000D00L
#define CZSTS_BACKCOLOR_14	0x00000E00L
#define CZSTS_BACKCOLOR_15	0x00000F00L

#define CZSTS_LEFT		0x00000000L
#define CZSTS_CENTER		0x00000010L
#define CZSTS_RIGHT		0x00000020L

#define CZSTS_UNDERLINE		0x00000040L
#define CZSTS_ITALIC		0x00000080L
#define CZSTS_BOLD		0x00000008L
#define CZSTS_SMALLCAPS		0x00000004L

#define CZSTS_RIGHTWARDS	0x00000000L
#define CZSTS_UPWARDS		0x00000001L
#define CZSTS_LEFTWARDS		0x00000002L
#define CZSTS_DOWNWARDS		0x00000003L






/****************************************/
/* Messages. Send those to the controls */
/****************************************/

/**********************************/
/* For the scaler, dial and tuner */
/**********************************/
#define CZM_SETPOS		(WM_USER+100)	/* wParam = NULL. lParam = pos if type is LONG, &pos if type is double */
#define CZM_GETPOS		(WM_USER+101)	/* wParam = NULL. lParam = &pos. pos must allocate 4/8 bits depending on type. */
						/* Besides, SendMessage() will return the value directly if type is LONG */
#define CZM_SETINC		(WM_USER+102)	/* wParam = NULL. lParam = increment if type is LONG, &increment if type is double */
#define CZM_GETINC		(WM_USER+103)	/* wParam = NULL. lParam = &inc. inc must allocate 4/8 bits depending on type. */
						/* Besides, SendMessage() will return the value directly if type is LONG */
#define CZM_INCPOS		(WM_USER+104)	/* wParam = TRUE if increase, FALSE if decrease. lParam = NULL. */

/***************************/
/* For the scaler and dial */
/***************************/
#define CZM_SETRANGEMIN		(WM_USER+105)	/* wParam = NULL. lParam = range if type is LONG, &range if type is double */
#define CZM_SETRANGEMAX		(WM_USER+106)	/* wParam = NULL. lParam = range if type is LONG, &range if type is double */

#define CZM_GETRANGEMIN		(WM_USER+107)	/* wParam = NULL. lParam = &range. range must allocate 4/8 bits depending on type. */
						/* Besides, SendMessage() will return the value directly if type is LONG */
#define CZM_GETRANGEMAX		(WM_USER+108)	/* wParam = NULL. lParam = &range. range must allocate 4/8 bits depending on type. */
						/* Besides, SendMessage() will return the value directly if type is LONG */
/*****************/
/* For the tuner */
/*****************/
#define CZM_SETTURN		(WM_USER+105)	/* wParam = NULL. lParam = turn if type is LONG, &turn if type is double */
#define CZM_GETTURN		(WM_USER+106)	/* wParam = NULL. lParam = &turn. turn must allocate 4/8 bits depending on type. */
						/* Besides, SendMessage() will return the value directly if type is LONG */

/**********************************/
/* For the list box and combo box */
/**********************************/
#define CZM_ADDSECTION		(WM_USER+100)	/* wParam = section id. (LPSTR)lParam = section title. */
#define CZM_DELETESECTION	(WM_USER+101)	/* wParam = section id. lParam = NULL. */
#define CZM_FILLSECTION		(WM_USER+102)	/* wParam = NULL. (LPSTR)lParam = item string. */
#define CZM_ISSECTION		(WM_USER+103)	/* wParam = index. lParam = NULL. */



/********************************************************/
/* Notification messages. Recieved by the parent window */
/********************************************************/

/********************************************/
/* Received from the scaler, dial and tuner */
/********************************************/
#define CZN_POSCHANGE		1	/* iMessage = WM_COMMAND. wParam = ctrlID. lParam = MAKELONG(control hWnd, CZN_POSCHANGE). */

/********************************************/
/* Received from the list box and combo box */
/********************************************/
#define CZN_SELCHANGE		1	/* iMessage = WM_COMmAND. wParam = ctrlID. lParam = MAKELONG(control hWnd, CZN_SELCHANGE). */
					/* The selection is not on a section header. */
#define CZN_FILLSECTION		2	/* iMessage = WM_COMMAND. wParam = ctrlID. lParam = MAKELONG(section id, CZN_FILLSECTION). */
					/* The selection is on a section header. The application must send the strings */
					/* belonging to this section by means of the CZM_FILLSECTION message. */