// splash.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "splash.h"

#include "mainfrm.h"
#include "nulldoc.h"
#include "nullview.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSplashDemoApp

BEGIN_MESSAGE_MAP(CSplashDemoApp, CWinApp)
	//{{AFX_MSG_MAP(CSplashDemoApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_HELP_SPLASHME, OnHelpSplashme)
	ON_UPDATE_COMMAND_UI(ID_HELP_SPLASHME, OnUpdateHelpSplashme)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSplashDemoApp construction

CSplashDemoApp::CSplashDemoApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
	m_pwndSplash = NULL;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CSplashDemoApp object

CSplashDemoApp NEAR theApp;

/////////////////////////////////////////////////////////////////////////////
// CSplashDemoApp initialization

BOOL CSplashDemoApp::InitInstance()
{
// Put up the splash window
//if (RunEmbedded() || RunAutomated())			// Do the check here if OLE is used
//{
	ASSERT(NULL == m_pwndSplash);
	m_pwndSplash = new CSplashWnd;
	m_pwndSplash->Create();
	m_pwndSplash->ShowWindow(SW_SHOW);
	m_pwndSplash->UpdateWindow();
	ASSERT(m_pwndSplash != NULL);
//}
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	SetDialogBkColor();        // Set dialog background color to gray
	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CMultiDocTemplate* pDocTemplate;
	pDocTemplate = new CMultiDocTemplate(
		IDR_NULLTYPE,
		RUNTIME_CLASS(CNullDoc),
		RUNTIME_CLASS(CMDIChildWnd),        // standard MDI child frame
		RUNTIME_CLASS(CNullView));
	AddDocTemplate(pDocTemplate);

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// enable file manager drag/drop and DDE Execute open
	EnableShellOpen();
	RegisterShellFileTypes();

	// simple command line parsing
	if (m_lpCmdLine[0] == '\0')
	{
		// create a new (empty) document
		OnFileNew();
	}
	else
	{
		// open an existing document
		OpenDocumentFile(m_lpCmdLine);
	}

	m_pMainWnd->DragAcceptFiles();
	// The main window has been initialized, so show and update it.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	m_dwSplashTime = ::GetCurrentTime();

	return TRUE;
}

#define SPLASH_TIME 2500

BOOL CSplashDemoApp::OnIdle(LONG lCount)
{
	// call base class idle first
	BOOL bResult = CWinApp::OnIdle(lCount);

	// then do our work
	if (m_pwndSplash != NULL)
	{
		if (m_pwndSplash->m_hWnd != NULL)
		{
			if (::GetCurrentTime() - m_dwSplashTime >= SPLASH_TIME)
			{
				// timeout expired, destroy the splash window
				m_pwndSplash->DestroyWindow();
				delete m_pwndSplash;
				m_pwndSplash = NULL;
				m_pMainWnd->UpdateWindow();
				// NOTE: don't set bResult to FALSE,
				//  CWinApp::OnIdle may have returned TRUE
			}
			else
			{
				// check again later...
				bResult = TRUE;
			}
		}
	}

	return bResult;
}

BOOL CSplashDemoApp::PreTranslateMessage(MSG *pMsg)
{
	if (m_pwndSplash != NULL)
    {
    	if (pMsg->message == WM_KEYDOWN ||
        	pMsg->message == WM_SYSKEYDOWN ||
        	pMsg->message == WM_LBUTTONDOWN ||
        	pMsg->message == WM_RBUTTONDOWN ||
        	pMsg->message == WM_MBUTTONDOWN ||
        	pMsg->message == WM_NCLBUTTONDOWN ||
        	pMsg->message == WM_NCRBUTTONDOWN ||
        	pMsg->message == WM_NCMBUTTONDOWN)
        {
			if (pMsg->hwnd == m_pwndSplash->m_hWnd) m_dwSplashTime -= SPLASH_TIME;
			else
			{
				m_pwndSplash->DestroyWindow();
				delete m_pwndSplash;
				m_pwndSplash = NULL;
				m_pMainWnd->UpdateWindow();
			}
		}
	}
 	
 	return CWinApp::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CSplashDemoApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CSplashWnd

CSplashWnd::CSplashWnd()
{
}

CSplashWnd::~CSplashWnd()
{
	m_bmSplash.DeleteObject();
}

BOOL CSplashWnd::Create()
{
	m_bmSplash.LoadBitmap(IDB_SPLASHWND);
	
	BITMAP bm;
	m_bmSplash.GetObject(sizeof(BITMAP), &bm);
	
	// Get the size of the splash window
	m_wndWidth = bm.bmWidth;
	m_wndHeight = bm.bmHeight;

	// Get the size of the screen
	int screenWidth = GetSystemMetrics(SM_CXSCREEN);
	int screenHeight = GetSystemMetrics(SM_CYSCREEN);
	
	// get top/left coord to center the splash window
	int top = (screenHeight - m_wndHeight)/2;
	int left = (screenWidth - m_wndWidth)/2;
	
	return CWnd::CreateEx(WS_EX_TOPMOST, "AfxWnd", "", WS_POPUP | WS_VISIBLE,
		left, top, m_wndWidth, m_wndHeight, NULL, NULL);
}

BEGIN_MESSAGE_MAP(CSplashWnd, CWnd)
	//{{AFX_MSG_MAP(CSplashWnd)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSplashWnd message handlers

void CSplashWnd::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	
	CDC memDC;
	memDC.CreateCompatibleDC(&dc);

	CBitmap* pOld = memDC.SelectObject(&m_bmSplash);
	
	if (pOld == NULL)
		return;     // destructors will clean up

	dc.BitBlt(0, 0, m_wndWidth, m_wndHeight, &memDC, 0, 0, SRCCOPY);
	memDC.SelectObject(pOld);

	// Do not call CWnd::OnPaint() for painting messages
}

/////////////////////////////////////////////////////////////////////////////
// CSplashDemoApp commands

void CSplashDemoApp::OnHelpSplashme()
{
	ASSERT(NULL == m_pwndSplash);
	m_pwndSplash = new CSplashWnd;
	m_pwndSplash->Create();
	m_pwndSplash->ShowWindow(SW_SHOW);
	m_pwndSplash->UpdateWindow();
	ASSERT(m_pwndSplash != NULL);
	m_dwSplashTime = ::GetCurrentTime();
}

void CSplashDemoApp::OnUpdateHelpSplashme(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(NULL == m_pwndSplash);
}
