// mfcdemo.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "mfcdemo.h"

#include "mainfrm.h"
#include "mfcdedoc.h"
#include "mfcdevw.h"

#include "ctl3d.h"   
#include "cktbl.h"
       
       
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMfcdemoApp

BEGIN_MESSAGE_MAP(CMfcdemoApp, CWinApp)
	//{{AFX_MSG_MAP(CMfcdemoApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMfcdemoApp construction

CMfcdemoApp::CMfcdemoApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CMfcdemoApp object

CMfcdemoApp NEAR theApp;
       
             
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA  
	
	CBitmap 	mastercard;
	CBitmap 	visa;
	CBitmap		eurocard;
	CBitmap		amex; 
	BOOL		splashMode; 
	
	void SplashMode() { splashMode=1; }

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
	afx_msg void OnPaint();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT   
	splashMode = 0;
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
                

/////////////////////////////////////////////////////////////////////////////
// CMfcdemoApp initialization

BOOL CMfcdemoApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.
	
	Ctl3dRegister(AfxGetInstanceHandle());
	Ctl3dAutoSubclass(AfxGetInstanceHandle());
       

#ifdef CKTBL_LIBRARY
	CKTBLInitLib(m_hInstance);
#endif	
        
	SetDialogBkColor();        // Set dialog background color to gray
	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CMultiDocTemplate* pDocTemplate;
	pDocTemplate = new CMultiDocTemplate(
		IDR_MFCDEMTYPE,
		RUNTIME_CLASS(CMfcdemoDoc),
		RUNTIME_CLASS(CMDIChildWnd),        // standard MDI child frame
		RUNTIME_CLASS(CMfcdemoView));
	AddDocTemplate(pDocTemplate);

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// create a new (empty) document
	OnFileNew();

	if (m_lpCmdLine[0] != '\0')
	{
		// TODO: add command line processing here
	}

	// The main window has been initialized, so show and update it.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();
	                      
	// add modal splash dialog (will close with a mouseclick)
		                      
	CAboutDlg aboutDialog;
	aboutDialog.SplashMode();
	aboutDialog.DoModal();

	return TRUE;
}
             
             
int CMfcdemoApp::ExitInstance()
{                                

#ifdef CKTBL_LIBRARY
	CKTBLExitLib();
#endif

   Ctl3dUnregister(AfxGetInstanceHandle());
   return CWinApp::ExitInstance();
}                
                
                
// App command to run the dialog
void CMfcdemoApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CMfcdemoApp commands
  
                    
void CAboutDlg::OnPaint()
{
	CPaintDC 	dc(this); // device context for painting     
	CBitmap 	*oldbm, *bm; 
	CDC			dcComp; 
	CBitmap 	*cards[4];
	const 		ncards = 4; 
	CRect		rect,bmRect;    
	BITMAP		bmInfo;
	CBrush 		*oldBrush, hollowBrush;
	int			x,y,card;

	// CK: Paint the creditcard logos
	
	// TODO: Add your message handler code here
	// Do not call CDialog::OnPaint() for painting messages
	
	cards[0] = &eurocard;
	cards[1] = &mastercard;
	cards[2] = &visa;
	cards[3] = &amex;
  
	// create Compatible DC for bitmaps
	
	dcComp.CreateCompatibleDC( &dc );           
	oldbm = dcComp.SelectObject( cards[0] );
    
    // get rectangle for cards
              	    
	GetClientRect(&rect); 

	hollowBrush.CreateStockObject( HOLLOW_BRUSH );     
	oldBrush = dc.SelectObject( &hollowBrush );
	   	
	x = rect.left + 10;  
	          
	for( card=0; card<ncards; card++ ) {
		bm = cards[card];     
		bm->GetObject( sizeof(bmInfo), &bmInfo );
		y = rect.bottom - (bmInfo.bmHeight + 15);
		bmRect.SetRect( x-1,y-1, x+bmInfo.bmWidth+1, y+bmInfo.bmHeight+1 );
		dc.Rectangle( &bmRect );
		dcComp.SelectObject( bm );
		dc.BitBlt( x,y,bmInfo.bmWidth, bmInfo.bmHeight, &dcComp, 0,0, SRCCOPY ); 
		x += bmInfo.bmWidth + 10;
	}
	
	dcComp.SelectObject( oldbm );
	dc.SelectObject( oldBrush );
}

int CAboutDlg::OnCreate(LPCREATESTRUCT lpCreateStruct)
{                   
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	
	mastercard.LoadBitmap( IDB_MASTERCARD );
	visa.LoadBitmap( IDB_VISA );
	eurocard.LoadBitmap( IDB_EUROCARD );
	amex.LoadBitmap( IDB_AMEX );
	
	return 0;
}

void CAboutDlg::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	
	CDialog::OnLButtonDown(nFlags, point);
	if(splashMode) PostMessage(WM_CLOSE,0,0);
}

void CAboutDlg::OnRButtonDown(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	
	CDialog::OnRButtonDown(nFlags, point);
	if(splashMode) PostMessage(WM_CLOSE,0,0);
}
