/*
 *  attrib - Change file attributes
 *
 *  Copyright (C) 1994  Troy Rollo <troy@cbme.unsw.EDU.AU>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stddef.h>
#include <string.h>
#include <sys/stat.h>
#include <errno.h>
#include <stdlib.h>
#include <io.h>
#include <dir.h>
#include <dos.h>

static char *
expand_wildcards(char *s)
{
	static	struct find_t info;
	char wildcard[80];
	static char directory[256];
	static char filename[256];
	unsigned attrib;
	char *c1, *c2;

	if (s)
	{
		strcpy(wildcard, s);
		strcpy(directory, wildcard);
	    	if ((c1 = strrchr(directory, '/')) != 0 ||
		    (c2 = strrchr(directory, '\\')) != 0)
	    	{
			if (c1 > c2)
				c1[1] = '\0';
			else
				c2[1] = '\0';
		}
		else
			directory[0] = '\0';
		if (! strchr(wildcard, '.'))
			strcat(wildcard, "*.*");
		attrib = _A_HIDDEN | _A_HIDDEN | _A_ARCH | _A_NORMAL | _A_SUBDIR | _A_RDONLY;
		if (_dos_findfirst(wildcard, attrib, &info) != 0)
			return NULL;
		while (!strcmp(info.name, ".") || !strcmp(info.name, ".."))
			if (_dos_findnext(&info))
				return NULL;
	}
	else
	{
		if (_dos_findnext(&info) != 0)
			return NULL;
	}
	strcpy(filename, directory);
	strcat(filename, info.name);
	return filename;
}

int
main(	int	argc,
	char	**argv)
{
	char	*pchFile;
	int	on = 0;
	int	off = 0;
	int	turn_on;
	unsigned value;

	while (--argc)
	{
		argv++;
		if (**argv == '-' ||
		    **argv == '+')
		{
			while (**argv)
			{
				switch(**argv)
				{
				case '+':
					turn_on = 1;
					value = 0;
					break;

				case '-':
					turn_on = 0;
					value = 0;
					break;

				case 'r':
				case 'R':
					value = _A_RDONLY;
					break;

				case 'a':
				case 'A':
					value = _A_ARCH;
					break;

				case 's':
				case 'S':
					value = _A_SYSTEM;
					break;

				case 'h':
				case 'H':
					value = _A_HIDDEN;
					break;
					
				default:
					fprintf(stderr, "Usage: attrib [{+-}{ahrs}] file ...\n");
					return 1;
				}
				if (turn_on)
				{
					on |= value;
					off &= ~value;
				}
				else
				{
					off |= value;
					on &= ~value;
				}
				++*argv;
			}
		}
		else
		{
			for (pchFile = expand_wildcards(*argv);
			     pchFile;
			     pchFile = expand_wildcards(0))
			{
				if (_dos_getfileattr(pchFile, &value))
				{
					fprintf(stderr, "%s: %s\n", pchFile, sys_errlist[errno]);
					return 1;
				}
				value &= ~off;
				value |= on;
				if (_dos_setfileattr(pchFile, value))
				{
					fprintf(stderr, "%s: %s\n", pchFile, sys_errlist[errno]);
					return 1;
				}
			}
		}
	}
	return 0;
}

