// samp_vw.cpp : implementation of the CSamp_actView class
//

#include "stdafx.h"
#include "samp_act.h"

#include "samp_doc.h"
#include "samp_vw.h"

// WINDACTS - include the windacts.h file
extern "C" {		
	#include	"windacts.h"
};


// WINDACTS - declare space for our static class variables
UINT	CSamp_actView::m_Acts[2];

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

// switch off warning of cast from HGLOBAL to LRESULT which is intended
#pragma	warning(disable:4769)

/////////////////////////////////////////////////////////////////////////////
// CSamp_actView

IMPLEMENT_DYNCREATE(CSamp_actView, CView)

BEGIN_MESSAGE_MAP(CSamp_actView, CView)
	//{{AFX_MSG_MAP(CSamp_actView)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
	// WINDACTS: HERE WE ADD MESSAGE MAPS FOR OUR WINDOW ACTS AND ACTLIST
	ON_REGISTERED_MESSAGE(CSamp_actView::m_Acts[0], OnSetValues)
	ON_REGISTERED_MESSAGE(CSamp_actView::m_Acts[1], OnGetValues)
	ON_REGISTERED_MESSAGE(uActListMsg, OnActList)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSamp_actView construction/destruction

CSamp_actView::CSamp_actView()
{
	m_lValue1= 1000;
	m_sValue2 = "Present String";
}

CSamp_actView::~CSamp_actView()
{
}

/////////////////////////////////////////////////////////////////////////////
// CSamp_actView drawing

void CSamp_actView::OnDraw(CDC* pDC)
{
	CSamp_actDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// we are displaying the values
	{
		CString	sres;
		RECT	cr;
		
		GetClientRect(&cr);
		wsprintf(sres.GetBufferSetLength(128),"%ld\r\n",m_lValue1);
		sres.ReleaseBuffer();
		
		sres += m_sValue2;
		
		pDC->DrawText(sres,sres.GetLength(),&cr,DT_LEFT|DT_NOPREFIX|DT_EXPANDTABS|DT_TOP);
	}
}

/////////////////////////////////////////////////////////////////////////////
// CSamp_actView diagnostics

#ifdef _DEBUG
void CSamp_actView::AssertValid() const
{
	CView::AssertValid();
}

void CSamp_actView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CSamp_actDoc* CSamp_actView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSamp_actDoc)));
	return (CSamp_actDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSamp_actView message handlers

int CSamp_actView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// WINDACTS - register the acts supported by this window when it is first created
	// see the resources for IDS_ACTSTRING1 etc.
	RegisterActList(AfxGetInstanceHandle(), IDS_ACTSTRING1,m_Acts);
	// Set the FluteName for this window
	SetWindowFluteName(m_hWnd, "My_Sample_Window");
	return 0;
}

////////////////////////////////////////////////////////////////////////////
// Window Acts message handlers
// WINDACTS
// Set values into this window class (a Window Act)
LRESULT CSamp_actView::OnSetValues(WPARAM wParam, LPARAM lParam)
{
	DataObj	*pob;
	BOOL	b1,b2;
	long	lval;
	CString	sval;

	if (!wParam) return 0;		// there is a problem
	
	pob = DataGlobalLock((HGLOBAL)wParam);
	if (pob->tint.vtype!=ARRAYTYPE || pob->tarray.elements!=2) {
		// we haven't been given the correct parameters - report an error
		GlobalUnlock((HGLOBAL)wParam);
		return (LRESULT)GeneralError(AfxGetInstanceHandle(),IDS_PARAMETERERROR);
	};
	
	pob = PtrContent(pob);
	lval = GetALong(pob,&b1);
	pob = NextDataObj(pob);
	GetAString(pob, &b2, sval.GetBufferSetLength(256),256);
	sval.ReleaseBuffer();
	GlobalUnlock((HGLOBAL)wParam);
	
	// if the extraction of data failed, then report an error
	if (!b1 || !b2)
		return (LRESULT)GeneralError(AfxGetInstanceHandle(),IDS_PARAMETERERROR);
	
	// set the values and update the window
	m_lValue1 = lval;
	m_sValue2 = sval;
	Invalidate();
	
	return NULL;
}

// Window ACT to support getting the values set in our window class
LRESULT CSamp_actView::OnGetValues(WPARAM wParam, LPARAM lParam)
{
	return (LRESULT)MakeArray2(MakeInt(m_lValue1), MakeString(m_sValue2) );
}


// process the actlist message, if wParam is zero then return a list
// of supported window acts, otherwise provide help on the given
// act (in wParam)
LRESULT CSamp_actView::OnActList(WPARAM wParam, LPARAM)
{
	CString	sres;

	// if not wParam then return a list of Acts
	if (!wParam) return (LRESULT)ProduceActList(AfxGetInstanceHandle(), IDS_ACTSTRING1);
	
	// else provide help - find the act name
	FindActName(AfxGetInstanceHandle(), (UINT)wParam, IDS_ACTSTRING1, sres.GetBufferSetLength(128), 128);
	sres.ReleaseBuffer();
	
	::WinHelp(m_hWnd,"SampAct.hlp",HELP_PARTIALKEY, (DWORD)(LPCSTR)sres);
	return NULL;
}

