/**************************************************************/
/* GraphZ.DLL demo program.                                   */
/* Copyright  1995, C. van Zwynsvoorde. All rights reserved. */
/**************************************************************/

#include <windows.h>
#include <math.h>
#include "GraphZ.h"
#define IDHELP 998

double values[4];
double t;
HWND hWndGraph;
LPSTR lpszIniFile;

BOOL FAR PASCAL _export DemoDlgProc(HWND hWnd, WORD iMessage, WPARAM wParam, LPARAM lParam)
	{
	switch(iMessage)
		{
		case WM_INITDIALOG:
			hWndGraph = GetDlgItem(hWnd, 101);
			GZSetIni(hWndGraph, lpszIniFile);
			GZLoadIni(hWndGraph);
			SetTimer(hWnd, 1, 100, NULL);
			return TRUE;

		case WM_TIMER:
			t = GetTickCount() / 1000.0;
			values[0] = 1.2 + sin(t);
			values[1] = 1.2 + sin(t + M_PI_2);
			values[2] = 1.2 + sin(t + M_PI);
			values[3] = 1.2 + sin(t + M_PI + M_PI_2);

			GZAddPoints(hWndGraph, &values, 4);
			return TRUE;

		case WM_DESTROY:
			KillTimer(hWnd, 1);
			return TRUE;

		case WM_COMMAND:
			if (wParam == IDOK)
				EndDialog(hWnd, TRUE);
			else if (wParam == IDHELP)
				{
				FARPROC lpfnHelpDialog;
				lpfnHelpDialog = MakeProcInstance((FARPROC)DemoDlgProc, GetWindowWord(hWnd, GWW_HINSTANCE));
				DialogBox(GetWindowWord(hWnd, GWW_HINSTANCE), "Help", NULL, lpfnHelpDialog);
				FreeProcInstance(lpfnHelpDialog);
				}
			return TRUE;;
		}
	return FALSE;
	}




int PASCAL WinMain (HINSTANCE hInst, HINSTANCE hPrev, LPSTR lpszCmdLine, int nCmdShow)
	{
	FARPROC lpfnDemoDialog;
	WORD hLib = LoadLibrary("GraphZ.DLL");
	if (hLib < 32)
		{
		MessageBox(NULL, "You need GraphZ.DLL to run this demo.", "GraphZ Demo", MB_OK);
		return -1;
		}
	lpfnDemoDialog = MakeProcInstance((FARPROC)DemoDlgProc, hInst);
	lpszIniFile = ".\\demo1.grz";
	DialogBox(hInst, "GraphZDemo", NULL, lpfnDemoDialog);
	lpszIniFile = ".\\demo2.grz";
	DialogBox(hInst, "GraphZDemo", NULL, lpfnDemoDialog);
	FreeProcInstance(lpfnDemoDialog);
	FreeLibrary(hLib);
	return 0;
	}
