/*******************************************************************/
/* GraphZ.h - header file to support the GraphZ graphical library. */
/* Copyright  1995, C. van Zwynsvoorde. All rights reserved.      */
/*******************************************************************/


#define MAXFONTNAME			41

/*******************/
/* TITLE structure */
/*******************/
typedef struct
	{
	char	szTitle[81];                /* the graph's tile */
	char	szFontName[MAXFONTNAME];	/* title font family name */
	int		nFontSize;                  /* title font size in pts */
	BOOL	bBold;                      /* bold or regular */
	BOOL	bItalic;                    /* italic or regular */
	BOOL	bUnderline;                 /* underline or not */
	BOOL	bGraved;                    /* graved or not (display only) */
	BOOL	bEmbossed;                  /* embossed or not (display only) */
	BOOL	bBorder;                    /* border or not (display only) */
	COLORREF color;                     /* RGB text color (ignored for sculpted styles )*/
	} TITLE, NEAR *PTITLE, FAR *LPTITLE;


/*******************/
/* CURVE structure */
/*******************/
typedef struct
	{
	LOGPEN	pen;                /* logical color pen */
	BYTE	nSymbol;            /* symbol (see the symbol codes definitions below) */
	BOOL	bNoLine;            /* plot no line, only symbols */
	BOOL	bAlarms;            /* use alarm effects ? */
	double	alarmLow;           /* low alarm limit */
	BYTE	nSymbolLow;         /* symbol to plot if value < low alarm limit */
	double	alarmHigh;          /* high alarm limit */
	BYTE	nSymbolHigh;        /* symbol to plot if value > high alarm limit */
	char	szLegend[31];       /* name for this curve */
	BYTE    reserved[10];       /* reserved for internal use. Do not modify ! */
	} CURVE, NEAR *PCURVE, FAR *LPCURVE;


/************************************************************/
/* Symbol codes definitions for the CURVE.nSymbol attribute */
/************************************************************/
#define	SYM_NONE		0
#define SYM_CIRCLE		1
#define SYM_SQUARE		2
#define SYM_PLUS		3
#define SYM_CROSS		4
#define SYM_DIAMOND		5
#define SYM_DOT			6
#define SYM_STAR		7
#define SYM_TRIANGLE	8


/*******************/
/* GRAPH structure */
/*******************/
#define NUM_CURVES			16
typedef struct
	{
	char	szIniFile[81];              /* the path and filename of the settings file */
	TITLE	title;                      /* the graph's title */
	char	szXLabel[41];               /* label for the X axis (horizontal) */
	char	szYLabel[41];               /* label for the Y axis (vertical) */
	double	xRate;                      /* real interval between two successive entries */
	double	xStart;                     /* real x-value of the first entry */
	double	xRange;                     /* real x-value range that has to be displayed */
	double	yMin, yMax;                 /* y-scale boundaries when not in autoscale mode */
	double	logBase;                    /* base for logarithm scaling (eg. 10 for decimal log) */
	BOOL	bAutoscale;                 /* autoscale the Y axis */
	BOOL	bLogarithmic;               /* logarithmic Y-scale */
	BOOL	bGrid;                      /* display a grid ? */
	BOOL	bTics;                      /* display tics and tic labels */
	BOOL	bMouseTrack;                /* display the real under mouse point coordinates */
	WORD	wTimeFormat;                /* date/time format code for the x axis (see the codes below) */
	WORD	bufferLen;                  /* number of buffered values for each curve */
	WORD	numCurves;                  /* number of curves */
	char	szFontName[MAXFONTNAME];    /* font family name for all but the title */
	int		nFontSize;				    /* font size in pts */
	COLORREF background;			    /* curves-box background RGB-color */
	LOGPEN	penGrid;				    /* the pen to use for the grid */
	LOGPEN	penTics;				    /* the pen to use for the tics */
	CURVE	curves[NUM_CURVES];         /* the curves definition */
	BYTE	reserved[500];
	} GRAPH, NEAR *PGRAPH, FAR *LPGRAPH;



/********************************************************/
/* date/time codes for the GRAPH.wTimeFormat attribute. */
/* Combine with the bitwise or operator (|).            */
/********************************************************/
#define DATE_NO			0x0000
#define DATE_DMY		0x0001
#define DATE_YMD		0x0002
#define DATE_MDY		0x0003
#define DATE_DmY		0x0004
#define DATE_YmD		0x0005
#define DATE_mDY		0x0006

#define TIME_NO			0x0000
#define TIME_HM			0x0100
#define TIME_MS			0x0200
#define TIME_HMS		0x0300
#define TIME_S99		0x0400
#define TIME_MS99		0x0500
#define TIME_HMS99		0x0600



/***********************/
/* Function prototypes */
/***********************/
BOOL FAR PASCAL GZRegister(LPSTR szName, LPSTR szCode);
BOOL FAR PASCAL GZGetSettings(HWND hWnd, LPGRAPH lpGraph);
BOOL FAR PASCAL GZSetSettings(HWND hWnd, LPGRAPH lpGraph);
BOOL FAR PASCAL GZAddPoints(HWND hWnd, double FAR *lpValues, WORD nNumValues);
void FAR PASCAL GZLoadIni(HWND hWnd);
void FAR PASCAL GZWriteIni(HWND hWnd);
BOOL FAR PASCAL GZSetIni(HWND hWnd, LPSTR lpszIniFile);
void FAR PASCAL GZExtractDate(double datetime, LPINT lpnDay, LPINT lpnMonth, LPINT lpnYear);
void FAR PASCAL GZExtractTime(double datetime, LPINT lpnHour, LPINT lpnMinute, LPINT lpnSecond, LPINT lpnHundredth);
double FAR PASCAL GZMakeDate(BYTE nDay, BYTE nMonth, WORD nYear,
				BYTE nHour, BYTE nMinute, BYTE nSecond, BYTE nHundredth);


/*
 *
 *
 * Include the following in your project's .DEF file:
 *
 * IMPORTS
 *			GZRegister=GraphZ.1
 *			GZAddPoints=GraphZ.2
 *			GZGetSettings=GraphZ.3
 *			GZSetSettings=GraphZ.4
 *			GZWriteIni=GraphZ.5
 *			GZLoadIni=GraphZ.6
 *			GZSetIni=GraphZ.7
 *			GZMakeDate=GraphZ.8
 *			GZExtractTime=GraphZ.9
 *			GZExtractDate=GraphZ.10
 *
 * And make a case insensitive link and import.
 *
 *
 *
 */

