/*
 *  This file forms part of "TKERN" - "Troy's Kernel for Windows".
 *
 *  Copyright (C) 1994  Troy Rollo <troy@cbme.unsw.EDU.AU>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	__tkexec_h
#define __tkexec_h

#ifndef __TKPROTO
#include <sys/tkproto.h>
#endif

#ifndef __WINDOWS_H
#include <windows.h>
#endif

#define	fork()	(tkern_fork() == -1 ? -1 : Catch(fork_buf))

extern	CATCHBUF	fork_buf;

extern	int	tkern_fork __TKPROTO((void));

extern	void	_execl __TKPROTO((	char const *pchPath, ...));

extern	void	execl_ext __TKPROTO((	char const *pchCmdLine,
					char const *pchPath,
					...));

extern	void	execv __TKPROTO((	char	const	*pchPath,
					void	const *ppchArgs));

extern	void	execv_ext __TKPROTO((	char	const	*pchCmdLine,
					char	const	*pchPath,
					void	const *ppchArgs));

extern	int	kill __TKPROTO((int, int));

#endif __tkexec_h
