{ Program:   VbxDemo2
  Version:   1.0
  Purpose:   Demo program to show use of dynamically created VBX custom controls
  Date:      12 March 1994
  Developer: Frank Lees (FL)
             Phoenix, Arizona
  CompuServe: 71532,2133


 Copyright (c) 1994 Frank Lees, Peter Sawatzki. All Rights Reserved.
}
Program VbxDemo2;
{$R VbxDemo2.Res}
Uses
  WinProcs,
  oWindows,
  oDialogs,
  WinTypes,
  Strings,
  ThreeD,   { VBX Definition - Generated by VBXInfo }
  Grid,     { VBX definition - Generated by VBXInfo }
  Vbx;      { Interface to BIVBX10.DLL }

Const
  VBXvalidation: tVbxValidation = cVbxValidation;

type { derived object against TPanel generated by VBXINFO }
  PMyPanel =^TMyPanel;
  TMyPanel = object(TSSPanel)
    procedure SetupWindow; virtual;
  end;

type { derived object against TGrid generated by VBXINFO }
  PMyGrid =^TMyGrid;
  TMyGrid = object(TGrid)
    procedure SetupWindow; virtual;
    Procedure evClick     (Var Event: tVbxEvent); Virtual ev_First+0;
    Procedure evSelChange (Var Event: tVbxEvent); Virtual ev_First+13;
  end;

type { Main Window }
  pMyWindow = ^tMyWindow;
  tMyWindow = Object(tVbxWindow)
    ctl1: PMyPanel;
    ctl2: PMyGrid;
    btBusy,btFree: PButton;
    Constructor Init (aParent: pWindowsObject; Name: pChar);
    Procedure SetupWindow; Virtual;
  End;

procedure TMyPanel.SetupWindow;
{- Setup 3D Panel }
var
  x,y:integer;
const
  GRIDROWS=20;
  GRIDCOLS=8;
  DayTab:array[1..7] of PChar = ('Mon','Tue','Wed','Thu','Fri','Sat','Sun');
begin
  inherited SetupWindow;
  SetPropAlignment(aCenterMiddle);
  SetPropBorderWidth(1);
  SetPropBevelWidth(3);
  SetPropBevelOuter(boInset);
  SetPropBevelInner(biInset);
  SetPropCaption('Appointments');
  SetPropFontName('Arial');
  SetPropFontSize(12);
  SetPropFontBold(TRUE);
  SetPropFont3d(fdInsetwlightshading);
  SetPropFontUnderLine(FALSE);
  SetPropFontStrikeThru(FALSE);

  SetPropBackColor(RGB(192,192,192));
end;

procedure TMyGrid.SetupWindow;
{- Setup Grid Control }
var
  x,y:integer;
  pHour: array[0..5] of char;
const
  GRIDROWS=25;
  GRIDCOLS=8;
  DayTab:array[1..7] of PChar = ('Mon','Tue','Wed','Thu','Fri','Sat','Sun');
begin
  inherited SetupWindow;
  SetPropRows(GRIDROWS);
  SetPropCols(GRIDCOLS+1);
  SetPropBackColor(RGB(0,255,0));
  SetPropByName('Scrollbars',3);

  { Grid Headings }
  SetPropRow(0);
  for x:=1 to GRIDCOLS+1 do
    begin
      SetPropCol(x);
      SetPropText(Daytab[x]);
      SetPropFontBold(FALSE);
    end;

  SetPropCol(0);
  for x:=1 to GRIDROWS-1 do
    begin
      SetPropRow(x);
      WVSprintf(pHour,'%02i:00',x);
      SetPropText(pHour);
      SetPropFontBold(FALSE);
    end;

  for x:=1 to GridRows-1 do
    for y:=1 to GridCols-1 do
      begin
        SetPropRow(x);
        SetPropCol(y);
        SetPropText('Free');
      end;

   { Load a Bitmap and an icon into the grid }
   SetPropRow(0);
   SetPropCol(0);
   SetPropPicture(dVbx.LoadPicture('BM1',PICTYPE_BITMAP));
{
  for x:=1 to 7 do
    begin
      SetPropByName('Row',x); SetPropByName('Col',x);
      SetPropPicture(LoadPicture('IC1',PICTYPE_ICON));
   end;
 }
end;

procedure TMyGrid.evClick(Var Event: tVBXEvent);
begin
{  MessageBox(0,'Click','',mb_ok);    }
end;

Procedure TMyGrid.evSelChange (Var Event: tVbxEvent);
var
  x1,x2,y1,y2: integer;
begin
  GetPropSelStartRow (y1);
  GetPropSelEndRow (y2);
  GetPropSelStartCol(x1);
  GetPropSelEndCol(x2);
end;


Procedure tMyWindow.SetupWindow;
Begin
  Inherited SetupWindow;
End;

Constructor tMyWindow.Init (aParent: pWindowsObject; Name: pChar);
Begin
  inherited Init(aParent,Name);
  Attr.W:=500;
  Attr.H:=450;
  ctl1:=new(PMyPanel,Init(@self,100,'Panel100',10,10,300,75,0,NIL));
  ctl2:=new(PMyGrid,Init(@self,101,'Grid101',10,120,380,250,0,NIL));
  btFree:=new(PButton,Init(@self,500,'&Free',420,150,50,20,FALSE));
  btBusy:=new(PButton,Init(@self,501,'&Busy',420,200,50,20,FALSE));

End;


{-------------------- the Application part }
Const
  ProgName = 'VbxDemo2';
Type
  tProgApp = Object(tApplication)
    Procedure InitMainWindow; Virtual;
  End;

Procedure tProgApp.InitMainWindow;
Begin
  MainWindow:= New(pMyWindow, Init(Nil, 'Dynamically Created VBX Control Demo'))
End;

Var
  App: tProgApp;
Begin
  RegisterVBX(VBXvalidation);
  With App Do Begin
    Init(ProgName);
    Run;
    Done
  End
End.

