' FOLDERS-II v1.6 by Antonio Cordero. Original module by James Parr.

' This module is Public Domain

' This module allows you to use Folders without the need of a VBX control.
' The differences of version 1.0 with the original module by James Parr are
' the following:
'  - 3D
'  - More than a folder per form
'  - Can use panels at the same time as folders
'  - The Tabs text don't overwrite if too large
'  - If more than a Tab row, the folder will adjust its position to see all of them
'  - You can enable/disable each Tab
'  - Accelerators to change the current Tab

' Version 1.5:
'  - Better support of form colors, no more necessary to be bright gray
'  - FolderEnable, FolderDisable, FolderEnabled()
'  - Can put a graphic in each Tab in every position: Left, Right, Top, Bottom
'  - Better use of panel's area. Only the Caption is overwritten
'  - Support for Folders inside Folders
'  - Tab styles: Normal (Chamfered), Slanted, Chicago
'  - Can specify offset between rows
'  - Name changes:
'      CurrentFolder() become CurrentTab()
'      NumFolders()    become NumTabs()
'  - Can share controls over all the Tabs of a Folder using SetFixedControl
'  - TightenForm modified: don't change vertical position and allows space below
'  - Multiple lines titles
'  - Can know which Tab has been clicked before and after the change

' Version 1.6:
'  - First international version. Being released to the Internet
'  - Changes and corrections to comments when traducing to English
'  - Disabled graphics are a lot faster
'  - New effect: 3D border selectable at left/right side of folder
'  - New functions: FolderLeft, FolderTop, FolderWidth, FolderHeight
'  - New sub: FolderMove
'  - Bug with colors in folder with more than one row if inside a container
'  - Corrected some other drawing bugs (too many)
'  - New sub: ReDefineFolder
'  - Can change number of tabs at runtime
'  - New effect: overlapped or separated tabs
'  - Colored Tabs (Compatibility WARNING: see FloodColor/ForeColor prop. below)
'  - Changed: folders inside folders need to be inside a picturebox
'             (problem with SSPanels not having ScaleMode property)
'  - Can redefine X offset of Tabs diagonals in the Style parameter

' For any sugerence or bug i can be reached at:
'  - Internet E-mail: ccanto@eui.upm.es
'  - "Las Profundidades del DEMoO" or ...uh..."The Deepnesses of the DEM'N" :-)
'      +34(Spain)-1(Madrid)-7300942 (put message to cosysop NetDevil)

' Form of use:
' ------------
' Create as much SSPanels (THREED.VBX) as tabs you want in the folder, all in a control array.
' If you want to use multiple lines captions, use "\$" as line separator.
' Put the following properties to the SSPanels:
'   Caption        = the Tab title
'   Alignment      = 0 - (Left Justify) - TOP
'   BevelInner     = 0 - none
'   BevelOuter     = 2 - raised
'   BevelWidth     = 2
'   BorderWidth    = 2
'   Outline        = True
'   RoundedCorners = False
'   Tag            = folder identification, maybe the panels name
'   BackColor      = as you like
'   FloodColor     = background color for the tab
'      (use the same as BackColor to be compatible with previous versions)
'   ForeColor      = foreground color for the tab
'
' Create two PictureBoxes that you will pass as parameters to DefineFolders. No
'  properties needed.
'
' If you want to use graphics in the tabs, create a control array of PictureBoxes that
'  contain the graphics and with the Tag property the same as of the panels. If any of
'  the PictureBoxes have no graphic (Picture=(none)) the corresponding tab will have
'  no graphic. But you must make an array of N pictureboxes being N the number of
'  panels.

' Put in Form1.Load:
'  Success% = DefineFolders (Index, NumTabsPerRow, Panel3D(0), FoldersTag,
'                            TabPicture1, TabPicture2, Container, TabStyle,
'                            RowOffset, PicturesPosition, GrayPictures,
'                            LeftBorder, BetweenTabs)
' The parameters are:
'  Index : index of the folder in the program, 0 to 49
'  NumTabsPerRow : number of Tabs per row :). 0 means all in one row.
'  Panel3D(0) : first element of an array of 3D panels created as said above.
'               Index 0 panel will be the base for the others.
'  FoldersTag : tag common to all the panels of the folder. Allows you to have
'               other SSPanels in the same form assuming that they don't have
'               this tag. It also allows you to put more than one folder in
'               the form.
'  TabPicture1 y TabPicture2 : the pictures created as said above.
'  Container : keyword Nothing if the folder is directly in a Form, or, the
'              container control. The container control must have the ScaleMode
'              property, so the best choice is a PictureBox.
'  TabStyle : low byte: 0 = Chamfered, 1 = Slanted, 2 = Chicago
'             high byte: X offset of Tabs diagonals (0=default) (pixels)
'                        (only for Chamfered and Slanted, i.e. &H0601 = Slanted
'                         with diagonal.X = 6)
'  RowOffset : horizontal offset between rows (pixels).
'  PicturesPosition : graphics position: 0 = Left, 1 = Right, 2 = Top, 3 = Bottom
'  GrayPictures : True if the graphics must be grayed when disabled.
'  LeftBorder : True if the 3D border of not-first rows is at the left side.
'  BetweenTabs : number of pixels between tabs. Can be negative to make
'                overlapped tabs (pixels).

' If you want to use accelerators to access a tab, make form1.KeyPreview = TRUE
' and put in form1.KeyUp:
'  keycode = GotoFolderByAccel(Index, keycode, shift)
' Being Index the folder index in the program
'
' WARNING: If you click the keys to access a tab and that tab is the current,
'          the control who have the focus could be activated (clicked).
'          The solution is to make the TabStop property to False in all the
'          controls of the folder.

' Put in TabPicture1.MouseUp:
'  FolderClick Index, Button, X, Y
' or:
'  i = FolderClickFn (Index, Button, X, Y)
' Being Index the index to the folder (0-49).
' The function FolderClickFn returns the selected tab (0 is first)
' Your can use the function FolderClicked(Index, X, Y) before FolderClick or
'  FolderClickFn to know which tab will be selected before it changes.

' If you want to use shared controls, create them in the first panel (index 0)
'  and, in Form1.Load, after the DefineFolders command:
'    SetFixedControl Index, Control
'  for each shared control (if a control is inside a container, only use
'  SetFixedControl with the container), being Index the index to the folder
'  in the program. Also put in Form1.Unload:
'    ResetFixedControls Index
' Controls of types Label, Shape, Line, Image, and others without hWnd property
'  cannot be shared, but you can share them if you put them inside a container
'  that have a hWnd property, a picturebox, for example.
' The best method to share controls is to put them inside a PictureBox and then
'  share only this PictureBox.

' You can use the following routines (Index is the index of the folder):
'  n = CurrentTab (Index) : gets the current tab
'  n = NumTabs (Index) : gets the number of tabs in the folder
'  NextFolder Index : displays the next tab
'  PrevFolder Index : displays the previous tab
'  GotoFolder Index, TabNumber : displays the tab TabNumber (first is 0)
'  TightenForm Index, BelowSpace, NoBorders : adjusts the form around the folder
'                                             with BelowSpace below the folder and
'                                             optional visible borders.
'  TabEnable Index, TabNumber  : enables the tab TabNumber
'  TabDisable Index, TabNumber : disables the tab TabNumber
'  flag% = TabEnabled (Index, TabNumber)  : returns TRUE if the tab TabNumber
'                                           is enabled
'  FolderEnable Index  : enables the folder
'  FolderDisable Index : disables the folder
'  flag% = FolderEnabled (Index) : returns TRUE if the folder is enabled
'  l = FolderLeft (Index)
'  t = FolderTop (Index)
'  w = FolderWidth (Index)
'  h = FolderHeight (Index) : get the folder position and size (in pixels)
'  FolderMove Index, Left, Top : move the folder to position (Left, Top) (pixels)
'  Success% = ReDefineFolders (Index, NumTabsPerRow, TabStyle, RowOffset,
'                              PicturesPosition, GrayPictures, LeftBorder,
'                              BetweenTabs)
'          : Change folder settings, parameters are the same as in DefineFolders
'            You can use it after adding or removing panels.

Option Explicit

' Max. 50 folders of 20 tabs (change if necessary)
Const MaxFolders = 50 - 1
Const MaxTabs = 20 - 1
Const MaxFixedControls = 10
Const TabOffsetConstant = 4

Global CurrentTab(0 To MaxFolders)  As Integer   ' Current active folder
Global NumTabs(0 To MaxFolders)  As Integer  ' Total number of folders
Global TabEnabled(0 To MaxFolders, 0 To MaxTabs) As Integer ' Tab enabled ?
Global FolderEnabled(0 To MaxFolders) As Integer ' Folder enabled ?

Dim Folders(0 To MaxFolders, 0 To MaxTabs)   As Control ' Array of the form's folders
Dim FoldersPictures(0 To MaxFolders, 0 To MaxTabs)   As Control ' Array of the form's folders pictures
Dim VisibleTabs(0 To MaxFolders)  As Integer    ' Number of tabs across screen
Dim OneTabHeight(0 To MaxFolders)  As Integer   ' Height of one row of tabs
Dim FolderTabs(0 To MaxFolders)  As Control     ' Picture to paint tabs on
Dim FolderBorder(0 To MaxFolders)  As Control   ' Picture to paint borders
Dim TabWidth(0 To MaxFolders)  As Long          ' Tab width
Dim NumRows(0 To MaxFolders)  As Integer        ' Number of tabs rows
Dim TabOffset(0 To MaxFolders)  As Integer      ' # of pixels for tab's diagonal
Dim TabAccel(0 To MaxFolders, 0 To MaxTabs) As Integer ' Accelerator keys
Dim FolderContainer(0 To MaxFolders) As Control ' Folder containers
Dim PicturesPosition(0 To MaxFolders) As Integer ' Graphics positions
Dim FixedControls(0 To MaxFolders, 1 To MaxFixedControls) As Control ' Fixed controls
Dim NumFixedControls(0 To MaxFolders) As Integer
Dim TabStyle(0 To MaxFolders)  As Integer
Dim GrayPictures(0 To MaxFolders) As Integer
Dim LeftBorder(0 To MaxFolders) As Integer
Dim BetweenTabs(0 To MaxFolders) As Integer
Dim RowOffset(0 To MaxFolders)  As Long ' Offset between rows

' Used for border/menu sizes
Declare Function getsystemmetrics% Lib "User" (ByVal nIndex%)
' Used to see if menu is used
Declare Function GetMenu Lib "User" (ByVal hWnd%) As Integer
' Used to fill zones
Declare Function ExtFloodFill Lib "GDI" (ByVal hDC%, ByVal i%, ByVal i%, ByVal W&, ByVal i%) As Integer
Const FLOODFILLBORDER = 0  ' Fill until color encountered.
Const FLOODFILLSURFACE = 1 ' Fill surface until color not encountered.
' Used to copy the graphics of the tabs
Declare Function bitblt Lib "GDI" (ByVal hDestDC As Integer, ByVal X As Integer, ByVal y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal hSrcDC As Integer, ByVal XSrc As Integer, ByVal YSrc As Integer, ByVal dwRop As Long) As Integer
' Used to move fixed controls between tabs
Declare Function setparent% Lib "user" (ByVal H%, ByVal H%)
Declare Function getfocus% Lib "user" ()
' Used to gray a graphic
Declare Function CreateBitmap Lib "GDI" (ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal nPlanes As Integer, ByVal nBitCount As Integer, ByVal lpBits As Any) As Integer
Declare Function CreatePatternBrush Lib "GDI" (ByVal hBitmap As Integer) As Integer
Declare Function SelectObject Lib "GDI" (ByVal hDC As Integer, ByVal hObject As Integer) As Integer
Declare Function DeleteObject Lib "GDI" (ByVal hObject As Integer) As Integer
Declare Function PatBlt Lib "GDI" (ByVal hDC As Integer, ByVal X As Integer, ByVal y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal dwRop As Long) As Integer
' Used to fill the tabs
Type Coord        ' This is the type structure for the x and y
    X As Integer  ' coordinates for the polygonal region.
    y As Integer
End Type
Declare Function CreatePolygonRgn Lib "gdi" (lpPoints As Any, ByVal nCount As Integer, ByVal nPolyFillMode As Integer) As Integer
Declare Function Polygon Lib "gdi" (ByVal hDC As Integer, lpPoints As Any, ByVal nCount As Integer) As Integer
Declare Function FillRgn Lib "gdi" (ByVal hDC As Integer, ByVal hrgn As Integer, ByVal hbrush As Integer) As Integer
Declare Function CreateSolidBrush Lib "GDI" (ByVal crColor As Long) As Integer

' Locate the folder controls
' Set the Folders array to point to the folders
' Modify each folder to match the first folder (index=0)
Function DefineFolders (idx As Integer, numacross As Integer, Fldr As Control, FolderTag As String, foldertabcontrol As Control, folderbordercontrol As Control, Container As Control, Style As Integer, RowOffs As Integer, PicPosition As Integer, GrayGph As Integer, LeftBdr As Integer, BwTabs As Integer) As Integer
Dim i, i2 As Integer
Dim accel As Integer
Dim titulo As String
Dim numlin, num_lineas As Integer
Dim max As Integer
Dim texto As Integer
Dim oldscalemode As Integer

  If idx > MaxFolders Then Exit Function
  LeftBorder(idx) = LeftBdr
  BetweenTabs(idx) = BwTabs
  If LeftBdr Then
    RowOffset(idx) = -RowOffs
  Else
    RowOffset(idx) = RowOffs
  End If
  Set FolderContainer(idx) = Container
  For i = 0 To MaxTabs
    Set FoldersPictures(idx, i) = Nothing
  Next

  ' Find out how many folders in an array are on the form
  ' Done by checking each control to see if it is a folder
  '   and then checking each folder to see if it has an index
  '   value (part of an array of folders)
  ' Checks if the tag is correct
  NumTabs(idx) = 0
  On Error GoTo NoIndex
  For i = 0 To Fldr.Parent.Controls.Count - 1
    If TypeOf Fldr.Parent.Controls(i) Is SSPanel Then
      If Fldr.Parent.Controls(i).Index < 0 Or Fldr.Parent.Controls(i).Index > MaxTabs Or Fldr.Parent.Controls(i).Tag <> FolderTag Then
	' Fill Space
      Else
	If Fldr.Parent.Controls(i).Index > NumTabs(idx) Then NumTabs(idx) = Fldr.Parent.Controls(i).Index
      End If
    End If
  Next i
  On Error GoTo 0
  
  ' Fill the Folders array with pointers to the folder
  '   on the form
  ' Done by the same loop as last time, but this time
  '   I assign it to an array
  ' Also assigns graphics
  On Error GoTo NoIndex
  For i = 0 To Fldr.Parent.Controls.Count - 1
    If TypeOf Fldr.Parent.Controls(i) Is SSPanel Then
      If Fldr.Parent.Controls(i).Index < 0 Or Fldr.Parent.Controls(i).Index > MaxTabs Or Fldr.Parent.Controls(i).Tag <> FolderTag Then
	'Fill Space
      Else
	On Error GoTo 0
	Set Folders(idx, Fldr.Parent.Controls(i).Index) = Fldr.Parent.Controls(i)
	On Error GoTo NoIndex
      End If
    ElseIf TypeOf Fldr.Parent.Controls(i) Is PictureBox Then
	If Fldr.Parent.Controls(i).Index < 0 Or Fldr.Parent.Controls(i).Index > MaxTabs Or Fldr.Parent.Controls(i).Tag <> FolderTag Then
	'Fill Space
	Else
	On Error GoTo 0
	Set FoldersPictures(idx, Fldr.Parent.Controls(i).Index) = Fldr.Parent.Controls(i)
	FoldersPictures(idx, Fldr.Parent.Controls(i).Index).Visible = False
	FoldersPictures(idx, Fldr.Parent.Controls(i).Index).AutoRedraw = True
	FoldersPictures(idx, Fldr.Parent.Controls(i).Index).ScaleMode = 3 ' Pixels
	On Error GoTo NoIndex
	End If
    End If
  Next i
  On Error GoTo 0
  
  oldscalemode = GetScaleMode(idx)
  SetScaleMode idx, 3 ' Pixels
  
  ' Define Standard variables
  If numacross = 0 Then
    VisibleTabs(idx) = NumTabs(idx) + 1
  Else
    VisibleTabs(idx) = numacross
  End If
  
  TabOffset(idx) = (Style \ 256) And &HFF
  If TabOffset(idx) = 0 Then
      Select Case (Style And &HFF)
	Case 0: TabOffset(idx) = 4   ' Chamfered
	Case 1: TabOffset(idx) = 12  ' Slanted
	Case 2: TabOffset(idx) = 0   ' Chicago
	Case Else
	    TabOffset(idx) = 4 ' Chamfered
	    Style = &H0
      End Select
  Else
      Select Case (Style And &HFF)
	Case 2: TabOffset(idx) = 0   ' Chicago always has TabOffset = 0
		Style = &H2
      End Select
  End If
  TabStyle(idx) = Style

  PicturesPosition(idx) = PicPosition
  GrayPictures(idx) = GrayGph
  num_lineas = 1

  If (Folders(idx, 0).Alignment Mod 3) = 1 Then Folders(idx, 0).Alignment = 0
  'Modify all the folders to match folder0
  For i = 0 To NumTabs(idx)
    Folders(idx, i).Top = Folders(idx, 0).Top
    Folders(idx, i).Left = Folders(idx, 0).Left
    Folders(idx, i).Width = Folders(idx, 0).Width
    Folders(idx, i).Height = Folders(idx, 0).Height
    Folders(idx, i).BackColor = Folders(idx, 0).BackColor
    'Folders(idx, i).Tag = Folders(idx, i).Caption
    Folders(idx, i).FontBold = False
    Folders(idx, i).FontItalic = Folders(idx, 0).FontItalic
    Folders(idx, i).FontName = Folders(idx, 0).FontName
    Folders(idx, i).FontSize = Folders(idx, 0).FontSize
    Folders(idx, i).FontStrikethru = Folders(idx, 0).FontStrikethru
    Folders(idx, i).FontUnderline = False
    'Folders(idx, i).ForeColor = Folders(idx, 0).ForeColor
    Folders(idx, i).Visible = True
    Folders(idx, i).BevelWidth = 2
    Folders(idx, i).BorderWidth = 2
    Folders(idx, i).BevelInner = 0
    Folders(idx, i).BevelOuter = 2
    Folders(idx, i).Alignment = Folders(idx, 0).Alignment Mod 3
    Folders(idx, i).Outline = True
    Folders(idx, i).ShadowColor = 0
    Folders(idx, i).ZOrder 1
    TabEnabled(idx, i) = True
    
    titulo$ = Folders(idx, i).Caption
    i2 = 1         ' Get accelerator
    accel = 0
    numlin = 1
    While i2 <= Len(titulo$)
	If Mid$(titulo$, i2, 2) = "&&" Then
	    i2 = i2 + 2
	ElseIf Mid$(titulo$, i2, 1) = "&" And accel = 0 Then
	    accel = i2 + 1
	ElseIf Mid$(titulo$, i2, 2) = "\$" Then
	    numlin = numlin + 1
	End If
	i2 = i2 + 1
    Wend
    If numlin > num_lineas Then num_lineas = numlin
    If accel > 0 Then
	TabAccel(idx, i) = Asc(UCase(Mid$(titulo$, accel, 1)))
    Else
	TabAccel(idx, i) = 0
    End If

  Next i
  'CurrentTab(idx) = 0  ' Start with the first folder highlighted
		 ' If you want a different first folder, use
		 '   the GotoFolder function right after you
		 '   use DefineFolders
  FolderEnabled(idx) = True
  
  ' Calculate the number of rows needed to display all tabs
  NumRows(idx) = NumTabs(idx) \ VisibleTabs(idx) + 1
  
    ' Set the picture box's properties
    Set FolderTabs(idx) = foldertabcontrol
    Set FolderBorder(idx) = folderbordercontrol
    FolderTabs(idx).Cls
    FolderTabs(idx).AutoSize = False
    FolderTabs(idx).ScaleMode = 3 ' Pixels
    If LeftBorder(idx) Then
	FolderTabs(idx).Left = Folders(idx, 0).Left - (NumRows(idx) - 1) * Abs(RowOffset(idx))
    Else
	FolderTabs(idx).Left = Folders(idx, 0).Left
    End If
    FolderTabs(idx).AutoRedraw = True
    FolderTabs(idx).BackColor = Folders(idx, 0).BackColor
    FolderTabs(idx).BorderStyle = 0
    FolderTabs(idx).DragMode = 0
    FolderTabs(idx).Enabled = True
    FolderTabs(idx).DrawStyle = 0
    FolderTabs(idx).FontBold = Folders(idx, 0).FontBold
    FolderTabs(idx).FontBold = Folders(idx, 0).FontBold
    FolderTabs(idx).FontItalic = Folders(idx, 0).FontItalic
    FolderTabs(idx).FontName = Folders(idx, 0).FontName
    FolderTabs(idx).FontSize = Folders(idx, 0).FontSize
    FolderTabs(idx).FontStrikethru = Folders(idx, 0).FontStrikethru
    FolderTabs(idx).FontUnderline = Folders(idx, 0).FontUnderline
    FolderTabs(idx).ForeColor = Folders(idx, 0).ForeColor
    FolderTabs(idx).LinkMode = 0
    FolderTabs(idx).MousePointer = 0
    FolderTabs(idx).TabStop = False
    FolderTabs(idx).FillStyle = 0
    FolderTabs(idx).FillColor = FolderTabs(idx).Parent.BackColor
    On Error Resume Next ' If FolderContainer dont exists it jumps over the next instruction
    FolderTabs(idx).FillColor = FolderContainer(idx).BackColor
    'FolderTabs(idx).BackColor = FolderTabs(idx).FillColor
    On Error GoTo 0
    FolderTabs(idx).Visible = True
    FolderTabs(idx).ZOrder 0
    TabWidth(idx) = ((Folders(idx, 0).Width - BwTabs * (VisibleTabs(idx) - 1)) \ VisibleTabs(idx))

    ' Calculate the tab height based on the height of a sample
    '   letter + the offset height
    texto = FolderTabs(idx).TextHeight("X") * num_lineas
    max = 0
    On Error Resume Next
    For i = 0 To NumTabs(idx) ' get max height of graphics
    If FoldersPictures(idx, i).Height > max Then max = FoldersPictures(idx, i).Height
    FoldersPictures(idx, i).AutoSize = True
    If FoldersPictures(idx, i).Width > TabWidth(idx) Then
	FoldersPictures(idx, i).AutoSize = False
	FoldersPictures(idx, i).Width = TabWidth(idx) - 2 * TabOffset(idx)
    End If
    Next
    On Error GoTo 0
    If PicturesPosition(idx) <= 1 Then ' If it is Left/Right
	If texto > max Then max = texto
    Else
	max = max + texto + TabOffsetConstant
    End If
    OneTabHeight(idx) = max + 2 * TabOffsetConstant
    
    FolderTabs(idx).Height = OneTabHeight(idx) * NumRows(idx) + 3
    FolderTabs(idx).Top = Folders(idx, 0).Top
    
    ' Move down the panels
    For i = 0 To NumTabs(idx)
      Folders(idx, i).Top = FolderTabs(idx).Top + NumRows(idx) * OneTabHeight(idx) - FolderTabs(idx).TextHeight("X")
    Next
  
  FolderTabs(idx).Width = Folders(idx, 0).Width + (NumRows(idx) - 1) * Abs(RowOffset(idx))

  ' Configure second picture
  FolderBorder(idx).AutoSize = False
  FolderBorder(idx).ScaleMode = 3 ' Pixels
  FolderBorder(idx).Width = (NumRows(idx) - 1) * Abs(RowOffset(idx))
  If LeftBorder(idx) Then
    FolderBorder(idx).Left = Folders(idx, 0).Left - FolderBorder(idx).Width
  Else
    FolderBorder(idx).Left = Folders(idx, 0).Left + Folders(idx, 0).Width
  End If
  FolderBorder(idx).Top = FolderTabs(idx).Top + FolderTabs(idx).Height
  FolderBorder(idx).Height = Folders(idx, 0).Top + Folders(idx, 0).Height - FolderBorder(idx).Top
  FolderBorder(idx).AutoRedraw = True
  FolderBorder(idx).BackColor = Folders(idx, 0).BackColor
  FolderBorder(idx).BorderStyle = 0
  FolderBorder(idx).DragMode = 0
  FolderBorder(idx).Enabled = True
  FolderBorder(idx).FillStyle = 0
  FolderBorder(idx).FillColor = FolderTabs(idx).FillColor
  FolderBorder(idx).DrawStyle = 0
  FolderBorder(idx).FontBold = Folders(idx, 0).FontBold
  FolderBorder(idx).FontBold = Folders(idx, 0).FontBold
  FolderBorder(idx).FontItalic = Folders(idx, 0).FontItalic
  FolderBorder(idx).FontName = Folders(idx, 0).FontName
  FolderBorder(idx).FontSize = Folders(idx, 0).FontSize
  FolderBorder(idx).FontStrikethru = Folders(idx, 0).FontStrikethru
  FolderBorder(idx).FontUnderline = Folders(idx, 0).FontUnderline
  FolderBorder(idx).ForeColor = Folders(idx, 0).ForeColor
  FolderBorder(idx).LinkMode = 0
  FolderBorder(idx).MousePointer = 0
  FolderBorder(idx).TabStop = False
  FolderBorder(idx).Visible = (NumRows(idx) > 1) And (RowOffset(idx) <> 0)
  FolderBorder(idx).ZOrder 0

  If CurrentTab(idx) > NumTabs(idx) Then
    SetFixedControlsToTab idx, 0
    CurrentTab(idx) = 0
  End If
  
  Call ShowFolder(idx)
  
  DefineFolders = True

  SetScaleMode idx, oldscalemode

  Exit Function
NoIndex:
  Resume Next

End Function

' Draws a single folder tab
' TabNumber = the tab that is being drawn
' HorPos = the tabs horizontal position on the folders
' VerPos = the row the tab is on
' Foreground = True if it is the currently selected tab
Private Sub DrawTab (idx As Integer, TabNumber As Integer, horpos As Integer, verpos As Integer, foreground As Integer)
Dim TabTextWidth As Long
Dim L%, R%, T%, B%
 
Dim titulo As String
Dim ancho_borde3D As Integer
Dim col As Long
Dim i As Integer
Dim accel As Integer
Dim ancho_grafico, ancho_grafico2, alto_grafico, alto_grafico2, alto_texto As Integer
Dim X, y As Integer
Dim xtitulo, ytitulo As Integer
Dim bajo As Integer
Dim resto As Integer
Dim grafico As Control
Dim xp, yp, yy As Integer
Dim ic As Long
Dim lineas_titulo() As String
Dim num_lineas As Integer
Dim last_mark As Integer
Dim accel_line As Integer
Dim pic As Control
Dim n As Integer
Dim offset_tab As Integer
Dim colorborde As Long
Dim alto As Integer
Dim cr As Integer
Dim cg As Integer
Dim cb As Integer
Dim oldscalemode As Integer

  oldscalemode = GetScaleMode(idx)
  SetScaleMode idx, 3

  If LeftBorder(idx) Then
    offset_tab = (NumRows(idx) - 1) * Abs(RowOffset(idx))
  Else
    offset_tab = 0
  End If

  ' Set the Top/Bottom/Left/Right values of the single tab
  T = OneTabHeight(idx) * (NumRows(idx) - verpos)
  B = T + OneTabHeight(idx)
  L = offset_tab + (TabWidth(idx) + BetweenTabs(idx)) * horpos + (verpos - 1) * RowOffset(idx)
  R = L + TabWidth(idx) - 1
  ' In case the tabwidth doesn't adjust perfectly to the number of visible tabs, adjust the last tab end
  If (TabNumber + 1) Mod VisibleTabs(idx) = 0 Then R = offset_tab + Folders(idx, 0).Width + (verpos - 1) * RowOffset(idx) - 1

  resto = (NumTabs(idx) \ VisibleTabs(idx)) * VisibleTabs(idx)
  bajo = B
  If Not foreground Then bajo = bajo - 1
  
  ReDim poly(1 To 6) As Coord
  Dim hbrush As Integer
  Dim hrgn As Integer
  Dim bool As Integer

  ' Number of vertices in polygon.
  poly(1).X = L
  poly(1).y = bajo + 1
  If (TabStyle(idx) And &HFF) <> 1 Then
    poly(2).X = L
    poly(2).y = T + TabOffset(idx)
  Else
    poly(2).X = poly(1).X
    poly(2).y = poly(1).y
  End If
  poly(3).X = L + TabOffset(idx)
  poly(3).y = T
  poly(4).X = R - TabOffset(idx)
  poly(4).y = T
  If (TabStyle(idx) And &HFF) <> 1 Then
    poly(5).X = R
    poly(5).y = T + TabOffset(idx)
  Else
    poly(5).X = poly(4).X
    poly(5).y = poly(4).y
  End If
  poly(6).X = R
  poly(6).y = bajo + 1
  
  ' Polygon function creates unfilled polygon on screen.
  'bool = Polygon(FolderTabs(idx).hDC, poly(1), 6)
  ' Create brush with fill color
  hbrush = CreateSolidBrush(Folders(idx, TabNumber).FloodColor)
  ' Creates region to fill with color.
  hrgn = CreatePolygonRgn(poly(1), 6, 1) ' 1 = ALTERNATE
  ' If the creation of the region was successful then color.
  If hrgn Then
    If hbrush Then
	bool = FillRgn(FolderTabs(idx).hDC, hrgn, hbrush)
	bool = DeleteObject(hbrush)
    End If
    bool = DeleteObject(hrgn)
  End If

  ' Draw the lines around the tab in 3D
  
  ' Draws gray/white border

  FolderTabs(idx).PSet (L + 1, bajo), &H80000005
  If (TabStyle(idx) And &HFF) <> 1 Then FolderTabs(idx).Line -(L + 1, T + TabOffset(idx)), &H80000005
  FolderTabs(idx).Line -(L + TabOffset(idx), T + 1), &H80000005
  FolderTabs(idx).Line -(R - TabOffset(idx), T + 1), &H80000005
  If (TabStyle(idx) And &HFF) <> 1 Then FolderTabs(idx).Line -(R - 1, T + TabOffset(idx)), &H80000010
  FolderTabs(idx).Line -(R - 1, bajo + 1), &H80000010

  If foreground Then ' Double border if current tab
      FolderTabs(idx).PSet (L + 2 * 1, bajo + 1), &H80000005
      If (TabStyle(idx) And &HFF) <> 1 Then FolderTabs(idx).Line -(L + 2 * 1, T + TabOffset(idx)), &H80000005
      FolderTabs(idx).Line -(L + TabOffset(idx) + 1, T + 2 * 1), &H80000005
      FolderTabs(idx).Line -(R - TabOffset(idx) - 1, T + 2 * 1), &H80000005
      If (TabStyle(idx) And &HFF) <> 1 Then FolderTabs(idx).Line -(R - 2 * 1, T + TabOffset(idx)), &H80000010
      FolderTabs(idx).Line -(R - 2 * 1, bajo + 2 * 1), &H80000010
  End If
  
  ' Draws black tab border
  FolderTabs(idx).PSet (L, bajo), 0
  If (TabStyle(idx) And &HFF) <> 1 Then FolderTabs(idx).Line -(L, T + TabOffset(idx)), 0
  FolderTabs(idx).Line -(L + TabOffset(idx), T), 0
  FolderTabs(idx).Line -(R - TabOffset(idx), T), 0
  If (TabStyle(idx) And &HFF) <> 1 Then FolderTabs(idx).Line -(R, T + TabOffset(idx)), 0
  FolderTabs(idx).Line -(R, bajo + 1), 0

  ' If it is the selected folder or the first of a row, draw a grey line underneath
  If foreground Then
    FolderTabs(idx).DrawWidth = 3
    FolderTabs(idx).Line (R - 4 * 1, B + 1)-(L + 4 * 1, B + 1), Folders(idx, 0).BackColor
    FolderTabs(idx).DrawWidth = 1
  ElseIf (TabNumber Mod VisibleTabs(idx) = 0 And verpos > 1) Then
    FolderTabs(idx).DrawWidth = 3
    FolderTabs(idx).Line (R - 3 * 1, B + 1)-(L + 3 * 1, B + 1), Folders(idx, 0).BackColor
    FolderTabs(idx).DrawWidth = 1
  End If
  ' Print the tab's title (bold if foreground)
  
  FolderTabs(idx).FontBold = foreground
  titulo$ = Folders(idx, TabNumber).Caption & "\$"
  
  num_lineas = 0
  last_mark = 0
  i = 1         ' Removes &&, gets accelerator and divide in lines
  accel = 0
  While i <= Len(titulo$)
    If Mid$(titulo$, i, 2) = "&&" Then
	titulo$ = Left$(titulo$, i) & Mid$(titulo$, i + 2)
	i = i + 1
    ElseIf Mid$(titulo$, i, 1) = "&" And accel = 0 Then
	titulo$ = Left$(titulo$, i - 1) & Mid$(titulo$, i + 1)
	accel = i
	accel_line = num_lineas + 1
    ElseIf Mid$(titulo$, i, 2) = "\$" Then
	num_lineas = num_lineas + 1
	ReDim Preserve lineas_titulo$(1 To num_lineas)
	lineas_titulo$(num_lineas) = Mid$(titulo$, last_mark + 1, i - last_mark - 1)
	last_mark = i + 1
    End If
    i = i + 1
  Wend

  ancho_grafico = 0
  On Error Resume Next
  If FoldersPictures(idx, TabNumber).Picture <> 0 Then
    ancho_grafico = FoldersPictures(idx, TabNumber).Width
  End If
  ancho_grafico2 = ancho_grafico
  If PicturesPosition(idx) > 1 Then ancho_grafico2 = 0

  If ancho_grafico > 0 Then
    alto_grafico = FoldersPictures(idx, TabNumber).Height
    If titulo$ <> "\$" Then
	Select Case PicturesPosition(idx)
	    Case 0 ' Left
		    X = (L + TabOffset(idx) + TabOffsetConstant)
		    y = (T + (OneTabHeight(idx) - alto_grafico) \ 2)
	    Case 1 ' Right
		    X = (R - ancho_grafico - TabOffset(idx) - TabOffsetConstant)
		    y = (T + (OneTabHeight(idx) - alto_grafico) \ 2)
	    Case 2 ' Top
		    X = (L + (TabWidth(idx) - ancho_grafico) \ 2)
		    y = (T + 2 * TabOffsetConstant)
	    Case 3 ' Bottom
		    X = (L + (TabWidth(idx) - ancho_grafico) \ 2)
		    y = (B - alto_grafico - TabOffsetConstant)
	End Select
    Else
	X = (L + (TabWidth(idx) - ancho_grafico) \ 2)
	y = (T + (OneTabHeight(idx) - alto_grafico) \ 2)
    End If
    ancho_grafico2 = ancho_grafico
    alto_grafico2 = alto_grafico
    i = bitblt(FolderTabs(idx).hDC, X, y, ancho_grafico2, alto_grafico2, FoldersPictures(idx, TabNumber).hDC, 0, 0, &HCC0020)
    If GrayPictures(idx) And Not TabEnabled(idx, TabNumber) Or Not FolderEnabled(idx) Then
	' gray graphic
	Set pic = FolderTabs(idx)
	Dim hbmp As Integer
	Dim hbr As Integer
	Dim hbrprev As Integer
	Dim graypattern As String
	Const PATPAINT = &HFB0A09
	Const PATCOPY = &HF00021
	Const PATINVERT = &H5A0049
	Const GRAYCODE = &HFA0089
	graypattern = ""
	For yp = 1 To alto_grafico2 \ 2
	    For xp = 1 To ancho_grafico2 \ 8
		graypattern = graypattern & Chr$(&H55)
	    Next
	    For xp = 1 To ancho_grafico2 \ 8
		graypattern = graypattern & Chr$(&HAA)
	    Next
	Next
	hbmp = CreateBitmap(8 * (ancho_grafico2 \ 8), 2 * (alto_grafico2 \ 2), 1, 1, ByVal graypattern)
	hbr = CreatePatternBrush(hbmp)
	hbrprev = SelectObject(pic.hDC, hbr)
	i = PatBlt(pic.hDC, X, y, ancho_grafico2, alto_grafico2, GRAYCODE)
	i = SelectObject(pic.hDC, hbrprev)
	i = DeleteObject(hbr)
	i = DeleteObject(hbmp)
    End If
  End If
  
  If Not TabEnabled(idx, TabNumber) Or Not FolderEnabled(idx) Then
    FolderTabs(idx).ForeColor = &H808080
  Else
    FolderTabs(idx).ForeColor = Folders(idx, TabNumber).ForeColor
  End If
  
  For i = 1 To num_lineas
      titulo$ = Trim$(lineas_titulo$(i))
      Do
	  TabTextWidth = FolderTabs(idx).TextWidth(titulo$)
	  If TabTextWidth + ancho_grafico + 2 * (TabOffset(idx) + TabOffsetConstant) >= TabWidth(idx) Then titulo$ = Trim$(Left$(titulo$, Len(titulo$) - 1))
      Loop Until TabTextWidth + ancho_grafico + 2 * (TabOffset(idx) + TabOffsetConstant) < TabWidth(idx) Or TabTextWidth = 0 Or titulo$ = ""
      On Error GoTo 0
      alto_texto = FolderTabs(idx).TextHeight(titulo$)
      If ancho_grafico > 0 Then
	    Select Case PicturesPosition(idx)
		Case 0 ' Left
			xtitulo = L + TabOffset(idx) + TabOffsetConstant + ancho_grafico + (TabWidth(idx) - 2 * (TabOffset(idx) + TabOffsetConstant) - ancho_grafico - TabTextWidth) \ 2
			ytitulo = T + (OneTabHeight(idx) - num_lineas * alto_texto) \ 2 + (i - 1) * alto_texto
		Case 1 ' Right
			xtitulo = L + TabOffset(idx) + TabOffsetConstant + (TabWidth(idx) - 2 * (TabOffset(idx) + TabOffsetConstant) - ancho_grafico - TabTextWidth) \ 2
			ytitulo = T + (OneTabHeight(idx) - num_lineas * alto_texto) \ 2 + (i - 1) * alto_texto
		Case 2 ' Top
			xtitulo = L + (TabWidth(idx) - TabTextWidth) \ 2
			ytitulo = T + alto_grafico + TabOffsetConstant + (OneTabHeight(idx) - alto_grafico - TabOffsetConstant - num_lineas * alto_texto) \ 2 + (i - 1) * alto_texto
		Case 3 ' Bottom
			xtitulo = L + (TabWidth(idx) - TabTextWidth) \ 2
			ytitulo = T + (OneTabHeight(idx) - alto_grafico - TabOffsetConstant - num_lineas * alto_texto) \ 2 + (i - 1) * alto_texto
	    End Select
      Else
	xtitulo = L + (TabWidth(idx) - TabTextWidth) \ 2
	ytitulo = T + (OneTabHeight(idx) - num_lineas * alto_texto) \ 2 + (i - 1) * alto_texto
      End If
    
      FolderTabs(idx).CurrentX = xtitulo
      FolderTabs(idx).CurrentY = ytitulo
      
      If accel > 0 And accel_line = i Then
	FolderTabs(idx).Print Left$(titulo$, accel - 1);
	FolderTabs(idx).FontUnderline = True
	FolderTabs(idx).Print Mid$(titulo$, accel, 1);
	FolderTabs(idx).FontUnderline = False
	FolderTabs(idx).Print Mid$(titulo$, accel + 1);
      Else
	FolderTabs(idx).Print titulo$
      End If
  Next

  FolderTabs(idx).ForeColor = col
  FolderTabs(idx).FontBold = False

  SetScaleMode idx, oldscalemode

End Sub

' Draws each of the visible tabs on screen
Private Sub DrawTabs (idx As Integer)
    Dim i As Integer
    Dim a As Integer
    Dim quita As Integer
    Dim X As Integer
    Dim y As Integer
    Dim ancho As Integer
    Dim alto As Integer
    Dim alto2 As Integer
    Dim offset_tab As Integer
    Dim trocitoalto As Integer
    Dim max_verpos As Integer
    Dim vp As Integer
    Dim ic As Long
    Dim oldscalemode As Integer

  oldscalemode = GetScaleMode(idx)
  SetScaleMode idx, 3

  If LeftBorder(idx) And NumRows(idx) > 1 Then
    offset_tab = (NumRows(idx) - 1) * Abs(RowOffset(idx))
  Else
    offset_tab = 0
  End If
  FolderTabs(idx).Cls
  FolderBorder(idx).Cls

  ' Draws lines at folderborder and under tabs
  If NumRows(idx) > 1 Then
      ancho = Abs(RowOffset(idx))
      For i = 1 To NumRows(idx) - 1
	  X = Abs(RowOffset(idx)) * (i - 1) - 1
	  alto = FolderBorder(idx).Height - 1 - i * OneTabHeight(idx)
	  alto2 = FolderTabs(idx).Height - 4 - i * OneTabHeight(idx)
	  
	  If RowOffset(idx) <> 0 Then
	      ' black lines at border
	      If LeftBorder(idx) Then
		  FolderBorder(idx).Line (offset_tab - X - 2, alto)-Step(-ancho + 1, 0), 0' Horiz border
		  FolderBorder(idx).Line -Step(0, -alto - 1), 0' Vert border
		  FolderTabs(idx).Line (offset_tab - X - ancho - 1, FolderTabs(idx).Height)-Step(0, alto2 - FolderTabs(idx).Height), 0' cont Vert
	      Else
		  FolderBorder(idx).Line (X + 1, alto)-Step(ancho - 1, 0), 0' Horiz border
		  FolderBorder(idx).Line -Step(0, -alto - 1), 0      ' Vert border
		  FolderTabs(idx).Line (offset_tab + Folders(idx, 0).Width + X + ancho, FolderTabs(idx).Height)-(offset_tab + Folders(idx, 0).Width + X + ancho, alto2), 0' cont Vert
	      End If
	      
	      ' same with gray/white
	      If LeftBorder(idx) Then
		  FolderBorder(idx).Line (offset_tab - X - 2, alto - 1)-Step(-ancho + 2, 0), &H80000010
		  FolderBorder(idx).Line -Step(0, -alto), &H80000005
		  FolderTabs(idx).Line (offset_tab - (X + ancho), FolderTabs(idx).Height)-(offset_tab - (X + ancho), alto2), &H80000005
	      Else
		  FolderBorder(idx).Line (X, alto - 1)-Step(ancho - 1, 0), &H80000010
		  FolderBorder(idx).Line -Step(0, -alto), &H80000010
		  FolderTabs(idx).Line (offset_tab + Folders(idx, 0).Width + X + ancho - 1, FolderTabs(idx).Height)-(offset_tab + Folders(idx, 0).Width + X + ancho - 1, alto2), &H80000010
	      End If
	  End If

	  ' black page border line
	  FolderTabs(idx).Line (offset_tab + i * RowOffset(idx), alto2 + 1 + OneTabHeight(idx))-Step(0, -OneTabHeight(idx)), 0
	  FolderTabs(idx).Line -Step(1, 0), 0
	  FolderTabs(idx).Line -Step(1, 0), &H80000005
	  FolderTabs(idx).Line -Step(Folders(idx, 0).Width - 3, 0), 0
	  FolderTabs(idx).Line -Step(0, OneTabHeight(idx)), 0
	  ' gray/white page border line
	  FolderTabs(idx).Line (offset_tab + i * RowOffset(idx) + 1, alto2 + 1 + OneTabHeight(idx))-Step(0, -OneTabHeight(idx) + 1), &H80000005
	  FolderTabs(idx).Line -Step(Folders(idx, 0).Width - 3, 0), &H80000005
	  FolderTabs(idx).Line -Step(0, OneTabHeight(idx) - 1), &H80000010
      Next
  End If
  ' Draws the 3D line below first row of tabs
  If VisibleTabs(idx) > 1 Then
      FolderTabs(idx).Line (offset_tab + 1, FolderTabs(idx).Height - 3)-(offset_tab + Folders(idx, 0).Width, FolderTabs(idx).Height - 3), 0
      FolderTabs(idx).Line (offset_tab + 2, FolderTabs(idx).Height - 2)-(offset_tab + Folders(idx, 0).Width - 1, FolderTabs(idx).Height - 2), &H80000005
      FolderTabs(idx).Line (offset_tab + 3, FolderTabs(idx).Height - 1)-(offset_tab + Folders(idx, 0).Width - 2, FolderTabs(idx).Height - 1), &H80000005
  End If

  ' Draw lines down the left and right side in the first row
  If (NumTabs(idx) + 1) Mod VisibleTabs(idx) = 0 Then
    alto = 3  ' No empty tabs
  ElseIf RowOffset(idx) <> 0 Then
    alto = 3                    ' Empty Tabs and RowOffset<>0
  Else
    alto = OneTabHeight(idx) + 3 ' Empty Tabs and RowOffset=0
  End If
  FolderTabs(idx).Line (offset_tab, FolderTabs(idx).Height - alto)-(offset_tab, FolderTabs(idx).Height), 0
  FolderTabs(idx).Line (offset_tab + 1, FolderTabs(idx).Height - alto)-(offset_tab + 1, FolderTabs(idx).Height), &H80000005
  FolderTabs(idx).Line (offset_tab + 2, FolderTabs(idx).Height - 2)-(offset_tab + 2, FolderTabs(idx).Height), &H80000005
  
  If LeftBorder(idx) And CurrentTab(idx) + 1 > ((NumTabs(idx) + 1) \ VisibleTabs(idx)) * VisibleTabs(idx) Then
    alto = OneTabHeight(idx) + 3 ' Right border size if Partial row is current
  End If
  
  If LeftBorder(idx) And (CurrentTab(idx) + 1) Mod VisibleTabs(idx) <> 0 Then
    trocitoalto = 3
  Else
    trocitoalto = 0
  End If
  
  ' Panel little right corner
  FolderTabs(idx).Line (offset_tab + Folders(idx, 0).Width - 3, FolderTabs(idx).Height - 2)-(offset_tab + Folders(idx, 0).Width - 3, FolderTabs(idx).Height - trocitoalto), &H80000010
  FolderTabs(idx).Line (offset_tab + Folders(idx, 0).Width - 2, FolderTabs(idx).Height - 2)-(offset_tab + Folders(idx, 0).Width - 2, FolderTabs(idx).Height - trocitoalto), &H80000010
  FolderTabs(idx).Line (offset_tab + Folders(idx, 0).Width - 1, FolderTabs(idx).Height - 2)-(offset_tab + Folders(idx, 0).Width - 1, FolderTabs(idx).Height - trocitoalto), 0

  ' Draw each tab in order of depth
  max_verpos = NumTabs(idx) \ VisibleTabs(idx) + 1
  For vp = max_verpos To 1 Step -1
      For i = NumTabs(idx) To 0 Step -1
	If VerTabPos(idx, i) = vp Then DrawTab idx, i, HorTabPos(idx, i), vp, False
      Next i
  Next vp
  DrawTab idx, CurrentTab(idx), HorTabPos(idx, CurrentTab(idx)), VerTabPos(idx, CurrentTab(idx)), True

  ' Fills the corners with the forms (or container) color
  
  ' Fill the bottom corner
  If NumRows(idx) > 1 And RowOffset(idx) <> 0 Then
    i = ExtFloodFill(FolderBorder(idx).hDC, 0, (FolderBorder(idx).Height) - 1, FolderBorder(idx).BackColor, FLOODFILLSURFACE)
  End If
  ' Fill the top corners
  i = ExtFloodFill(FolderTabs(idx).hDC, 0, 0, FolderTabs(idx).BackColor, FLOODFILLSURFACE)
  i = ExtFloodFill(FolderTabs(idx).hDC, (FolderTabs(idx).Width) - 1, 0, FolderTabs(idx).BackColor, FLOODFILLSURFACE)
  ' Fill the little right corner of each Tab if it exists
  If TabOffset(idx) + BetweenTabs(idx) >= 0 Then
      For a = 1 To VisibleTabs(idx) - 1
	i = ExtFloodFill(FolderTabs(idx).hDC, offset_tab + (NumRows(idx) - 1) * RowOffset(idx) + a * (TabWidth(idx) + BetweenTabs(idx)) - (BetweenTabs(idx) \ 2), 0, FolderTabs(idx).BackColor, FLOODFILLSURFACE)
      Next
  End If
  
  SetScaleMode idx, oldscalemode

End Sub

Sub FolderClick (idx As Integer, button As Integer, X As Single, y As Single)
    Dim i As Integer
    i = FolderClickFn(idx, button, X, y)
End Sub

Function FolderClicked (idx As Integer, X As Single, y As Single) As Integer
Dim horpos As Integer
Dim verpos As Integer
Dim offs As Integer
Dim offset_tab As Integer
Dim oldscalemode As Integer

  oldscalemode = GetScaleMode(idx)
  SetScaleMode idx, 3
  
  If LeftBorder(idx) And RowOffset(idx) <> 0 And NumRows(idx) > 1 Then
    offset_tab = FolderBorder(idx).Width
  Else
    offset_tab = 0
  End If
  verpos = NumRows(idx) - (y \ OneTabHeight(idx)) - 1
  offs = verpos * RowOffset(idx)
  If X - offset_tab - offs > Folders(idx, 0).Width Or X - offset_tab - offs < 0 Then
    FolderClicked = -1
    SetScaleMode idx, oldscalemode
    Exit Function
  End If
  verpos = (verpos + (CurrentTab(idx) \ VisibleTabs(idx) + 1)) Mod NumRows(idx) - 1
  If verpos = -1 Then verpos = NumRows(idx) - 1
  horpos = (X - offset_tab - offs) \ ((FolderTabs(idx).Width - Abs(RowOffset(idx)) * (NumRows(idx) - 1)) \ VisibleTabs(idx))
  FolderClicked = (verpos * VisibleTabs(idx)) + horpos
  
  SetScaleMode idx, oldscalemode

End Function

' Jump to the folder tab that was clicked on
' This is called by the Tab picture box's MouseDown procedure
Function FolderClickFn (idx As Integer, button As Integer, X As Single, y As Single) As Integer
  Dim Folder As Integer
  Folder = FolderClicked(idx, X, y)
  If Folder = -1 Then Exit Function

  If Not TabEnabled(idx, Folder) Then
    FolderClickFn = -1
    Exit Function
  End If

  GotoFolder idx, Folder
  FolderClickFn = Folder

End Function

Sub FolderDisable (Index As Integer)
    Dim a As Integer
    FolderEnabled(Index) = False
    For a = 0 To NumTabs(Index)
	Folders(Index, a).Enabled = False
    Next
    FolderTabs(Index).Enabled = False
    FolderBorder(Index).Enabled = False
    ShowFolder Index
End Sub

Sub FolderEnable (Index As Integer)
    Dim a As Integer
    FolderEnabled(Index) = True
    For a = 0 To NumTabs(Index)
	Folders(Index, a).Enabled = True
    Next
    FolderTabs(Index).Enabled = True
    FolderBorder(Index).Enabled = True
    ShowFolder Index
End Sub

Function FolderHeight (idx As Integer) As Integer
Dim oldscalemode As Integer

  oldscalemode = GetScaleMode(idx)
  SetScaleMode idx, 3
    FolderHeight = FolderTabs(idx).Height + FolderBorder(idx).Height
  SetScaleMode idx, oldscalemode
End Function

Function FolderLeft (idx As Integer) As Integer
Dim oldscalemode As Integer

  oldscalemode = GetScaleMode(idx)
  SetScaleMode idx, 3
    FolderLeft = FolderTabs(idx).Left
  SetScaleMode idx, oldscalemode
End Function

Sub FolderMove (idx As Integer, X As Single, y As Single)
    Dim a As Integer
    Dim subleft As Integer
    Dim subtop As Integer
    Dim oldscalemode As Integer

  oldscalemode = GetScaleMode(idx)
  SetScaleMode idx, 3

    ' Enable the folder
    FolderEnabled(idx) = True
    For a = 0 To NumTabs(idx)
	Folders(idx, a).Enabled = True
	TabEnabled(idx, a) = True
    Next
    FolderTabs(idx).Enabled = True
    FolderBorder(idx).Enabled = True

    ' Move it
    subleft = FolderLeft(idx)
    subtop = FolderTop(idx)
    
    FolderTabs(idx).Move FolderTabs(idx).Left - subleft, FolderTabs(idx).Top - subtop
    FolderBorder(idx).Move FolderBorder(idx).Left - subleft, FolderBorder(idx).Top - subtop
    For a = 0 To NumTabs(idx)
	Folders(idx, a).Move Folders(idx, a).Left - subleft, Folders(idx, a).Top - subtop
    Next

    SetScaleMode idx, oldscalemode
    ShowFolder idx
End Sub

Function FolderTop (idx As Integer) As Integer
Dim oldscalemode As Integer

  oldscalemode = GetScaleMode(idx)
  SetScaleMode idx, 3
    FolderTop = FolderTabs(idx).Top
  SetScaleMode idx, oldscalemode
End Function

Function FolderWidth (idx As Integer) As Integer
Dim oldscalemode As Integer

  oldscalemode = GetScaleMode(idx)
  SetScaleMode idx, 3
    FolderWidth = FolderTabs(idx).Width
  SetScaleMode idx, oldscalemode
End Function

Private Function GetScaleMode (idx As Integer) As Integer
    GetScaleMode = Folders(idx, 0).Parent.ScaleMode
    On Error Resume Next
    GetScaleMode = FolderContainer(idx).ScaleMode
    On Error GoTo 0
End Function

' Make FolderNumber the active folder
Sub GotoFolder (idx As Integer, FolderNumber As Integer)
  If CurrentTab(idx) = FolderNumber Then Exit Sub
  If (FolderNumber >= 0) And (FolderNumber <= NumTabs(idx)) Then
    SetFixedControlsToTab idx, FolderNumber
    CurrentTab(idx) = FolderNumber
    ShowFolder idx
  End If
End Sub

Function GotoFolderByAccel (idx As Integer, ByVal keycode As Integer, ByVal shift As Integer) As Integer
    Dim i As Integer
    Dim TabNumber As Integer
    If shift <> 4 Or keycode = 0 Then Exit Function' No ALT-
    i = 0
    TabNumber = -1
    While i <= NumTabs(idx) And TabNumber = -1
	If TabAccel(idx, i) = UCase(keycode) Then TabNumber = i
	i = i + 1
    Wend
    If TabNumber <> -1 Then
	GotoFolderByAccel = 0
	If TabNumber <> CurrentTab(idx) And TabEnabled(idx, TabNumber) Then GotoFolder idx, TabNumber
    Else
	GotoFolderByAccel = keycode
    End If
End Function

' Calculate the column of a particular tab
Private Function HorTabPos (idx As Integer, TN As Integer) As Integer
  
  HorTabPos = TN Mod VisibleTabs(idx)

End Function

' Moves to the next folder
Sub NextFolder (idx As Integer)

  CurrentTab(idx) = ((CurrentTab(idx) + 1) Mod (NumTabs(idx) + 1))
  ShowFolder idx

End Sub

' Move to the previous folder
Sub PrevFolder (idx As Integer)
  
  If CurrentTab(idx) = 0 Then
    CurrentTab(idx) = NumTabs(idx)
  Else
    CurrentTab(idx) = CurrentTab(idx) - 1
  End If
  ShowFolder idx

End Sub

Function ReDefineFolders (idx As Integer, numacross As Integer, Style As Integer, RowOffs As Integer, PicPosition As Integer, GrayGph As Integer, LeftBdr As Integer, BwTabs As Integer) As Integer
Dim oldscalemode As Integer

  oldscalemode = GetScaleMode(idx)
  SetScaleMode idx, 3
    
    Folders(idx, CurrentTab(idx)).Visible = False
    FolderTabs(idx).Visible = False
    FolderBorder(idx).Visible = False
    Folders(idx, 0).Top = Folders(idx, 0).Top - (NumRows(idx) * OneTabHeight(idx) - FolderTabs(idx).TextHeight("X"))
    ReDefineFolders = DefineFolders(idx, numacross, Folders(idx, 0), (Folders(idx, 0).Tag), FolderTabs(idx), FolderBorder(idx), FolderContainer(idx), Style, RowOffs, PicPosition, GrayGph, LeftBdr, BwTabs)
  
  SetScaleMode idx, oldscalemode
End Function

Sub ResetFixedControls (idx As Integer)
    SetFixedControlsToTab idx, 0
End Sub

Sub SetFixedControl (idx As Integer, c As Control)
    Dim hay_error As Integer
    Dim n As Integer
    If NumFixedControls(idx) = MaxFixedControls Then Exit Sub
    hay_error = False
    On Error GoTo 1
    n = c.hWnd
    On Error GoTo 0
    If hay_error Then Exit Sub
    'If TypeOf c Is Label Then Exit Sub
    'If TypeOf c Is Shape Then Exit Sub
    'If TypeOf c Is Line Then Exit Sub
    'If TypeOf c Is Image Then Exit Sub
    NumFixedControls(idx) = NumFixedControls(idx) + 1
    Set FixedControls(idx, NumFixedControls(idx)) = c
    Exit Sub
1 :
    hay_error = True
    Resume Next
End Sub

Private Sub SetFixedControlsToTab (idx As Integer, FolderNumber As Integer)
    Dim a, ret, estado_enabled, HandleChild As Integer
    For a = 1 To NumFixedControls(idx)
	If Not TabEnabled(idx, CurrentTab(idx)) Then
	    Folders(idx, CurrentTab(idx)).Enabled = True
	End If
	estado_enabled = FixedControls(idx, a).Enabled
	If Not estado_enabled Then FixedControls(idx, a).Enabled = True
	'If TypeOf FixedControls(idx, a) Is ... Then
	'    FixedControls(idx, a).SetFocus
	'    HandleChild = getfocus()
	'    ret = setparent(HandleChild, Folders(idx, FolderNumber).hWnd)
	'Else
	    ret = setparent(FixedControls(idx, a).hWnd, Folders(idx, FolderNumber).hWnd)
	'End If
	If Not estado_enabled Then FixedControls(idx, a).Enabled = False
	If Not TabEnabled(idx, CurrentTab(idx)) Then
	    Folders(idx, CurrentTab(idx)).Enabled = False
	End If
    Next
End Sub

Private Sub SetScaleMode (idx As Integer, mode As Integer)
  Dim flag As Integer
  Dim n As Integer
  flag = False
  On Error GoTo hay_error ' check if exists a container
  n = FolderContainer(idx).Left
  On Error GoTo 0
  If flag Then
    Folders(idx, 0).Parent.ScaleMode = mode
  Else
    On Error GoTo hay_error ' check if the container has an ScaleMode prop.
    FolderContainer(idx).ScaleMode = mode
    On Error GoTo 0
    If flag Then
	MsgBox "Folder " & Format$(idx) & " Container doesn't have an ScaleMode property.", 16, "ERROR"
	End
    End If
  End If
  Exit Sub
hay_error:
  flag = True
  Resume Next
End Sub

' Makes the current folder visible
' Then updates the tabs
Private Sub ShowFolder (idx As Integer)
Dim i As Integer

  For i = 0 To NumTabs(idx)
    Folders(idx, i).Enabled = True
  Next i
  DrawTabs idx
  For i = 0 To NumTabs(idx)
    Folders(idx, i).Enabled = TabEnabled(idx, i) And FolderEnabled(idx)
  Next i
  ' No flickering (or less) if put this here
  Folders(idx, CurrentTab(idx)).Visible = True
  For i = 0 To NumTabs(idx)
    Folders(idx, i).Visible = (i = CurrentTab(idx))
  Next i

End Sub

Sub TabDisable (idx As Integer, TabNumber As Integer)
    TabEnabled(idx, TabNumber) = False
    ShowFolder idx
End Sub

Sub TabEnable (idx As Integer, TabNumber As Integer)
    TabEnabled(idx, TabNumber) = True
    ShowFolder idx
End Sub

' Moves the whole tab thingy to the top left corner of the
'   form, and then shrinks the form to fit perfectly.
Sub TightenForm (idx As Integer, BelowSpace As Integer, noborders As Integer)
Dim SB As Long
Dim CH As Integer
Dim MH As Integer
Dim OY As Long, OX As Long
Dim leftinit As Integer

  SB = 0
  On Error GoTo EsForm
  CH = (FolderContainer(idx).Width <> 0)
  On Error GoTo 0
  GoTo Continua
EsForm:
  SB = 1
  Resume Next
Continua:
  If SB = 0 Then Exit Sub
  
Dim oldscalemode As Integer

  oldscalemode = GetScaleMode(idx)
  SetScaleMode idx, 3

  If noborders Then
    leftinit = -3
    If BelowSpace = 0 Then BelowSpace = -2
  Else
    leftinit = 0
  End If
  FolderBorder(idx).Left = FolderBorder(idx).Left - FolderTabs(idx).Left + leftinit
  For CH = 0 To NumTabs(idx)
    Folders(idx, CH).Left = Folders(idx, CH).Left - FolderTabs(idx).Left + leftinit
  Next CH
  FolderTabs(idx).Left = leftinit
  
  ' Find the height of the caption
  CH = getsystemmetrics(4)

  ' Is there a menu?
  If GetMenu(CInt(FolderTabs(idx).Parent.hWnd)) <> 0 Then
    MH = getsystemmetrics(15)  ' Get the menu's height
    Select Case FolderTabs(idx).Parent.BorderStyle
      Case 2    ' Sizable
	SB = 2 * getsystemmetrics(32)
      Case Else ' Little known fact: with a menu, your window's
		'   borders can only be sizable or single.
	SB = 2 * getsystemmetrics(5)
    End Select
    OY = -1
  Else
    Select Case FolderTabs(idx).Parent.BorderStyle
      Case 0
	SB = 0
	CH = 0
      Case 1
	SB = 2 * getsystemmetrics(5)
	OY = -1
      Case 2
	SB = 2 * getsystemmetrics(32)
	OY = -1
      Case 3
	SB = 2 * getsystemmetrics(7)
	OX = 2
	OY = 1
    End Select
  
  End If

  FolderTabs(idx).Parent.Height = Folders(idx, 0).Top + Folders(idx, 0).Height + SB + CH + MH + OY + BelowSpace
  FolderTabs(idx).Parent.Width = Folders(idx, 0).Width + FolderBorder(idx).Width + SB + OX + leftinit * 2
  
  DrawTabs idx

  SetScaleMode idx, oldscalemode
End Sub

' Calculate the row of a particular tab
Private Function VerTabPos (idx As Integer, TN As Integer) As Integer
Dim i As Integer
Dim J As Integer

  i = TN \ VisibleTabs(idx) + 1
  J = CurrentTab(idx) \ VisibleTabs(idx) + 1
  If i >= J Then
    VerTabPos = i - J + 1
  ElseIf J > i Then
    VerTabPos = NumRows(idx) - (J - i) + 1
  End If

End Function

