Type RECT
    left As Integer
    top As Integer
    right As Integer
    bottom As Integer
End Type

Type BITMAP '14 bytes
    bmType As Integer
    bmWidth As Integer
    bmHeight As Integer
    bmWidthBytes As Integer
    bmPlanes As String * 1
    bmBitsPixel As String * 1
    bmBits As Long
End Type

' Message structure
Type POINTAPI
    X As Integer
    Y As Integer
End Type

Declare Function BitBlt Lib "GDI" (ByVal hDestDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal hSrcDC As Integer, ByVal XSrc As Integer, ByVal YSrc As Integer, ByVal dwRop As Long) As Integer
Declare Function CreateBitmap Lib "GDI" (ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal nPlanes As Integer, ByVal nBitCount As Integer, ByVal lpBits As Any) As Integer
Declare Function CreateCompatibleBitmap Lib "GDI" (ByVal hDC As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer) As Integer
Declare Function CreateCompatibleDc Lib "GDI" (ByVal hDC As Integer) As Integer
Declare Function CreatePatternBrush Lib "GDI" (ByVal hBitmap As Integer) As Integer
Declare Function CreateSolidBrush Lib "GDI" (ByVal crColor As Long) As Integer
Declare Function DeleteDc Lib "GDI" (ByVal hDC As Integer) As Integer
Declare Function DeleteObject Lib "GDI" (ByVal hObject As Integer) As Integer
Declare Function DPtoLP Lib "GDI" (ByVal hDC As Integer, lpPoints As POINTAPI, ByVal nCount As Integer) As Integer
Declare Sub DrawFocusRect Lib "User" (ByVal hDC As Integer, lpRect As RECT)
Declare Function FillRect Lib "User" (ByVal hDC As Integer, lpRect As RECT, ByVal hBrush As Integer) As Integer
Declare Sub FreeLibrary Lib "Kernel" (ByVal hLibModule As Integer)
Declare Function GetDC Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function GetDeviceCaps Lib "GDI" (ByVal hDC As Integer, ByVal nIndex As Integer) As Integer
Declare Function GetMapMode Lib "GDI" (ByVal hDC As Integer) As Integer
Declare Function GetPixel Lib "GDI" (ByVal hDC As Integer, ByVal X As Integer, ByVal Y As Integer) As Long
Declare Function APIGetObject Lib "GDI" Alias "GetObject" (ByVal hObject As Integer, ByVal nCount As Integer, lpObject As Any) As Integer
Declare Sub InvertRect Lib "User" (ByVal hDC As Integer, lpRect As RECT)
Declare Function LineTo Lib "GDI" (ByVal hDC As Integer, ByVal X As Integer, ByVal Y As Integer) As Integer
Declare Function LoadBitmap Lib "User" (ByVal hInstance As Integer, ByVal lpBitmapName As Any) As Integer
Declare Function LoadLibrary Lib "Kernel" (ByVal lpLibFileName As String) As Integer
Declare Function MoveTo Lib "GDI" (ByVal hDC As Integer, ByVal X As Integer, ByVal Y As Integer) As Long
Declare Function Rectangle Lib "GDI" (ByVal hDC As Integer, ByVal X1 As Integer, ByVal Y1 As Integer, ByVal X2 As Integer, ByVal Y2 As Integer) As Integer
Declare Function SelectObject Lib "GDI" (ByVal hDC As Integer, ByVal hObject As Integer) As Integer
Declare Function SetBkColor Lib "GDI" (ByVal hDC As Integer, ByVal crColor As Long) As Long
Declare Function SetMapMode Lib "GDI" (ByVal hDC As Integer, ByVal nMapMode As Integer) As Integer
Declare Function SetPixel Lib "GDI" (ByVal hDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal crColor As Long) As Long
Declare Function SetStretchBltMode Lib "GDI" (ByVal hDC As Integer, ByVal nStretchMode As Integer) As Integer
Declare Function ScrollDC Lib "User" (ByVal hDC As Integer, ByVal dx As Integer, ByVal dy As Integer, lprcScroll As RECT, lprcClip As RECT, ByVal hRgnUpdate As Integer, lprcUpdate As RECT) As Integer
Declare Function StretchBlt Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal nWidth%, ByVal nHeight%, ByVal hSrcDC%, ByVal XSrc%, ByVal YSrc%, ByVal nSrcWidth%, ByVal nSrcHeight%, ByVal dwRop&) As Integer

Global Const NOTSRCCOPY = &H330008
Global Const NOTSRCERASE = &H1100A6
Global Const SRCAND = &H8800C6
Global Const SRCCOPY = &HCC0020
Global Const SRCERASE = &H440328
Global Const SRCINVERT = &H660046
Global Const SRCPAINT = &HEE0086
Global Const MERGECOPY = &HC000CA
Global Const MERGEPAINT = &HBB0226
Global Const PATCOPY = &HF00021
Global Const PATINVERT = &H5A0049
Global Const PATPAINT = &HFB0A09

Global Const BITSPIXEL = 12

Sub LoadTransparantBitmap (ByVal hDC As Integer, ByVal hBitmap As Integer, ByVal lColor As Long, ByVal X As Integer, ByVal Y As Integer)

Dim bm As BITMAP
Dim hDcBmp As Integer
Dim rSiz As POINTAPI
Dim rOrg As POINTAPI
Dim rLoc As POINTAPI
Dim hOldObj1 As Integer
Dim hOldObj2 As Integer
Dim hOldObj3 As Integer

Dim hDcTmp As Integer
Dim hBitmapTmp As Integer
Dim hBitmap1 As Integer
Dim hBmpWrk As Integer
Dim hDC1 As Integer
Dim hDcWrk As Integer

    If hBitmap = 0 Then
	LoadTranspBMP = False
	Exit Sub
    End If

    iRes% = APIGetObject(hBitmap, Len(bm), bm)
    rSiz.X = bm.bmWidth
    rSiz.Y = bm.bmHeight
    iRes% = DPtoLP(hDC, rSiz, 1)
    rOrg.X = 0
    rOrg.Y = 0
    iRes% = DPtoLP(hDC, rOrg, 1)
    rLoc.X = X
    rLoc.Y = Y
    iRes% = DPtoLP(hDC, rLoc, 1)

    hDcTmp = CreateCompatibleDc(hDC)
    hBitmapTmp = CreateCompatibleBitmap(hDC, bm.bmWidth, bm.bmHeight)
    hOldObj1 = SelectObject(hDcTmp, hBitmapTmp)

    hDcBmp = CreateCompatibleDc(hDC)
    hOldObj2 = SelectObject(hDcBmp, hBitmap)

    iRes% = BitBlt(hDcTmp, 0, 0, bm.bmWidth, bm.bmHeight, hDcBmp, 0, 0, SRCCOPY)

    iRes% = SelectObject(hDcBmp, hOldObj2)
    iRes% = DeleteDc(hDcBmp)
    iRes% = SelectObject(hDcTmp, hOldObj1)
    iRes% = DeleteDc(hDcTmp)

    hBitmap = hBitmapTmp

    hDcBmp = CreateCompatibleDc(hDC)
    iRes% = SetMapMode(hDcBmp, GetMapMode(hDC))
    hOldObj2 = SelectObject(hDcBmp, hBitmap)

    If lColor >= 0 And lColor <= 15 Then lColor = QBColor(lColor)
    lRes& = SetBkColor(hDcBmp, lColor)

    hBitmap1 = CreateBitmap(bm.bmWidth, bm.bmHeight, 1, 1, ByVal 0&)
    hDC1 = CreateCompatibleDc(hDC)
    hOldObj1 = SelectObject(hDC1, hBitmap1)
    iRes% = BitBlt(hDC1, 0, 0, bm.bmWidth, bm.bmHeight, hDcBmp, 0, 0, SRCCOPY)

    iRes% = SelectObject(hDcBmp, hOldObj2)
    iRes% = DeleteDc(hDcBmp)

    hDcBmp = CreateCompatibleDc(hDC)
    iRes% = SetMapMode(hDcBmp, GetMapMode(hDC))
    hOldObj2 = SelectObject(hDcBmp, hBitmap)

    hDcWrk = CreateCompatibleDc(hDC)
    hBmpWrk = CreateCompatibleBitmap(hDC, bm.bmWidth, bm.bmHeight)
    hOldObj3 = SelectObject(hDcWrk, hBmpWrk)
    iRes% = BitBlt(hDcWrk, 0, 0, rSiz.X, rSiz.Y, hDC, rLoc.X, rLoc.Y, SRCCOPY)

    iRes% = BitBlt(hDcWrk, 0, 0, rSiz.X, rSiz.Y, hDC1, rOrg.X, rOrg.Y, MERGEPAINT)

    iRes% = BitBlt(hDcBmp, 0, 0, bm.bmWidth, bm.bmHeight, hDC1, 0, 0, SRCPAINT)

    iRes% = BitBlt(hDcWrk, 0, 0, rSiz.X, rSiz.Y, hDcBmp, 0, 0, SRCAND)
    iRes% = BitBlt(hDC, rLoc.X, rLoc.Y, rSiz.X, rSiz.Y, hDcWrk, 0, 0, SRCCOPY)

    iRes% = SelectObject(hDcWrk, hOldObj3)
    iRes% = DeleteDc(hDcWrk)
    iRes% = SelectObject(hDcBmp, hOldObj1)
    iRes% = DeleteDc(hDC1)
    iRes% = DeleteObject(hBitmap1)
    iRes% = DeleteObject(hBmpWrk)
	
    iRes% = SelectObject(hDcBmp, hOldObj2)
    iRes% = DeleteDc(hDcBmp)
		
    iRes% = DeleteObject(hBitmap)
	
End Sub

Function Minimum (X As Integer, Y As Integer)
    If X < Y Then Minimum = X Else Minimum = Y
End Function

Sub MoveTransparantBitmap (ByVal hDC As Integer, ByVal hBmpBg As Integer, ByVal iTop As Integer, ByVal iLeft As Integer, ByVal hBitmap As Integer, ByVal lColor As Long, iOldX As Integer, iOldY As Integer, iNewX As Integer, iNewY As Integer)

Dim bm As BITMAP
Dim rSiz As POINTAPI
Dim rLoc As POINTAPI
Dim rOrg As POINTAPI
Dim rNew As POINTAPI
Dim iXDelta As Integer
Dim iYDelta As Integer

    If hBmpBg <> 0 Then
	iRes% = APIGetObject(hBitmap, Len(bm), bm)
	rSiz.X = bm.bmWidth
	rSiz.Y = bm.bmHeight
	iRes% = DPtoLP(hDC, rSiz, 1)

	rLoc.X = iOldX
	rLoc.Y = iOldY
	iRes% = DPtoLP(hDC, rLoc, 1)

	rNew.X = iNewX
	rNew.Y = iNewY
	iRes% = DPtoLP(hDC, rNew, 1)

	iXDelta = Abs(rNew.X - rLoc.X)
	iYDelta = Abs(rNew.Y - rLoc.Y)
		
	If (iXDelta <= rSiz.X And iYDelta <= rSiz.Y) Then
	    Dim hDcMem As Integer
	    Dim hNewBitmap As Integer
	    Dim X As Integer, Y As Integer
	    Dim abs1 As Integer, abs2 As Integer
	    Dim bkOrg As POINTAPI, newOrg As POINTAPI

	    newOrg.X = Minimum(iNewX, iOldX)
	    X = Minimum(iNewX, iOldX)
	    newOrg.Y = Minimum(iNewY, iOldY)
	    Y = Minimum(iNewY, iOldY)
	    iRes% = DPtoLP(hDC, newOrg, 1)

	    bkOrg.X = X - iLeft
	    bkOrg.Y = Y - iTop
	    iRes% = DPtoLP(hDC, bkOrg, 1)

	    iXDelta = iXDelta + rSiz.X
	    iYDelta = iYDelta + rSiz.Y

	    hDcMem = CreateCompatibleDc(hDC)
	    hNewBitmap = CreateCompatibleBitmap(hDC, iXDelta, iYDelta)
	    iRes% = SelectObject(hDcMem, hNewBitmap)

	    hDCBg = CreateCompatibleDc(hDC)
	    iRes% = SelectObject(hDCBg, hBmpBg)

	    iRes% = BitBlt(hDcMem, 0, 0, iXDelta, iYDelta, hDCBg, bkOrg.X, bkOrg.Y, SRCCOPY)
	    LoadTransparantBitmap hDcMem, hBitmap, lColor, Abs(X - iNewX), Abs(Y - iNewY)
	    iRes% = BitBlt(hDC, newOrg.X, newOrg.Y, iXDelta, iYDelta, hDcMem, 0, 0, SRCCOPY)

	    iRes% = DeleteDc(hDcMem)
	    iRes% = DeleteObject(hNewBitmap)
	    iRes% = DeleteDc(hDCBg)
	    Exit Sub
	End If

	rOrg.X = iOldX - iLeft
	rOrg.Y = iOldY - iTop
	iRes% = DPtoLP(hDC, rOrg, 1)
	    
	hDCBg = CreateCompatibleDc(hDC)
	iRes% = SelectObject(hDCBg, hBmpBg)
	iRes% = BitBlt(hDC, rLoc.X, rLoc.Y, rSiz.X, rSiz.Y, hDCBg, rOrg.X, rOrg.Y, SRCCOPY)
	iRes% = DeleteDc(hDCBg)
	
	LoadTransparantBitmap hDC, hBitmap, lColor, iNewX, iNewY
    End If
End Sub

