/*****************************************************************************

					Modellib Header File
					Copyright (c) 1994
					Visual Tech Co.
					P.O.Box 8735
					Fort Wayne, IN 46898-8735

*****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

typedef DWORD HBODY;
typedef DWORD HFACE;
typedef DWORD HEDGE;
typedef DWORD HVERT;

#define	BODYHDL	HBODY WINAPI
#define	EDGEHDL	HEDGE WINAPI
#define	FACEHDL	HFACE WINAPI
#define	VERTHDL HVERT WINAPI

typedef	HBODY FAR	*LPHBODY;

typedef struct {
	VECTOR3	p;				// start point of the line.
    VECTOR3	v;				// segment vector of the line.
} LINE, FAR *LPLINE;

typedef struct {
    VECTOR3	n;				// unified plane normal.
    REAL	e;				// negative distance from the origin/
} PLANE, FAR *LPPLANE;

/* --------------------   REAL EXTENTS  --------------------   */

typedef struct {				/* bounding box */
	VECTOR3	pmin;
	VECTOR3	pmax;
} BBOX, FAR *LPBBOX;

/* ----------------------  BASE  -------------------- */

typedef struct {
	VECTOR	orgin;
	VECTOR	dir;
} AXLE, FAR *LPAXLE;

typedef struct {
	VECTOR3	origin;
	VECTOR3	xvect;
	VECTOR3 zvect;
} BASE, FAR *LPBASE;

/* ======================================================================== */

#define      DEPTH            1
#define      THROUGH          2
#define      ALL_WAY          3

BODYHDL	NewNose (LPPOINT3D p, REAL r1, REAL r2, WORD n);
BODYHDL	NewReducer (LPPOINT3D p, REAL r1, REAL r1i, REAL r2, REAL r2i, WORD n);

BODYHDL	NewBlock(REAL l, REAL w, REAL h);
BODYHDL	NewPyramid(REAL bl, REAL bw, REAL tx, REAL ty, REAL h);
BODYHDL	NewDome(REAL r, REAL h, WORD n);
BODYHDL	NewBall(REAL r);
BODYHDL	NewSphere(REAL r, WORD n);
BODYHDL	NewTorus(REAL r1, REAL r2, WORD n1, WORD n2);
BODYHDL	NewExtrusion(LPPOINT3D q1, LPPOINT3D q2, WORD m, REAL sa);
BODYHDL	NewRevolution(LPPOINT3D p, WORD m, WORD n, REAL a);
BODYHDL	NewSweep(LPPOINT3D prof, WORD m, LPPOINT3D path, VECTOR scale, WORD n, BOOL open);


BODYHDL	NewCylinder (REAL r, REAL h, WORD n);
BODYHDL	NewCone (REAL r, REAL h, WORD n);
BODYHDL	NewTube (REAL r, REAL t, REAL h, WORD n);
BODYHDL	NewHexahedron (REAL bl, REAL bw, REAL tl, REAL tw, REAL tx, REAL ty, REAL h);
BODYHDL	NewFrustum (REAL bl, REAL bw, REAL tl, REAL tw, REAL h);
BODYHDL	NewBox (REAL l, REAL w, REAL h);
BODYHDL	NewCube (LPPOINT3D p1, LPPOINT3D p2);
BODYHDL	NewPrismoid (LPPOINT3D vertex, WORD n, REAL scale, REAL dx, REAL dy, REAL dz);

BOOLEAN	BodyWireframe (HDC hdc, HBODY hbody);
BOOLEAN	BodyFacets (HDC hdc, HBODY hbody);
BOOLEAN	BodyShade (HDC hdc, HBODY hbody);

FACEHDL	PickBodyFace (HBODY hbody, LPPOINT3D p);
VERTHDL	PickBodyVert (HBODY hbody, LPPOINT3D p);
EDGEHDL	PickBodyEdge (HBODY hbody, LPPOINT3D p);

BODYHDL	UniteBody (HBODY a, HBODY b);
BODYHDL	SubtractBody (HBODY a, HBODY b);
BODYHDL	IntersectBody (HBODY a, HBODY b);
BODYHDL	SectionBody (HBODY s, LPPLANE pl);

BODYHDL	DrillBody (HBODY hb, LPLINE axis, REAL r, WORD depth);
BODYHDL	MortiseBody (HBODY hb, LPBASE base, REAL w, REAL h, WORD depth);
BODYHDL	PunchBody (HBODY hb, LPPOINT3D p, WORD m, VECTOR v, REAL h, REAL sa, WORD depth);
SGLWORD	SplitBody (HBODY hb, LPPLANE pl, LPHBODY body);
BODYHDL	ChamferBodyFace (HBODY hb, HFACE hf, REAL depth);
BODYHDL	ChamferBodyEdge (HBODY hb, HEDGE he, REAL depth);
BODYHDL	ChamferBodyVert (HBODY hb, HVERT hv, REAL depth);
BODYHDL	SliceBody (HBODY hb, LPPLANE pl);

BODYHDL	CutThroughBody (HBODY hb, LPPLANE pl, LPPOINT3D where);
VOIDED	SeparateBodyShells (HBODY hb);

BOOLEAN	FreeBody (HBODY hbody);
VOIDED	TranslateBody (HBODY hbody, REAL x, REAL y, REAL z);
VOIDED	RotateBody (HBODY hbody, LPLINE axis, REAL angle);
VOIDED	CleanupMemory (void);

#ifdef __cplusplus
}
#endif
