/****************************************************************************
 *                                                                          *
 *  Projeto:  Windows Inspector Programa Exemplo                            *
 *                                                                          *
 *  Modulo :  WsptExem.C                                                    *
 *                                                                          *
 *  Autor  :  Noriel Chang Reissig                                          *
 *                                                                          *
 *  Criacao: 15/04/93                                                       *
 *  Revisao: 23/05/93                                                       *
 *  Modific: 23/05/93                                                       *
 *                                                                          *
 ****************************************************************************

 Obs.:
      Este programa demonstra a utilizacao da biblioteca de funcoes INSPECTx.LIB,
      bem como a utilizacao da ferramenta de debug Winspector.

*/

#include  <windows.h>

#include  "Winspect.h"



long FAR PASCAL WindowProc( HWND, WORD, WORD, LONG);
char szAppName[]="Using Winspector";

#pragma argsused
int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{
    HWND        hwnd;
    MSG         msg;
    WNDCLASS    wndclass;


    if (!hPrevInstance)
    {
       wndclass.style         = CS_HREDRAW | CS_VREDRAW;
       wndclass.lpfnWndProc   = WindowProc;
       wndclass.cbClsExtra    = 0;
       wndclass.cbWndExtra    = 0;
       wndclass.hInstance     = hInstance;
       wndclass.hIcon         = LoadIcon( NULL, IDI_APPLICATION);
       wndclass.hCursor       = LoadCursor( NULL, IDC_ARROW);
       wndclass.hbrBackground = GetStockObject( WHITE_BRUSH);
       wndclass.lpszMenuName  = NULL;
       wndclass.lpszClassName = szAppName;

       RegisterClass( &wndclass);
    }

    hwnd = CreateWindow( szAppName,                     // Window class name
                         "Using Winspector v1.0",       // Window caption
                         WS_OVERLAPPEDWINDOW,           // Window style
                         CW_USEDEFAULT,                 // Initial x position
                         CW_USEDEFAULT,                 // Initial y position
                         CW_USEDEFAULT,                 // Initial x size
                         CW_USEDEFAULT,                 // Initial y size
                         NULL,                          // Parent window handle
                         NULL,                          // Window menu handle
                         hInstance,                     // Program instance handle
                         NULL);                         // Creation parameters

    ShowWindow( hwnd, nCmdShow);
    UpdateWindow( hwnd);

    StartWinspector();              // Chama Winspector
    WinspectorAutoSave( TRUE);      // Liga o autosave

    while( GetMessage( &msg, NULL, 0, 0))
    {
       TranslateMessage( &msg);
       DispatchMessage( &msg);
    }

    CloseWinspector();              // Fecha o Winspector

    return( msg.wParam);
}





long FAR PASCAL WindowProc( HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
    char    szBuffer[256] = "While pressing keys look at the Winspector's window";
    HDC         hdc;
    PAINTSTRUCT  ps;
    RECT         rect;
    static BOOL  liga = TRUE;

    switch( message)
    {
       case WM_PAINT:

            hdc = BeginPaint( hwnd, &ps);

            GetClientRect( hwnd, &rect);

            DrawText( hdc, szBuffer, -1, &rect,
                      DT_SINGLELINE | DT_CENTER | DT_VCENTER);

            EndPaint( hwnd, &ps);

            TellWinspector( "Wsptexem: WM_PAINT received");
            return( 0);

       case WM_RBUTTONDOWN:
            liga = !liga;
            WinspectorAutoSave( liga);
            break;

       case WM_SETFOCUS:
            TellWinspector( "Wsptexem: received system FOCUS");
            break;

       case WM_KILLFOCUS:
            TellWinspector( "Wsptexem: loosing system FOCUS");
            break;

       case WM_SIZE:
            TellWinspector(    " wParam = Type           lParam = Height-Width");
            TellWinspectorFmt( "WM_SIZE: wParam = %04Xh  lParam = %04d-%04d", wParam,
                                           HIWORD( lParam), LOWORD( lParam));
            break;

       case WM_KEYDOWN:
            switch( wParam)
            {
               case VK_HOME:
                    TellWinspector( "WsptExem:  HOME key");
                    break;

               case VK_END:
                    {
                       char *szStr = "Tecla END";

                       TellWinspectorFmt( "WsptExem:  %s", szStr);
                       break;
                    }

               case VK_PRIOR:
                    TellWinspector( "WsptExem:  PAGE UP key");
                    break;

               case VK_NEXT:
                    TellWinspector( "WsptExem:  PAGE DOWN key");
                    break;

               case VK_UP:
                    TellWinspector( "WsptExem:  UP key");
                    break;

               case VK_DOWN:
                    TellWinspector( "WsptExem:  DOWN key");
                    break;

               case VK_LEFT:
                    TellWinspector( "WsptExem:  LEFT key");
                    break;

               case VK_RIGHT:
                    TellWinspector( "WsptExem:  RIGHT key");
                    break;

               case VK_INSERT:
                    TellWinspector( "WsptExem:  INSERT key");
                    break;

               case VK_DELETE:
                    TellWinspector( "WsptExem:  DELETE key");
                    break;

               default:
                    TellWinspector( "Normal key pressed");
                    break;
            }
            return(0);

       case WM_DESTROY:
            PostQuitMessage( 0);
            return( 0);
    }


    return( DefWindowProc( hwnd, message, wParam, lParam));
}
