Option Explicit

' for the ini file stuff
Declare Function GetPrivateProfileInt% Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal nDefault%, ByVal lpFileName$)
Declare Function GetPrivateProfileString% Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal lpDefault$, ByVal lpReturnedString$, ByVal nSize%, ByVal lpFileName$)


' status function
Const DICT_STATUS_FATAL = 1
Const DICT_STATUS_MESSAGE = 2
Const DICT_STATUS_PROGRESS = 3

' status function can return one of these values
Const DICT_STATUS_RETURN_NONE = 0



'
' Data Access constants
'

' Option argument values (CreateDynaset, etc)
Global Const DB_DENYWRITE = &H1
Global Const DB_DENYREAD = &H2
Global Const DB_READONLY = &H4
Global Const DB_APPENDONLY = &H8
Global Const DB_INCONSISTENT = &H10
Global Const DB_CONSISTENT = &H20
Global Const DB_SQLPASSTHROUGH = &H40

' SetDataAccessOption
Global Const DB_OPTIONINIPATH = 1

' Field Attributes
Global Const DB_FIXEDFIELD = &H1
Global Const DB_VARIABLEFIELD = &H2
Global Const DB_AUTOINCRFIELD = &H10
Global Const DB_UPDATABLEFIELD = &H20

' Field Data Types
Global Const DB_BOOLEAN = 1
Global Const DB_BYTE = 2
Global Const DB_INTEGER = 3
Global Const DB_LONG = 4
Global Const DB_CURRENCY = 5
Global Const DB_SINGLE = 6
Global Const DB_DOUBLE = 7
Global Const DB_DATE = 8
Global Const DB_TEXT = 10
Global Const DB_LONGBINARY = 11
Global Const DB_MEMO = 12

' TableDef Attributes
Global Const DB_ATTACHEXCLUSIVE = &H10000
Global Const DB_ATTACHSAVEPWD = &H20000
Global Const DB_SYSTEMOBJECT = &H80000002
Global Const DB_ATTACHEDTABLE = &H40000000
Global Const DB_ATTACHEDODBC = &H20000000

' ListTables TableType
Global Const DB_TABLE = 1
Global Const DB_QUERYDEF = 5

' ListTables Attributes (for QueryDefs)
Global Const DB_QACTION = &HF0
Global Const DB_QCROSSTAB = &H10
Global Const DB_QDELETE = &H20
Global Const DB_QUPDATE = &H30
Global Const DB_QAPPEND = &H40
Global Const DB_QMAKETABLE = &H50

' ListIndexes IndexAttributes values
Global Const DB_UNIQUE = 1
Global Const DB_PRIMARY = 2
Global Const DB_PROHIBITNULL = 4
Global Const DB_IGNORENULL = 8
' ListIndexes FieldAttributes value
Global Const DB_DESCENDING = 1  'For each field in Index

' CreateDatabase and CompactDatabase Language constants
Global Const DB_LANG_GENERAL = ";LANGID=0x0809;CP=1252;COUNTRY=0"
Global Const DB_LANG_SPANISH = ";LANGID=0x040A;CP=1252;COUNTRY=0"
Global Const DB_LANG_DUTCH = ";LANGID=0x0413;CP=1252;COUNTRY=0"
Global Const DB_LANG_SWEDFIN = ";LANGID=0x040C;CP=1252;COUNTRY=0"   'VB3 and Access 1.1 Databases
Global Const DB_LANG_NORWDAN = ";LANGID=0x0414;CP=1252;COUNTRY=0"   'VB3 and Access 1.1 Databases
Global Const DB_LANG_ICELANDIC = ";LANGID=0x040F;CP=1252;COUNTRY=0" 'VB3 and Access 1.1 Databases
Global Const DB_LANG_NORDIC = ";LANGID=0x041D;CP=1252;COUNTRY=0"    'Access 1.0 Databases only

' CreateDatabase and CompactDatabase options
Global Const DB_VERSION10 = 1        ' Microsoft Access Version 1.0
Global Const DB_ENCRYPT = 2          ' Make database encrypted.
Global Const DB_DECRYPT = 4          ' Decrypt database while compacting.

'Collating order values
Global Const DB_SORTGENERAL = 256    ' Sort by EFGPI rules (English, French, German,Portuguese, Italian)
Global Const DB_SORTSPANISH = 258    ' Sort by Spanish rules
Global Const DB_SORTDUTCH = 259      ' Sort by Dutch rules
Global Const DB_SORTSWEDFIN = 260    ' Sort by Swedish, Finnish rules
Global Const DB_SORTNORWDAN = 261    ' Sort by Norwegian, Danish rules
Global Const DB_SORTICELANDIC = 262  ' Sort by Icelandic rules
Global Const DB_SORTPDXINTL = 4096   ' Sort by Paradox international rules
Global Const DB_SORTPDXSWE = 4097    ' Sort by Paradox Swedish, Finnish rules
Global Const DB_SORTPDXNOR = 4098    ' Sort by Paradox Norwegian, Danish rules
Global Const DB_SORTUNDEFINED = -1   ' Sort rules are undefined or unknown

Function dictCreate (ByVal cIniFile As String, ByVal cNewDBName As String) As Integer
    Dim i               As Integer
    Dim j               As Integer
    Dim cDBName         As String
    Dim cLang           As String
    Dim ret             As Integer
    Dim db              As database
    Dim nTables         As Integer
    Dim cQDefName       As String
    Dim nQDefs          As Integer
    Dim nFields         As Integer
    Dim nIndexes        As Integer
    Dim lAttached       As Integer
    Dim cConnect        As String
    Dim cSource         As String
    Dim cBuffer         As String
    Dim cIdxFields      As String
    
    Dim tbd()           As New tabledef
    Dim idx()           As New index
    Dim fld()           As New field
    Dim qd()            As querydef

    Dim cAttr           As String
    Dim nAttr           As Long
    Dim cType           As String
    Dim cTableName      As String
    Dim cFieldName      As String
    Dim cIdxName        As String
    Dim lPrimary        As Integer
    Dim lUnique         As Integer
    Dim nSize           As Integer
    Dim nType           As Integer
    Dim cSQL            As String
    

    dictCreate = False
    If cNewDBName = "" Then
	cDBName = Space(80)
    
	ret = GetPrivateProfileString("Database", "Name", "", cDBName, 80, cIniFile)
	cDBName = Trim(cDBName)
	If cDBName = "" Then
	    ret = dictStatus(DICT_STATUS_FATAL, "Invalid Database name or INI File invalid format!", 0, 0)
	    Exit Function
	End If
    Else
	cDBName = cNewDBName
    End If
    
    cLang = Space(20)
    ret = GetPrivateProfileString("Database", "Language", "", cLang, 20, cIniFile)
    cLang = Trim(cLang)
    If cLang = "" Then
	ret = dictStatus(DICT_STATUS_FATAL, "Invalid Database name or INI File invalid format!", 0, 0)
	Exit Function
    End If

    On Error Resume Next
    Kill cDBName
    On Error GoTo cantDoIt
    
    ret = dictStatus(DICT_STATUS_MESSAGE, "Creating database", 0, 0)
    Select Case cLang
	Case "DB_LANG_GENERAL"
	    Set db = CreateDatabase(cDBName, DB_LANG_GENERAL)
	Case "DB_LANG_SPANISH"
	    Set db = CreateDatabase(cDBName, DB_LANG_SPANISH)
	Case "DB_LANG_DUTCH"
	    Set db = CreateDatabase(cDBName, DB_LANG_DUTCH)
	Case "DB_LANG_SWEDFIN"
	    Set db = CreateDatabase(cDBName, DB_LANG_SWEDFIN)
	Case "DB_LANG_NORWDAN"
	    Set db = CreateDatabase(cDBName, DB_LANG_NORWDAN)
	Case "DB_LANG_ICELANDIC"
	    Set db = CreateDatabase(cDBName, DB_LANG_ICELANDIC)
	Case "DB_LANG_NORDIC"
	    Set db = CreateDatabase(cDBName, DB_LANG_NORDIC)
	Case Else
	    Set db = CreateDatabase(cDBName, DB_LANG_GENERAL)
    End Select
    

    nTables = GetPrivateProfileInt("Tables", "Count", 0, cIniFile)
    ret = dictStatus(DICT_STATUS_PROGRESS, "Creating tables", 0, nTables)
    For i = 1 To nTables
	cTableName = Space(80)
	ret = GetPrivateProfileString("Tables", "Table" + LTrim(Str(i - 1)), "", cTableName, 80, cIniFile)
	
	' strip the table attributes off the name
	cTableName = Trim(cTableName)
	cAttr = Mid(cTableName, InStr(cTableName + ",", ",") - 1)
	cTableName = Mid(cTableName, 1, InStr(cTableName + ",", ",") - 1)
	If cTableName = "" Then
	    ret = dictStatus(DICT_STATUS_FATAL, "Error in INI File creating table " + LTrim(Str(j - 1)), 0, 0)
	    Exit Function
	End If

	ret = dictStatus(DICT_STATUS_PROGRESS, "Creating table " + cTableName, i, nTables)
	
	nAttr = 0
	lAttached = False
	If InStr(cAttr, "DB_ATTACHEXCLUSIVE") Then
	    nAttr = nAttr + DB_ATTACHEXCLUSIVE
	    lAttached = True
	End If
	If InStr(cAttr, "DB_ATTACHSAVEPWD") Then
	    nAttr = nAttr + DB_ATTACHSAVEPWD
	    lAttached = True
	End If
	If InStr(cAttr, "DB_SYSTEMOBJECT") Then
	    nAttr = nAttr + DB_SYSTEMOBJECT
	End If
	If InStr(cAttr, "DB_ATTACHEDTABLE") Then
	    nAttr = nAttr + DB_ATTACHEDTABLE
	    lAttached = True
	End If
	If InStr(cAttr, "DB_ATTACHEDODBC") Then
	    nAttr = nAttr + DB_ATTACHEDODBC
	    lAttached = True
	End If

	ReDim tbd(1) As New tabledef
	tbd(0).Name = cTableName
	If nAttr Then
	    tbd(0).Attributes = nAttr
	    If lAttached Then
		cConnect = Space(80)
		ret = GetPrivateProfileString(cTableName, "Connect", "", cConnect, 80, cIniFile)
		cConnect = Left(cConnect, ret)
		If cConnect = "" Then
		    ret = dictStatus(DICT_STATUS_FATAL, "Error in INI file creating connected table " + cTableName, 0, 0)
		    Exit Function
		End If
		cSource = Space(80)
		ret = GetPrivateProfileString(cTableName, "SourceTable", "", cSource, 80, cIniFile)
		cSource = Left(cSource, ret)
		If cSource = "" Then
		    ret = dictStatus(DICT_STATUS_FATAL, "Error in INI file creating connected table " + cTableName, 0, 0)
		    Exit Function
		End If
		tbd(0).Connect = cConnect
		tbd(0).SourceTableName = cSource
	    End If
	End If


	nFields = GetPrivateProfileInt(cTableName, "FieldCount", 0, cIniFile)
	For j = 1 To nFields

	    cBuffer = Space(128)
	    ret = GetPrivateProfileString(cTableName, "Field" + LTrim(Str(j - 1)), "", cBuffer, 128, cIniFile)
	    If Trim(cBuffer) = "" Then
		ret = dictStatus(DICT_STATUS_FATAL, "Error in INI file creating fields for table " + cTableName, 0, 0)
		Exit Function
	    End If
	    cFieldName = Mid(cBuffer, 1, InStr(cBuffer + ",", ",") - 1)
	    cBuffer = Mid(cBuffer, InStr(cBuffer + ",", ",") + 1)
	    cType = Mid(cBuffer, 1, InStr(cBuffer + ",", ",") - 1)
	    cBuffer = Mid(cBuffer, InStr(cBuffer + ",", ",") + 1)
	    nSize = Val(Mid(cBuffer, 1, InStr(cBuffer + ",", ",") - 1))
	    cBuffer = Mid(cBuffer, InStr(cBuffer + ",", ",") + 1)
	    cAttr = Mid(cBuffer, 1, InStr(cBuffer + ",", ",") - 1)
	    
	    Select Case cType
		Case "DB_LONG"
		    nType = DB_LONG
		Case "DB_INTEGER"
		    nType = DB_INTEGER
		Case "DB_TEXT"
		    nType = DB_TEXT
		Case "DB_BOOLEAN"
		    nType = DB_BOOLEAN
		Case "DB_SINGLE"
		    nType = DB_SINGLE
		Case "DB_DOUBLE"
		    nType = DB_DOUBLE
		Case "DB_MEMO"
		    nType = DB_MEMO
		Case "DB_BYTE"
		    nType = DB_BYTE
		Case "DB_DATE"
		    nType = DB_DATE
		Case "DB_LONGBINARY"
		    nType = DB_LONGBINARY
		Case "DB_CURRENCY"
		    nType = DB_CURRENCY
		Case Else
		    ret = dictStatus(DICT_STATUS_FATAL, "Error in INI file creating fields for table " + cTableName, 0, 0)
		    Exit Function
	    End Select

	    nAttr = 0
	    If InStr(cAttr, "DB_FIXEDFIELD") Then nAttr = nAttr + DB_FIXEDFIELD
	    If InStr(cAttr, "DB_AUTOINCRFIELD") Then nAttr = nAttr + DB_AUTOINCRFIELD
	    If InStr(cAttr, "DB_UPDATABLEFIELD") Then nAttr = nAttr + DB_UPDATABLEFIELD

	    ReDim fld(0) As New field
	    fld(0).Name = cFieldName
	    fld(0).Type = nType
	    fld(0).Size = nSize
	    fld(0).Attributes = nAttr
	    tbd(0).Fields.Append fld(0)
	Next j

	nIndexes = GetPrivateProfileInt(cTableName, "IndexCount", 0, cIniFile)
	For j = 1 To nIndexes
	    ReDim idx(1) As New index
	    cBuffer = Space(128)
	    ret = GetPrivateProfileString(cTableName, "Index" + LTrim(Str(j - 1)), "", cBuffer, 128, cIniFile)
	    cIdxName = Mid(cBuffer, 1, InStr(cBuffer + ",", ",") - 1)
	    cBuffer = Mid(cBuffer, InStr(cBuffer + ",", ",") + 1)
	    cIdxFields = Mid(cBuffer, 1, InStr(cBuffer + ",", ",") - 1)
	    cBuffer = Mid(cBuffer, InStr(cBuffer + ",", ",") + 1)
	    lPrimary = Val(cBuffer)
	    cBuffer = Mid(cBuffer, InStr(cBuffer + ",", ",") + 1)
	    lUnique = Val(cBuffer)
	    
	    idx(0).Name = cIdxName
	    idx(0).Fields = cIdxFields
	    idx(0).Unique = lUnique
	    idx(0).Primary = lPrimary
	    tbd(0).Indexes.Append idx(0)
	Next j
	
	db.TableDefs.Append tbd(0)

    Next i
    ret = dictStatus(DICT_STATUS_PROGRESS, "", -1, 0)

    nQDefs = GetPrivateProfileInt("QueryDefinitions", "Count", 0, cIniFile)
    ret = dictStatus(DICT_STATUS_PROGRESS, "Creating query definitions", 0, nQDefs)
    For i = 1 To nQDefs
	cBuffer = Space(1024)
	ret = GetPrivateProfileString("QueryDefinitions", "QueryDef" + LTrim(Str(i - 1)), "", cBuffer, 1024, cIniFile)
	cBuffer = Left(cBuffer, ret)
	If cBuffer = "" Then
	    ret = dictStatus(DICT_STATUS_FATAL, "Error in INI file creating query definition " + LTrim(Str(i - 1)), 0, 0)
	    Exit Function
	End If
	cQDefName = Mid(cBuffer, 1, InStr(cBuffer + ",", ",") - 1)
	cSQL = Mid(cBuffer, InStr(cBuffer + ",", ",") + 1)

	ret = dictStatus(DICT_STATUS_PROGRESS, "", i, nQDefs)
	ReDim qd(0) As querydef
	Set qd(0) = db.CreateQueryDef(cQDefName, cSQL)
	qd(0).Close

    Next i
    ret = dictStatus(DICT_STATUS_PROGRESS, "", -1, 0)
    
    db.Close
    ret = dictStatus(DICT_STATUS_MESSAGE, "Database creation complete", 0, 0)
    dictCreate = True
    Exit Function

cantDoIt:
    ret = dictStatus(DICT_STATUS_FATAL, Error$, 0, 0)
    Exit Function
End Function

Function dictStatus (nType As Integer, cMsg As String, nItem As Integer, nItems As Integer) As Integer
    dictStatus = DICT_STATUS_RETURN_NONE
    Select Case nType
	Case DICT_STATUS_FATAL
	    fTestDict.Label1.Caption = cMsg
	    fTestDict.hsProgress.Visible = False
	    MsgBox cMsg, MB_OK, "Fatal Error!"

	Case DICT_STATUS_MESSAGE
	    fTestDict.Label1.Caption = cMsg
	    fTestDict.Label1.Refresh

	Case DICT_STATUS_PROGRESS
	    If nItem = 0 Then
		fTestDict.hsProgress.Visible = True
		fTestDict.hsProgress.Min = 1
		fTestDict.hsProgress.Max = nItems
		fTestDict.hsProgress.Value = 1
		
	    ElseIf nItem = -1 Then
		fTestDict.hsProgress.Visible = False
	    Else
		fTestDict.hsProgress.Value = nItem
	    End If
	    fTestDict.Label1.Caption = cMsg
	    fTestDict.Label1.Refresh

    End Select
End Function

