////////////////////////////////////////////////////////////////////////////////////
// Internet Global Phone Project
// dlg_host.cpp : implementation file for trivial dialog box class
//
// Dialog box used in requests for IP address from user.
//
////////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 1993-1994	microWonders Inc.  All rights reserved.
//                                                                         
// AN OPEN INVITION TO BUILD UPON AND CONTRIBUTE TO THE PUBLIC TECHNOLOGY POOL:
// You are encouraged to redistribute, and build upon the technologies presented 
// in this source module and the accompanying article in Dr. Dobb's Journal provided 
// all the conditions listed in the MUSTREAD.TXT file, included with this 
// distribution, are met.
////////////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "mphone.h"

#include "winsock.H"  // use winsock for inet_addr and inet_ntoa, UI stuff
#include "dlg_host.h" 

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgHostID dialog


CDlgHostID::CDlgHostID(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgHostID::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgHostID)
	m_inputAddress = "";
	//}}AFX_DATA_INIT
}

void CDlgHostID::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgHostID)
	DDX_Text(pDX, IDC_HOSTADDR, m_inputAddress);
	DDV_MaxChars(pDX, m_inputAddress, 50);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDlgHostID, CDialog)
	//{{AFX_MSG_MAP(CDlgHostID)
	ON_BN_CLICKED(IDOK, OnHostIDOK)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CDlgHostID message handlers

void CDlgHostID::OnHostIDOK()
{
    UpdateData(TRUE);
	if ((m_InetAddress = inet_addr(m_inputAddress)) == INADDR_NONE)
	{   
      AfxMessageBox("Please correct the IP address entered.");
	} 
	else
	 CDialog::OnOK();
	
}


BOOL CDlgHostID::OnInitDialog()
{   
    struct in_addr *inp;
    ULONG tmp_addr;
    tmp_addr = htonl(m_InetAddress);   // to network representation
    inp = (struct in_addr *) &tmp_addr;
	m_inputAddress = inet_ntoa(*inp) ; 
	CDialog::OnInitDialog();
	
	
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}
