////////////////////////////////////////////////////////////////////////////////////
// Internet Global Phone Project
// socket.h : definitions of the CSocketOwner base classes                             
//
// See Dr. Dobb's Journal text for a description of the classes.  These C++
// classes attempt to provide a more 'humane' way to program Winsock by shielding
// much of the complexity and providing a higher level abstraction based on
// the client/server/listener paradigm made popular in BSD networking.
//
// Source for implementation of these base classes are not provided as they tie
// closely to the WSNETWRK library.  Link with SOCKLIB.LIB to use these
// classes.
////////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 1993-1994	microWonders Inc.  All rights reserved.
//                                                                         
// AN OPEN INVITION TO BUILD UPON AND CONTRIBUTE TO THE PUBLIC TECHNOLOGY POOL:
// You are encouraged to redistribute, and build upon the technologies presented 
// in this source module and the accompanying article in Dr. Dobb's Journal provided 
// all the conditions listed in the MUSTREAD.TXT file, included with this 
// distribution, are met.
////////////////////////////////////////////////////////////////////////////////////

#define WS_TALKCLIENT	3
#define WSTALKLISTENER	2  
#define WSTALKCHILD		4

#define MIN_UINTERVAL	3000
//#define WSTALKBUFFERSIZE 255

#define WSTALKFAILED	1   
#define WSTALKLISFAILED	6       
#define WSTALKBACK		0
#define WSTALKBEGIN		0x0300
#define WSCHILDCLOSED	7 
#define WSTALKLISCONNECT 8
#define WSTALKNEWCHILD	5


#define TCP_PROTOCOL	"tcp"   
#define TALK_SERVICE	"intertalker"

// legacy construct for prototype of echo server
//
typedef struct
{
  WORD  seq;
  DWORD time;
  DWORD done;
  char  szBuffer[80];
} ECHOPACKET, near *PECHOPACKET, far *LPECHOPACKET;

#define WSTALKBUFFERSIZE sizeof(ECHOPACKET)  

void __export WINAPI UniversalCSockOwnerNotify(WSSOCKET iEntry, int iEvent, int iError);

class CSocketOwner : public CObject
{
public: 
	CSocketOwner() {}           
	~CSocketOwner() {} 
	WSSOCKET GetSafeSocket() const {return (m_socket); } 
	BOOL SetSafeSocket(WSSOCKET sock) {m_socket = sock; return TRUE;}
    void Notify(WSSOCKET, int, int);
    virtual void OnConnected(int, int) {}
    virtual void OnSendCompleted(int, int) {}
    virtual void OnReceiveCompleted(int, int) {}
    virtual void OnTimerExpired(int, int)  {}
	virtual void OnDisconnected(int, int)  {}
	virtual void OnOtherMsgs(int, int)  {}     

public:  
  int         m_iType;  
  NOTIFYPROC  m_fNotifyProc;  
protected:
	WSSOCKET m_socket;
protected:                                      
	// wrap the WSNETWRK library
	BOOL Accept(LPWSADDRESS addr, LPWSPORTID portid);
    void CallBack(int i, int j);
	BOOL CancelIO(void);
 	BOOL  wConnect(LPCSTR lp, WSPORTID portid);
    BOOL ConnectTo(WSADDRESS waddr, WSPORTID portid);
	WSSOCKET CreateSocket(int i, int j, WSPORTID portid, UINT k, HWND hWnd, NOTIFYPROC lpProc);
	BOOL   CreateTimer(UINT i);
public:		
	BOOL DestroySocket(void);
public:
	LPVOID   GetSockMemory(void);
protected:		
	BOOL   KillTimer(void);
	int  LastRecvLength(void);
	HWND  MyCallBack(void);
	int   MyLastError(void);
	BOOL   Recv( LPSTR lp, int i);
	BOOL   RecvFrom( LPSTR lp, int i, LPWSADDRESS lpaddr, LPWSPORTID lpid);
	BOOL Send( LPCSTR lp1, int i);
	BOOL SendTo( LPCSTR lp1, int i, WSADDRESS waddr, WSPORTID portid);
public:                        
	WSADDRESS MyAddress(void);
    // this can also be used to create new server socket... via listener 
	WSSOCKET AttachSocket(HSOCK hSock, UINT i, HWND hWnd, NOTIFYPROC lpf);
	int Checksum(unsigned short far * fp, int i);
	WSADDRESS GetHostByName(LPCSTR name);
	int  GetHostName(LPSTR lp , int i);
   	int GetProtocolByName(LPCSTR lp);
	WSPORTID   GetServiceByName(LPCSTR lp1, LPCSTR lp2);
	int  GetServiceByPort(WSPORTID portid, LPCSTR lp1, LPSTR lp2, int i);
	long HToNL(long ld);
	long      NToHL(long lg);

// Attributes
public: 
#ifdef _DEBUG
	virtual void AssertValid() const {}
	virtual void Dump(CDumpContext& dc) const {}
#endif
};

// NOT USED WITHIN IGP
class CSockClient: public CSocketOwner
{ 

public: // create from serialization only
	CSockClient(); 
	~CSockClient(); 
	// overload to connect by name or address
    WSSOCKET Connect( UINT prot, LPCSTR, WSPORTID, UINT, HWND,NOTIFYPROC, UINT);
	WSSOCKET Connect(UINT prot, WSADDRESS, WSPORTID, UINT, HWND, NOTIFYPROC, UINT);
	BOOL SetTimeout(WSSOCKET, UINT);
	BOOL End();

	void ResetStats(void); 
	
	virtual void OnConnected(int, int);
	virtual void OnSendCompleted(int, int);
	virtual void OnReceiveCompleted(int, int);
	virtual void OnTimerExpired(int, int);	   
	virtual void OnDisconnected(int, int);
	
	void OnSocketSelect();
	void OnTimer();
	void OnCloseSocket();
	
    void SendData();
	void ReadLine();


private:  
  BOOL        m_bConnected;
  WSADDRESS   m_lAddress;
  WSPORTID    m_uPort;
  WSADDRESS   m_lRecvAddress;
  WSPORTID    m_uRecvPort;
  UINT        m_uAttempts;
  UINT        m_uFailures;
  DWORD       m_dMin;
  DWORD       m_dAvg;
  DWORD       m_dMax;
  long double m_ldTotalTime;
  UINT        m_uSequence;
  BOOL        m_bInProgress;
  UINT        m_uInterval;
  UINT        m_uLateReplies;
  UINT        m_uLimit;

  UINT        m_uErrorCount;
  ECHOPACKET  m_Packet;

private:       
	void WriteData();
	void DestroyConnection();
	
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

};
                      
// NOT USED WITHIN IGP                      
class CSockServer: public CSocketOwner
{                                
public:
	CSockServer(); 
	~CSockServer();
	int Create(void);
    WSSOCKET StartServer(HWND, NOTIFYPROC);
    WSSOCKET EndServer(WSSOCKET);

    virtual void OnOtherMsgs(int, int);
    virtual void OnReceiveCompleted(int, int);
    virtual void OnSendCompleted(int, int);
    virtual void OnDisconnected(int, int);

private:
  WSPORTID    m_uPort;
  WSADDRESS   m_lAddress;
  char        m_szBuffer[WSTALKBUFFERSIZE];    
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

}; 


class CSockListenServer: public CSocketOwner
{                                
public:
	CSockListenServer(); 
	~CSockListenServer();
	int Create(void);  
	WSSOCKET StartListener(LPCSTR, WSPORTID, LPWSADDRESS,  HWND, NOTIFYPROC);
	BOOL EndListener(); 

	virtual void OnOtherMsgs(int, int);
	                                         
protected:

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
	
};
