////////////////////////////////////////////////////////////////////////////////////
// Internet Global Phone Project
// wsmin.h : general WSNETWRK based declarations                             
//
// Minimal required exerpts from WSNETWRK include file.
// 
// WSNETWRK is a library which makes Winsock programming substantially
// easier.  Contact icode@teleport.com (Mark Clouden) for more info.
////////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 1993-1994	microWonders Inc.  All rights reserved.
//                                                                         
// AN OPEN INVITION TO BUILD UPON AND CONTRIBUTE TO THE PUBLIC TECHNOLOGY POOL:
// You are encouraged to redistribute, and build upon the technologies presented 
// in this source module and the accompanying article in Dr. Dobb's Journal provided 
// all the conditions listed in the MUSTREAD.TXT file, included with this 
// distribution, are met.
////////////////////////////////////////////////////////////////////////////////////

#ifndef _WSMINH_
#define _WSMINH_

#ifdef __cplusplus
extern "C"
{
#endif

#define NOTASOCK                  -1
#define TCPSOCK                    1   

#define WSCONNECTED           0x0101  
#define WSDISCONNECTED        0x0102 
#define WSACCEPTCOMPLETE      0x0105  

#define WM_WSANOTIFY          0x7FFF

#define WSEVENT(x) LOWORD(x)
#define WSERROR(x) HIWORD(x)

/*
                            A few WSNETWRK types
*/
typedef int             WSSOCKET;    
typedef unsigned short  WSPORTID;    
typedef WSPORTID far   *LPWSPORTID;    
typedef unsigned long   WSADDRESS;         
typedef WSADDRESS far  *LPWSADDRESS;   
typedef unsigned int    HSOCK;       
typedef void (WINAPI *  NOTIFYPROC)(WSSOCKET, int, int);

#ifndef INADDR_NONE
#define INADDR_NONE      (unsigned long)0xFFFFFFFF
#endif

BOOL      __export WINAPI WSDestroySocket(WSSOCKET);
long      __export WINAPI WSNToHL(long);

#ifdef __cplusplus
}
#endif
#endif
