/*
This file include working DEMO example of KNOW-HOW.GRAPHICS usage.
This example use some code (main() function for DOS, or WinMain for
Windows) to call common demo() function, which perform drawing on screen
(DOS) or on DC (Windows). Windows demo wait until user click mouse
button. 
*/

#include "bgipaint.h"

///////////////////// Common DOS/Windows part of the DEMO ///////////////////
//////////// This example draws "bird" and calendar for 1995 (1996) /////////
#include <stdlib.h>
#include <string.h>

class Demo : public KH_Paint
    {
    public:
        void demo();
        void bird();
        void dn(int, int);
        void wing(int, int);
        void pero(int, int, int);
        void calendar(int left, int top, int year, bool visocose);
        int mon(int x, int y, char* mon, int first_day, int num_of_days);
    };
///////////////////
void Demo::demo()
    {
    set_add_zoom(1,1);          // ZOOM for all picture

    setfillstyle(SOLID_FILL, WHITE);
    set_fill(ON);
    set_zoom(0.1, 0.05);           // ZOOM for the part of picture,
                                   // before the next "zoom" call
    rectangle(0, 0, 5000, 10000);  // Will be multiplyed to ZOOM factor

    set_scroll(800, 500);
    bird();
    set_scroll(0, 500);
    set_zoom(0.35, 0.33);

    setcolor(BLACK);
    load("trip.chr");
// Parameters: left, top, year, 0 if not visocose (1980 was)
    calendar(80, 120, 1995, 0);

    char s[] = { "  KNOW-HOW.GRAPHICS" };
    load("lcom.chr");
    set_scroll(0, 0);
    set_zoom(1, 1);
    setcolor(GREEN);
    for(int i = 0; i < strlen(s); i++)
        {
        rotate(loc(250, 250), 180 - 180 / strlen(s) * i);
        draw_char(480, 250, s[i], 0);
        }
    rotate(0,0,0);
    }
/////////////////
void Demo::calendar(int l, int t, int year, bool v)
    {
    int day = 7;              // for 1995
    if(year == 1996)          // add cone for other years or use some
	day = 1;              // calculations
    int x = l;
    int y = t + 15;
    for(int i = 1; i <= 3; i++)
	{
	outtextxy(x, y, "Mo");
	y += 30;
	outtextxy(x, y, "Tu");
	y += 30;
        outtextxy(x, y, "We");
        y += 30;
        outtextxy(x, y, "Th");
        y += 30;
        outtextxy(x, y, "Fr");
        y += 30;
        outtextxy(x, y, "Sa");
        y += 30;
        outtextxy(x, y, "Su");

        y += 100;
        }
    x = l + 100;
    y = t - 30;
    day = mon(x, y, "January", day, 31);
    int dv = v == 0 ? 28 : 29;

    day = mon(x + 340, y, "February", day, dv);
    day = mon(x + 680, y, "March", day, 31);
    day = mon(x + 1020, y, "April", day, 30);
    day = mon(x, y +280, "May", day, 31);
    day = mon(x + 340, y + 280, "June", day, 30);
    day = mon(x + 680, y + 280, "July", day, 31);
    day = mon(x + 1020, y + 280, "August", day, 31);
    day = mon(x, y + 560, "September", day, 30);
    day = mon(x + 340, y + 560, "October", day, 31);
    day = mon(x + 680, y + 560, "November", day, 30);
    day = mon(x + 1020, y + 560, "December", day, 31);
    }
//////////////
int Demo::mon(int x1, int y1, char* head, int start, int num)
    {
    set_fill(ON);
    setfillstyle(SOLID_FILL, WHITE);
    outtextxy(x1 + 60, y1, head);
    int days = 1;
    int ln = start;
    y1 += 15;

    char s[10];
    while(1)
        {
        if(days > num)
            return ln;
        if(ln > 7)
            {
            x1 += 50;
            ln = 1;
            continue;
            }
        outtextxy(x1, y1 + 30 * ln, itoa(days, s, 10));
        days++;
	ln++;
        }
    }
////////////////
void Demo::bird()
    {
    set_zoom(0.1, 0.05);       // To the next "zoom" call
    setlinestyle(1, SOLID_LINE);
    setcolor(BLUE);
    setfillstyle(SOLID_FILL, YELLOW);

    int dy = 30;
    for(int i = 1; i <= 12; i++)
        {
        ellipse(1600, 800 + 2 * dy * i, 0, 360, dy * i, dy * i);
        ellipse(1600, 2300 - 2 * dy * i, 0, 360, dy * i, dy * i);
        }
    dn(1800, 1800);
    wing(1900, 1400);
    set_mirror(1600);
    dn(1800, 1800);
    wing(1900, 1400);
    set_mirror(0);

    rotate(loc(0, 0), 0);
    ellipse(1600, 700, 0, 360, 360, 360);
    for(i = 0; i <= 60; i++)
	{
        pero(1800, 700, 1);
        rotate(loc(1600, 700), 6 * i);
        }
    rotate(loc(1600, 2000), -90);
    pero(1600, 2000, 7);
    rotate(loc(1600, 2000), -100);
    pero(1600, 2000, 5);
    rotate(loc(1600, 2000), -80);
    pero(1600, 2000, 5);

    rotate(loc(0, 0), 0);

    ellipse(1700, 600, 0, 360, 60, 130);
    ellipse(1500, 600, 0, 360, 60, 130);
    ellipse(1700, 600, 0, 360, 60, 60);
    ellipse(1500, 600, 0, 360, 60, 60);
    ellipse(1600, 800, 0, 360, 20, 90);
    }
//////////////////
void Demo::wing(int xwin, int ywin)
    {
    for(int i = 0; i <= 10; i++)
        {
        rotate(xwin, ywin, 20 * i - 120);
        pero(xwin, ywin, i / 2);
        }
    set_zoom(0.1, 0.05);
    }
/////////////////
void Demo::dn(int xdn, int ydn)
    {
    rotate(xdn + 40, ydn + 40, -180);
    for(int i = 0; i <= 19; i++)
        {
	rotate(xdn + 40, ydn + 40, 20 * i);
        pero(xdn, ydn, 1);
        }
    }
/////////////////
void Demo::pero(int x, int y, int sz)
    {
    int x1 = x + 40 * sz;
    int x2 = x + 100 * sz;
    int x3 = x + 230 * sz;
    int x4 = x + 300 * sz;
    int y1 = y - 20 * sz;
    int y2 = y - 30 * sz;
    int y3 = y + 20 * sz;
    int y4 = y + 30 * sz;
    int points[] = {  x1, y, x2, y1, x3, y2, x4, y, x3, y4, x2, y3, x1, y };
    fillpoly(7, points);
    line(x, y, x + 300, y);
    }
////////////////////// End of common DOS / Windows part /////////////////////
/*
//////////////////////////////// BGI DOS Demo ///////////////////////////////
#include <iostream.h>
#include <conio.h>
void main()
    {
    clrscr();
cout << "            K N O W - H O W . G R A P H I C S  6.0\r\n";
cout << "\r\n";
cout << "Source codes of DOS / Windows graphics Tool Kit for Borland C++ 3.x\r\n";
cout << "\r\n";
cout << "    KNOW-HOW.GRAPHICS  incapsulates  calls to  functions  of concrete library\r\n";
cout << "and provide common code for DOS/Windows graphics\r\n";
cout << "Current  version  works  with  DOS  (BGI) and  Windows (GDI), but  only minor\r\n";
cout << "changes are required  to add  interface to any  other  library which  support\r\n";
cout << "standart drawing functions (moveTo, lineTo and so on)\r\n";
cout << "This code also  support Zooming,  Scrolling, Rotation  and  Complex  (Nested)\r\n";
cout << "Rotation  of image  or part  of it.  This  features  could  be used  for  the\r\n";
cout << "development  of  CAD systems, Vector  drawing tools, and Writing of platform-\r\n";
cout << "independent  functions. Size of  code  written with  KH.GRAPHICS is 2-5 times\r\n";
cout << "smaller then without it.\r\n";
cout << "BGI fonts ( including filled fonts ) could  be used  under DOS  and  Windows,\r\n";
cout << "all  image   transformations,  including  rotations  are  valid  withs  them.\r\n";
cout << "\r\n";
cout << "Additional  development  tools  include  heap  check  modules  (DOS only) for\r\n";
cout << "memory leaks detections even if program hung-up the system.\r\n";
cout << "\r\n";
    getch();
    int gdriver = DETECT, gmode;
    initgraph(&gdriver, &gmode, "");

    Demo* paint = new Demo();
    paint->demo();

    delete paint;
    getch();
    closegraph();
cout << "            K N O W - H O W . G R A P H I C S  6.0\r\n";
cout << "\r\n";
cout << "Additional products:\r\n";
cout << "    KNOW-HOW.GRAF 6.0. Business and  Scientific diagrams.  Supported types of\r\n";
cout << "grafs:  MARKER,  LINE, LINE-and-MARKER,   BAR,  BAR-3D, STACKED BAR (could be\r\n";
cout << "expanded).  Manual   or   automatic   calculation  of  the  labels  position,\r\n";
cout << "multiple datasets,  four  axes (two X  and  two  Y)  with  different  scales.\r\n";
cout << "Product is  based  on the KNOW-HOW.GRAPHICS and have access to all its tools,\r\n";
cout << "as Zooming,  Scrolling,  Rotation  and  other. Same code for DOS and Windows.\r\n";
cout << "\r\n";
cout << "    KNOW-HOW.SLANG 6.0. Basic-like language  with  access  to KH.GRAPHICS and\r\n";
cout << "KH.GRAF functions. Could be  used  in  C++  program  to  acces  its  specific\r\n";
cout << "functions as well. Multy file projects\r\n";
cout << "Usage: Data  processing  tools, Data  presentations (load/calc/plot/drawing),\r\n";
cout << "Vector  drawing  tools,  BGI  /  GDI  maketing tools (no compilation stage).\r\n";
cout << "\r\n";
cout << "         <<< All source codes available >>>\r\n";
cout << "\r\n";
    getch();
    clrscr();
cout << "\r\n";
cout << "\r\n";
cout << "Contacts: Stepan Vartanov, ad398@cfn.cs.dal.ca\r\n";
cout << "To order send check or money to: \r\n";
cout << "  P.O.Box 34041, Scotia Scuare RPO, Halifax, N.S., Canada, B3J 3S1\r\n";
cout << "\r\n";
cout << " 1. KNOW-HOW.GRAPHICS _____________________________________ 20 $ USA\r\n";
cout << " 2. KNOW-HOW.GRAF  ( KH.GRAPHICS included ) _______________ 50 $ USA\r\n";
cout << " 3. KNOW-HOW.SLANG ( KH.GRAPHICS and KH.GRAF included ) ___ 95 $ USA\r\n";
cout << "\r\n";
cout << "\r\n";
cout << "\r\n";
    getch();
    }
*/
////////////////////////////// GDI Windows Demo /////////////////////////////
// This example demonstrates output to OWL window. If necessary,
// any other Windows library could be used.
/*
#include <owl.h>

class TMyApp : public TApplication
{
public:
  TMyApp(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow)
    : TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
  virtual void InitMainWindow();
};

_CLASSDEF(TMyWindow)
class TMyWindow : public TWindow, public Demo
{
public:
  TMyWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle), Demo() { DC = GetDC(HWindow); }
  virtual void WMLButtonDown(RTMessage Msg)
    = [WM_FIRST + WM_LBUTTONDOWN];
};

void TMyWindow::WMLButtonDown(RTMessage)
    {
    DC = GetDC(HWindow);
    demo();
    ReleaseDC(HWindow, DC);
    }

void TMyApp::InitMainWindow()
{
  MainWindow = new TMyWindow(NULL, Name);
}

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpCmdLine, int nCmdShow)
{
  TMyApp MyApp("Sample KNOW-HOW.GRAPHICS Program", hInstance, hPrevInstance,
               lpCmdLine, nCmdShow);
  MyApp.Run();
  return MyApp.Status;
}
*/
