#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include <direct.h>
#include <string.h>
#include "appsetup.h"

/*-------------------------------------------------------------------------*/
BOOL WINAPI InitEndDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
    {
    static int	iFirstChoise, iSecondChoise;
    char	InitString[MAXDIGITS], LoadString[4*MAXFILECHARS];
    char	*AutoStartString;

    switch(message)
	{
	case WM_INITDIALOG:
		iFirstChoise = 2;
		iSecondChoise = 2;
		CheckRadioButton(hDlg, IDEND_SHELL, IDEND_NONE, IDEND_NONE);
		CheckRadioButton(hDlg, IDEND_START, IDEND_EXIT, IDEND_EXIT);
		CheckDlgButton(hDlg, IDEND_SAVE, 1);
	    return TRUE;

	case WM_COMMAND:
	    switch(wParam)
		{
		case IDEND_SHELL:
		    iFirstChoise = 0;
		    CheckRadioButton(hDlg, IDEND_SHELL, IDEND_NONE, IDEND_SHELL);
		    return TRUE;

		case IDEND_LOAD:
		    iFirstChoise = 1;
		    CheckRadioButton(hDlg, IDEND_SHELL, IDEND_NONE, IDEND_LOAD);
		    return TRUE;

		case IDEND_NONE:
		    iFirstChoise = 2;
		    CheckRadioButton(hDlg, IDEND_SHELL, IDEND_NONE, IDEND_NONE);
		    return TRUE;

	       case IDEND_START:
		    iSecondChoise = 0;
		    CheckRadioButton(hDlg, IDEND_START, IDEND_EXIT, IDEND_START);
		    return TRUE;

	       case IDEND_RESTART:
		    iSecondChoise = 1;
		    CheckRadioButton(hDlg, IDEND_START, IDEND_EXIT, IDEND_RESTART);
		    return TRUE;

	       case IDEND_EXIT:
		    iSecondChoise = 2;
		    CheckRadioButton(hDlg, IDEND_START, IDEND_EXIT, IDEND_EXIT);
		    return TRUE;

	       case IDEND_SAVE:
		    CheckDlgButton(hDlg, IDEND_SAVE, !IsDlgButtonChecked(hDlg, IDEND_SAVE));
		    return TRUE;

		case IDEND_OK:
		    sprintf(szBuffer,"%d",APPBARVERSION);
		    WritePrivateProfileString(INI_SYSTEM, INITIALIZED, szBuffer, INI_FILE);
		    if(IsDlgButtonChecked(hDlg, IDEND_SAVE))
			IniSave();
		    if(iFirstChoise == 1)
			{
			GetProfileString("windows", "load", "  ", LoadString, (3*MAXFILECHARS)-1);
			AutoStartString = strcat(strcat(LoadString, " "), "appbar.exe");
			WriteProfileString("windows", "load", AutoStartString);
			}
		    if(iFirstChoise == 0)
			WritePrivateProfileString("boot", "shell","appbar.exe", "system.ini");
		    if(iSecondChoise == 0)
			WinExec("appbar.exe", SW_SHOWNORMAL);
		    if(iSecondChoise == 1)
			ExitWindows(EW_RESTARTWINDOWS, 0);
		    EndDialog(hDlg, 0);
		    PostMessage(hWnd, WM_CLOSE, 0, 0);
		    return TRUE;

		case IDEND_CANCEL:
		    sprintf(InitString,"%d",APPBARVERSION);
		    WritePrivateProfileString(INI_SYSTEM, INITIALIZED, InitString, INI_FILE);
		    EndDialog(hDlg, 0);
		    InvalidateRect(hWnd, NULL, TRUE);
		    UpdateWindow(hWnd);
		    return TRUE;
		}
	    break;
	}
    return FALSE;
    }
