/*
Applib.dll, dynamic link library for AppBar.exe, AppSetup.exe and the AppTools.

 by
 GMP van kempen
 NEVERnever Software 1991-1993

history:
    4.00.1  Initial version
    4.00.2  Added the IniFile parameter to the SaveButtonIni and
	    ReadButtonIni function so that AppMore and Morsetup can use them
	    too.
*/

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include "applib.h"

BOOL fWMCloseSeen = TRUE;
FARPROC lpfnOrgCloseWndProc;

int FAR PASCAL LibMain(HINSTANCE hInstance, UINT wDataSeg, UINT wHeapSize,
		       LPSTR lpszCmdline)
    {
    if(wHeapSize > 0)
	UnlockData(0);

    return 1;
    }

/*--------------------------------------------------------------------------*/
TEXTMETRIC WINAPI RetrieveTextMetrics(HWND hWnd)
    {
    int iOldMapMode;
    HDC hDC;
    TEXTMETRIC tm;

    hDC = GetDC(hWnd);
    iOldMapMode = GetMapMode(hDC);
    SetMapMode(hDC, MM_TEXT);
    SelectFont(hDC, GetStockFont(SYSTEM_FONT));
    GetTextMetrics(hDC, &tm);
    SetMapMode(hDC, iOldMapMode);
    DeleteDC(hDC);
    return tm;
    }

/*-------------------------------------------------------------------------*/
void WINAPI DrawBitmap(HDC hdc, short x, short y, HBITMAP hBitmap)
    {
    BITMAP bm;
    HDC    hMemDC;
    POINT  pt;

    hMemDC = CreateCompatibleDC(hdc);
    SelectObject(hMemDC, hBitmap);
    GetObject(hBitmap, sizeof(BITMAP), (LPSTR) &bm);
    pt.x = bm.bmWidth;
    pt.y = bm.bmHeight;

    BitBlt(hdc, x, y, pt.x, pt.y, hMemDC, 0, 0, SRCCOPY);

    DeleteDC(hMemDC);
    }

/*----------------------------------------------------------------------------*/
/* FUNCTION: ReadSystemIni(void)						      */
/*                                                                            */
/* PURPOSE:  Read [System] settings in the appbar.ini file.			      */
/*----------------------------------------------------------------------------*/
APPSYSTEM WINAPI ReadSystemIni(VOID)
    {
    APPSYSTEM AppSystem;
    int itemp;

    // get ini-settings for AppSystem struct.
    itemp = GetPrivateProfileInt(INI_SYSTEM, LEFT, LEFT_DEFAULT, INI_FILE);
    AppSystem.Left = WITHIN(itemp, -1, MAXRES);

    itemp = GetPrivateProfileInt(INI_SYSTEM, TOP, TOP_DEFAULT, INI_FILE);
    AppSystem.Top = WITHIN(itemp, -1, MAXRES);

    itemp = GetPrivateProfileInt(INI_SYSTEM, CLOSEALL, CLOSEALL_DEFAULT, INI_FILE);
    AppSystem.CloseAll = ONEORZERO(itemp);

    itemp = GetPrivateProfileInt(INI_SYSTEM, STAYINFRONT, STAYINFRONT_DEFAULT, INI_FILE);
    AppSystem.StayInFront = ONEORZERO(itemp);

    itemp = GetPrivateProfileInt(INI_SYSTEM, DOUBLECLICK, DOUBLECLICK_DEFAULT, INI_FILE);
    AppSystem.DoubleClick = ONEORZERO(itemp);

    itemp = GetPrivateProfileInt(INI_SYSTEM, BIGBUTTONS, BIGBUTTONS_DEFAULT, INI_FILE);
    AppSystem.BigButtons = ONEORZERO(itemp);

    itemp = GetPrivateProfileInt(INI_SYSTEM, INITIALIZED, INITIALIZED_DEFAULT, INI_FILE);
    AppSystem.Initialized = WITHIN(itemp, 0, APPBARVERSION);

    itemp = GetPrivateProfileInt(INI_SYSTEM, BUTTONS, BUTTONS_DEFAULT, INI_FILE);
    AppSystem.Buttons = WITHIN(itemp, 1, MAXAPPS);

    itemp = GetPrivateProfileInt(INI_SYSTEM, COLUMNS, COLUMNS_DEFAULT, INI_FILE);
    AppSystem.Columns = WITHIN(itemp, 1, AppSystem.Buttons+1);

    itemp = GetPrivateProfileInt(INI_SYSTEM, BORDER, BORDER_DEFAULT, INI_FILE);
    AppSystem.Border = WITHIN(itemp, 0, MAXBORDER);

    GetPrivateProfileString(INI_SYSTEM, DEFAULTICONDIR, AppSystem.DefaultIconDir,
			   AppSystem.DefaultIconDir, MAXFILECHARS-1, INI_FILE);

    GetPrivateProfileString(INI_SHELL, SHELLGROUP, SHELLGROUP_DEFAULT,
			   AppSystem.ShellGroup, 4*MAXFILECHARS-1, INI_FILE);

    return AppSystem;
    }

/*----------------------------------------------------------------------------*/
/* FUNCTION: ReadSoundIni(void)						      */
/*                                                                            */
/* PURPOSE:  Read [Sound] settings in the appbar.ini file.			      */
/*----------------------------------------------------------------------------*/
APPSOUND WINAPI ReadSoundIni(VOID)
    {
    int itemp;
    APPSOUND AppSound;

    itemp = GetPrivateProfileInt(INI_SOUND, SOUNDENABLE, SOUNDENABLE_DEFAULT, INI_FILE);
    AppSound.EnableSound = ONEORZERO(itemp);

    GetPrivateProfileString(INI_SOUND, APPSTART, APPSTART_DEFAULT,
			AppSound.AppBarStart, MAXFILECHARS-1, INI_FILE);

    GetPrivateProfileString(INI_SOUND, APPEXIT, APPEXIT_DEFAULT,
			AppSound.AppBarExit, MAXFILECHARS-1, INI_FILE);

    GetPrivateProfileString(INI_SOUND, WINEXIT, WINEXIT_DEFAULT,
			AppSound.WindowsExit, MAXFILECHARS-1, INI_FILE);

    GetPrivateProfileString(INI_SOUND, PROGSTART, PROGSTART_DEFAULT,
			AppSound.ProgramStart, MAXFILECHARS-1, INI_FILE);

    GetPrivateProfileString(INI_SOUND, PROGCLOSE, PROGCLOSE_DEFAULT,
			AppSound.ProgramClose, MAXFILECHARS-1, INI_FILE);

    GetPrivateProfileString(INI_SOUND, DROPFILE, DROPFILE_DEFAULT,
			AppSound.DropFile, MAXFILECHARS-1, INI_FILE);

    GetPrivateProfileString(INI_SOUND, ERRORMESSAGE, ERRORMESSAGE_DEFAULT,
			AppSound.ErrorMessage, MAXFILECHARS-1, INI_FILE);

    GetPrivateProfileString(INI_SOUND, SOUNDDIR, SOUNDDIR_DEFAULT,
			AppSound.SoundDirectory, MAXFILECHARS-1, INI_FILE);

    return AppSound;
    }

/*----------------------------------------------------------------------------*/
/* FUNCTION: ReadButtonIni(void)						      */
/*                                                                            */
/* PURPOSE:  Read settings of one Button from the appbar.ini file.			      */
/*----------------------------------------------------------------------------*/
APPBARBUTTONS WINAPI ReadButtonIni(int i, LPSTR SectionName, LPSTR IniFile)
    {
    char IniString[20];
    APPBARBUTTONS AppButton;
    int itemp, j;

    j = i+1;
    wvsprintf(IniString,"Icon%d",&j);
    GetPrivateProfileString(SectionName, IniString, AppButton.IcoName,
				AppButton.IcoName, MAXFILECHARS-1, IniFile);

    wvsprintf(IniString,"Prog%d",&j);
    GetPrivateProfileString(SectionName, IniString, AppButton.ProgName,
				AppButton.ProgName, MAXFILECHARS-1, IniFile);

    wvsprintf(IniString,"Dir%d",&j);
    GetPrivateProfileString(SectionName, IniString, AppButton.StartDir,
				AppButton.StartDir, MAXFILECHARS-1, IniFile);

    wvsprintf(IniString,"Params%d",&j);
    GetPrivateProfileString(SectionName, IniString, AppButton.Params,
				AppButton.Params, MAXFILECHARS-1, IniFile);

    wvsprintf(IniString,"Close%d",&j);
    itemp = GetPrivateProfileInt(SectionName, IniString, CLOSEPROG_DEFAULT, IniFile);
    AppButton.Close = ONEORZERO(itemp);

    wvsprintf(IniString,"ShowMode%d",&j);
    itemp = GetPrivateProfileInt(SectionName, IniString, SHOWMODE_DEFAULT, IniFile);
    AppButton.ShowMode = WITHIN(itemp, 0, 3);

    wvsprintf(IniString,"IconNumber%d",&j);
    itemp = GetPrivateProfileInt(SectionName, IniString, ICONNUMBER_DEFAULT, IniFile);
    AppButton.IconNumber = itemp;
    AppButton.IconNumber = max(AppButton.IconNumber, 0);

    wvsprintf(IniString,"ButtonLook%d",&j);
    itemp = GetPrivateProfileInt(SectionName, IniString, BUTTONLOOK_DEFAULT, IniFile);
    AppButton.ButtonLook = ONEORZERO(itemp);

    wvsprintf(IniString,"NoSound%d",&j);
    itemp = GetPrivateProfileInt(SectionName, IniString, NOSOUND_DEFAULT, IniFile);
    AppButton.NoSound = ONEORZERO(itemp);

    return AppButton;
    }

/*--------------------------------------------------------------------------*/
VOID WINAPI SaveSystemIni(APPSYSTEM AppSystem)
    {
    char SaveString[MAXDIGITS];

    wvsprintf(SaveString,"%d",&AppSystem.Left);
    WritePrivateProfileString(INI_SYSTEM, LEFT, SaveString, INI_FILE);

    wvsprintf(SaveString,"%d",&AppSystem.Top);
    WritePrivateProfileString(INI_SYSTEM, TOP, SaveString, INI_FILE);

    wvsprintf(SaveString,"%d",&AppSystem.Columns);
    WritePrivateProfileString(INI_SYSTEM, COLUMNS, SaveString, INI_FILE);

    wvsprintf(SaveString,"%d",&AppSystem.Border);
    WritePrivateProfileString(INI_SYSTEM, BORDER, SaveString, INI_FILE);

    wvsprintf(SaveString,"%d",&AppSystem.Buttons);
    WritePrivateProfileString(INI_SYSTEM, BUTTONS, SaveString, INI_FILE);

    wvsprintf(SaveString,"%d",&AppSystem.CloseAll);
    WritePrivateProfileString(INI_SYSTEM, CLOSEALL, SaveString, INI_FILE);

    wvsprintf(SaveString,"%d",&AppSystem.StayInFront);
    WritePrivateProfileString(INI_SYSTEM, STAYINFRONT, SaveString, INI_FILE);

    wvsprintf(SaveString,"%d",&AppSystem.DoubleClick);
    WritePrivateProfileString(INI_SYSTEM, DOUBLECLICK, SaveString, INI_FILE);

    wvsprintf(SaveString,"%d",&AppSystem.BigButtons);
    WritePrivateProfileString(INI_SYSTEM, BIGBUTTONS, SaveString, INI_FILE);

    WritePrivateProfileString(INI_SHELL, SHELLGROUP, AppSystem.ShellGroup, INI_FILE);
    }

/*--------------------------------------------------------------------------*/
VOID WINAPI SaveSoundIni(APPSOUND AppSound)
    {
    char SaveString[MAXDIGITS];

    wvsprintf(SaveString,"%d",&AppSound.EnableSound);
    WritePrivateProfileString(INI_SOUND, SOUNDENABLE, SaveString, INI_FILE);
    WritePrivateProfileString(INI_SOUND, APPSTART, AppSound.AppBarStart, INI_FILE);
    WritePrivateProfileString(INI_SOUND, APPEXIT, AppSound.AppBarExit, INI_FILE);
    WritePrivateProfileString(INI_SOUND, WINEXIT, AppSound.WindowsExit, INI_FILE);
    WritePrivateProfileString(INI_SOUND, PROGSTART, AppSound.ProgramStart, INI_FILE);
    WritePrivateProfileString(INI_SOUND, PROGCLOSE, AppSound.ProgramClose, INI_FILE);
    WritePrivateProfileString(INI_SOUND, DROPFILE, AppSound.DropFile, INI_FILE);
    WritePrivateProfileString(INI_SOUND, ERRORMESSAGE, AppSound.ErrorMessage, INI_FILE);
    WritePrivateProfileString(INI_SOUND, SOUNDDIR, AppSound.SoundDirectory, INI_FILE);
    }

/*--------------------------------------------------------------------------*/
VOID WINAPI SaveButtonIni(APPBARBUTTONS AppButton, int i, LPSTR SectionName, LPSTR IniFile)
    {
    char SaveString[MAXDIGITS], IniString[20];
    int j;

    j= i+1;
    wvsprintf(IniString,"Icon%d",&j);
    WritePrivateProfileString(SectionName, IniString, AppButton.IcoName, IniFile);

    wvsprintf(IniString,"Prog%d",&j);
    WritePrivateProfileString(SectionName, IniString, AppButton.ProgName, IniFile);

    wvsprintf(IniString,"Dir%d",&j);
    WritePrivateProfileString(SectionName, IniString, AppButton.StartDir, IniFile);

    wvsprintf(IniString,"Params%d",&j);
    WritePrivateProfileString(SectionName, IniString, AppButton.Params, IniFile);

    wvsprintf(IniString,"Close%d",&j);
    wvsprintf(SaveString,"%d",&AppButton.Close);
    WritePrivateProfileString(SectionName, IniString, SaveString, IniFile);

    wvsprintf(IniString,"ShowMode%d",&j);
    wvsprintf(SaveString,"%d",&AppButton.ShowMode);
    WritePrivateProfileString(SectionName, IniString, SaveString, IniFile);

    wvsprintf(IniString,"IconNumber%d",&j);
    wvsprintf(SaveString,"%d",&AppButton.IconNumber);
    WritePrivateProfileString(SectionName, IniString, SaveString, IniFile);

    wvsprintf(IniString,"ButtonLook%d",&j);
    wvsprintf(SaveString,"%d",&AppButton.ButtonLook);
    WritePrivateProfileString(SectionName, IniString, SaveString, IniFile);

    wvsprintf(IniString,"NoSound%d",&j);
    wvsprintf(SaveString,"%d",&AppButton.NoSound);
    WritePrivateProfileString(SectionName, IniString, SaveString, IniFile);
    }

/*--------------------------------------------------------------------------*/
APPBARBUTTONS WINAPI InitButton(VOID)
    {
    APPBARBUTTONS AppButtonDefault;

    lstrcpy(AppButtonDefault.IcoName, "");
    lstrcpy(AppButtonDefault.ProgName, "");
    lstrcpy(AppButtonDefault.Params, "");
    lstrcpy(AppButtonDefault.StartDir, "");
    AppButtonDefault.IconNumber = 0;
    AppButtonDefault.ButtonLook = 0;
    AppButtonDefault.Close = 1;
    AppButtonDefault.ShowMode = 0;
    AppButtonDefault.hWndApp = NULL;
    AppButtonDefault.NoSound = 0;
    AppButtonDefault.ProgStatus = 0;

    return AppButtonDefault;
    }

/*--------------------------------------------------------------------------*/
VOID WINAPI ExecuteErrorHandle(int iError, char *szError)
    {
    char szBuffer[256];

    switch(iError)
	{
	case 0:
	    lstrcpy(szBuffer,"Out of memory.");
	    break;

	case 2:
	    wvsprintf(szBuffer,"File %s not found.", szError);
	    break;

	case 3:
	    wvsprintf(szBuffer,"Path %s not found.", szError);
	    break;

	case 5:
	    lstrcpy(szBuffer,"Attempt to dynamically link to a task.");
	    break;

	case 6:
	    lstrcpy(szBuffer,"Library requires separate data segments\nfor each task.");
	    break;

	case 8:
	    wvsprintf(szBuffer,"Not enough memory to start %s.", szError);
	    break;

	case 10:
	    lstrcpy(szBuffer,"Incorrect Windows version.");
	    break;

	case 11:
	    lstrcpy(szBuffer,"Invalid .EXE file.");
	    break;

	case 12:
	    wvsprintf(szBuffer,"%s is an OS/2 application.", szError);
	    break;

	case 13:
	    wvsprintf(szBuffer,"%s is a DOS 4.0 application.", szError);
	    break;

	case 14:
	    wvsprintf(szBuffer,"%s has an unknown .EXE type.", szError);
	    break;

	case 15:
	    lstrcpy(szBuffer,"Attempt to load a Windows 2.x .EXE in protected mode.");
	    break;

	case 16:
	    lstrcpy(szBuffer,"Attempt to load a 2nd instance of\nan .EXE with writeable data.");
	    break;

	case 17:
	    lstrcpy(szBuffer,"Attempt to link a DLL in large-frame EMS mode.");
	    break;

	case 19:
	    lstrcpy(szBuffer,"Attempt to load compressed .EXE file.");
	    break;

	case 20:
	    lstrcpy(szBuffer,"Invalid DLL file.");
	    break;

	default:
	    wvsprintf(szBuffer,"Unknown File Execution Error (%d)",&iError);
	    break;
	}
	MessageBeep(0);
	MessageBox(NULL, szBuffer, "AppBar - File Execution", MB_OK);
    }

/*--------------------------------------------------------------------------*/
VOID WINAPI ReadRunLoadIni(LPSTR szRun, LPSTR szLoad)
    {
    char szBuffer[256];

    GetProfileString("windows", "load", "  ", szBuffer, 255);
    lstrcpy(szLoad, szBuffer);
    GetProfileString("windows", "run", "  ", szBuffer, 255);
    lstrcpy(szRun, szBuffer);
    }

/*--------------------------------------------------------------------------*/
VOID WINAPI SaveRunLoadIni(LPSTR szRun, LPSTR szLoad)
    {
    WriteProfileString("windows","load",szLoad);
    WriteProfileString("windows","run",szRun);
    }


/*--------------------------------------------------------------------------*/
LONG WINAPI WaitForWMCloseWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
    {
    LRESULT  lRet;

    lRet = CallWindowProc((WNDPROC)lpfnOrgCloseWndProc, hWnd, message, wParam, lParam);
    if(message == WM_CLOSE)
	{
	if(IsWindow (hWnd))
	    SetWindowLong(hWnd, GWL_WNDPROC, (WPARAM) lpfnOrgCloseWndProc);
        fWMCloseSeen = TRUE;
	}
    return lRet;
    }

/*------------------------------------------------------------------------*/
VOID WINAPI WaitForWMClose(HWND hWndClose, HINSTANCE hInst)
    {
    static FARPROC  lpfnMy = NULL;
    MSG msg;

    if(lpfnMy == NULL)
	{
	lpfnMy = MakeProcInstance((FARPROC) WaitForWMCloseWndProc, hInst);
        if (lpfnMy == NULL)
            return;
	}
    lpfnOrgCloseWndProc = (FARPROC) GetWindowLong(hWndClose, GWL_WNDPROC);
    SetWindowLong(hWndClose, GWL_WNDPROC, (WPARAM) lpfnMy);
    fWMCloseSeen = FALSE;

    //  This is a MUST here. We need to keep messages flowing around while
    //  we're waiting a program to make up his mind with this close thing.
    do	{
	if(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
	    {
	    TranslateMessage(&msg);
	    DispatchMessage(&msg);
	    }
	}
    while(!fWMCloseSeen);

    // We've just seen WM_DESTROY let the app to clean up
    // himself completely before we go on.
    Yield();
    FreeProcInstance((FARPROC)lpfnMy);
    }

/*-------------------------------------------------------------------------*/
BOOL WINAPI CloseApp(HWND hWndClose, HINSTANCE hInst)
    {
    PostMessage(hWndClose, WM_CLOSE, 0, 0L);
    WaitForWMClose(hWndClose, hInst);
    //if windows is still there, application refused to die.
    if(IsWindow(hWndClose))
	return FALSE;
    return TRUE;
    }
