#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <shellapi.h>
#include <commdlg.h>
#include <io.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <direct.h>
#include <string.h>
#include <ctl3d.h>
#include "appbar.h"

/*----------------------------------------------------------------------------*/
/* FUNCTION: OkMsgBox(char *szCaption, char *szFormat, ...)		     */
/*                                                                            */
/* PURPOSE:  Display in an OKmessageBox a given text				       */
/*----------------------------------------------------------------------------*/
VOID OkMsgBox(char *szCaption, char *szFormat, ...)
    {
    char *pArguments;

    pArguments = (char *) &szFormat + sizeof(szFormat);
    vsprintf(szBuffer, szFormat, pArguments);
    if(AppSound.EnableSound != 0)
	if(stricmp(AppSound.ErrorMessage, "<none>") != 0)
	    sndPlaySound(AppSound.ErrorMessage, SND_ASYNC | SND_NODEFAULT);
    MessageBox(NULL, szBuffer, szCaption, MB_OK);
    }

/*----------------------------------------------------------------------------*/
/* FUNCTION: ErrorMsgBox(char *szCaption, char *szFormat, ...)		     */
/*                                                                            */
/* PURPOSE:  Display in an ErrormessageBox a given text				       */
/*----------------------------------------------------------------------------*/
VOID ErrorMsgBox(char *szCaption, char *szFormat, ...)
    {
    char *pArguments;

    pArguments = (char *) &szFormat + sizeof(szFormat);
    vsprintf(szBuffer, szFormat, pArguments);
    if(AppSound.EnableSound != 0)
	if(stricmp(AppSound.ErrorMessage, "<none>") != 0)
	    sndPlaySound(AppSound.ErrorMessage, SND_ASYNC | SND_NODEFAULT);
    MessageBox(NULL, szBuffer, szCaption, MB_OK | MB_ICONEXCLAMATION);
    }

/*----------------------------------------------------------------------------*/
/* FUNCTION: IniRead(void)						      */
/*                                                                            */
/* PURPOSE:  Read settings in the appbar.ini file.			      */
/*----------------------------------------------------------------------------*/
VOID PASCAL IniRead(VOID)
    {
    int i;

    // set settings of AppEmptyButton
    AppEmptyButton = InitButton();

    AppSystem = ReadSystemIni();
    AppSound = ReadSoundIni();

    if(AppSystem.Border < 3)
	AppSystem.Border = 0;

    if(AppSystem.Top > GetSystemMetrics(SM_CYSCREEN))
	AppSystem.Top = -1;

    if(AppSystem.Left > GetSystemMetrics(SM_CXSCREEN))
	AppSystem.Left = -1;

    for(i=0;i<AppSystem.Buttons;i++)
	{
	AppButton[i] = ReadButtonIni(i, (LPSTR) INI_BUTTON, (LPSTR) INI_FILE);
	AppButton[i].hWndApp = NULL;
	if(AppSystem.CloseAll == 0)
	    AppButton[i].Close = FALSE;
	AppButton[i].ProgStatus = NOTALIVE; // no app exists yet
	}
    }

/*--------------------------------------------------------------------------*/
APPMAXSIZE CalculateAppMaxSize(VOID)
    {
    int xScreen, yScreen, xAppBar, yAppBar, Rows;
    DWORD xMax = 0, yMax = 0;
    APPMAXSIZE AppBarSize, AppSizeX, AppSizeY;

   xScreen = GetSystemMetrics(SM_CXSCREEN);
   yScreen = GetSystemMetrics(SM_CYSCREEN);
   if(AppSystem.Left == -1)
	xAppBar = xScreen - (AppWindow.cxButton+AppSystem.Border)*AppWindow.nColumns - AppSystem.Border;
    else
	xAppBar = AppSystem.Left;
    if(AppSystem.Top == -1)
	yAppBar = 0;
    else
	yAppBar = AppSystem.Top;

    // calculate the size of AppBar.
    Rows = AppWindow.nButtons/AppWindow.nColumns;
    AppBarSize.width = AppWindow.cxButton*AppWindow.nColumns;
    AppBarSize.width += (AppWindow.nColumns+1)*AppSystem.Border;
    AppBarSize.height = AppWindow.cyButton*Rows + (Rows+1)*AppSystem.Border;
    AppBarSize.left = xAppBar;
    AppBarSize.top = yAppBar;

    // determine largest left space in X direction
    if(AppBarSize.left >= (xScreen -(AppBarSize.left+AppBarSize.width)))
	{
	// largest x-space is to the left of AppBar
	xMax = AppBarSize.left;
	AppSizeX.left = 0;
	AppSizeX.top = 0;
	AppSizeX.width = AppBarSize.left;
	AppSizeX.height = yScreen;
	}
    else
	{
	// largest x-space is to the right of AppBar
	xMax = (xScreen -(AppBarSize.left+AppBarSize.width));
	AppSizeX.left = AppBarSize.left + AppBarSize.width;
	AppSizeX.top = 0;
	AppSizeX.width = xScreen -(AppBarSize.left+AppBarSize.width);
	AppSizeX.height = yScreen;
	}
    if(AppBarSize.top >= (yScreen -(AppBarSize.top+AppBarSize.height)))
	{
	// largest y-space is above AppBar
	yMax = AppBarSize.top;
	AppSizeY.left = 0;
	AppSizeY.top = 0;
	AppSizeY.width = xScreen;
	AppSizeY.height = AppBarSize.top;
	}
    else
	{
	// largest y-space is under AppBar
	yMax = (yScreen -(AppBarSize.top+AppBarSize.height));
	AppSizeY.left = 0;
	AppSizeY.top = AppBarSize.top + AppBarSize.height;
	AppSizeY.width = xScreen;
	AppSizeY.height = yScreen - (AppBarSize.top+AppBarSize.height);
	}

    xMax *= yScreen;
    yMax *= xScreen;
    if(xMax >= yMax)
	return AppSizeX;
    else
	return AppSizeY;
    }

/*-------------------------------------------------------------------------*/
VOID SetNormalChildCursor(VOID)
    {
    SetClassWord(hWndButton[0], GCW_HCURSOR,
		 (WPARAM) LoadCursor(NULL, IDC_ARROW));
    }

/*-------------------------------------------------------------------------*/
VOID SetShuffleChildCursor(VOID)
    {
    SetClassWord(hWndButton[0], GCW_HCURSOR,
		 (WPARAM) LoadCursor(hInst, "AppShuffle"));
    }

/*-------------------------------------------------------------------------*/
void InitTip(void)
    {
    int i;

    // if Tip.exe is used on AppBar, launch it to initialize it.
    for(i=0;i<AppSystem.Buttons;i++)
	{
	if(strstr((char *)AnsiLower((LPSTR)AppButton[i].ProgName), "tip.exe") != NULL)
	    ShellExecute(hWndMain, "open", AppButton[i].ProgName, "/setup", NULL, SW_SHOWNORMAL);
	}
    }

/*-------------------------------------------------------------------------*/
BOOL IsAppTip(int AppNumber)
    {
    // if App[AppNumber] is Tip.exe, then return TRUE.
    if(strstr((char *)AnsiLower((LPSTR)AppButton[AppNumber].ProgName), "tip.exe") != NULL)
	return TRUE;
    else
	return FALSE;
    }

/*-------------------------------------------------------------------------*/
void TipSetIcon(WORD iIcon, HICON *hIcon)
    {
    int i;

    for(i=0;i<AppSystem.Buttons;i++)
	{
	if(strstr((char *)AnsiLower((LPSTR)AppButton[i].ProgName), "tip.exe") != NULL)
	    {
	    hIcon[i] = ExtractIcon(hInst, AppButton[i].ProgName,iIcon);
	    if(hIcon[i] == (HICON) 1)
		hIcon[i] = NULL;
	    InvalidateRect(hWndButton[i+FirstAppButton], NULL, FALSE);
	    UpdateWindow(hWndButton[i+FirstAppButton]);
	    }
	}
    }

/*-------------------------------------------------------------------------*/
void LoadAllButtonIcons(HICON *hIcon)
    {
    int i;

    for(i=0;i<AppSystem.Buttons;i++)
	{
	hIcon[i] = ExtractIcon(hInst, AppButton[i].IcoName, AppButton[i].IconNumber);
	if(hIcon[i] == (HICON) 1)
	    {
	    hIcon[i] = NULL;
	    OkMsgBox("AppBar - Initialisation", "No Icons found in %s", AppButton[i].IcoName);
	    }
	}
    }

/*-------------------------------------------------------------------------*/
void LoadAppBarResources(void)
    {
    hQuickLoad = LoadIcon(hInst, MAKEINTRESOURCE(1004));

    if(!AppSystem.BigButtons)
	{
	hSystem	   = LoadIcon(hInst, MAKEINTRESOURCE(1000));
	hPressed   = LoadIcon(hInst, MAKEINTRESOURCE(1002));
	hBlank	   = LoadIcon(hInst, MAKEINTRESOURCE(1003));
	hKeybOn	   = LoadIcon(hInst, MAKEINTRESOURCE(1005));
	}

    if(AppSystem.BigButtons)
	{
	hSystem2  = LoadIcon(hInst, MAKEINTRESOURCE(1008));
	hPressed2 = LoadIcon(hInst, MAKEINTRESOURCE(1007));
	hbBlank   = LoadBitmap(hInst, "BlankBMP");
	hbKeyb	  = LoadBitmap(hInst, "KeybBMP");
	hbPressed = LoadBitmap(hInst, "PressBMP");
	}
    }

/*-------------------------------------------------------------------------*/
void FreeAppBarResources(void)
    {
    if(AppSystem.BigButtons)
	{

		DeleteBitmap(hbBlank);
	DeleteBitmap(hbKeyb);
	DeleteBitmap(hbPressed);
	}
    }

/*--------------------------------------------------------------------------*/
BOOL IsAppBarShell(VOID)
    {
    char ShellString[MAXFILECHARS];

    GetPrivateProfileString("boot", "shell", "  ", ShellString, MAXFILECHARS-1, "system.ini");
    if(strstr((char *) AnsiLower((char FAR *)ShellString),"appbar.exe"))
	return TRUE;
    else
	return FALSE;
    }
