/*-------------------------------------------------------------------------
 appmore.c

 a multiple launch utility for AppBar

 by
 GMP van kempen
 NEVERnever Software 1992

 History:
    1.0     first try. Removed IsDosExe(), rely on IsDosWindow() now. Fixed
	    bug with auto-bounceback. Removed AppMore Start & Exit sounds.
	    Added SystemMenu with About/Close/Cancel/Setup/QuickLoad/Minimize
	    buttons and functions. Changed default screen place.
    4.00.1  Updated to the AppBar 4.00 family.

---------------------------------------------------------------------------*/
//compile with the strictest error checking
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <shellapi.h>
#include <string.h>
#include <stdio.h>
#include <ctl3d.h>
#include <memory.h>
#include "appmore.h"

#define MAKECHILD(a,b,c,d,e,f,g,h) CreateWindow(a,b,WS_CHILD | WS_VISIBLE | c,d,e,f,g,hWnd,h,hInst,(LPSTR) NULL)
#define MAKEBUTTON(a,b,c,d,e,f)	   MAKECHILD("button",a,BS_PUSHBUTTON | BS_OWNERDRAW,b,c,d,e,f)
#define MAKESTATIC(a,b,c,d)	   MAKECHILD("static",NULL,SS_BLACKRECT,a,b,c,d,(HMENU)-1)
#define MAKEBORDER(a,b,c,d)	   MAKECHILD("static",NULL,SS_WHITERECT,a,b,c,d,(HMENU) -1)

APPBARBUTTONS	 AppButton[MAXAPPS], AppButtonDefault;
APPSYSTEM	 AppSystem;
APPSOUND	 AppSound;
APPWINDOW	 AppWindow = {1, MAXAPPS, 32, 32};
APPMAXSIZE	 AppMaxSize;
char		 szAppName[] = "AppMore", szTitleName[] = "AppMore 4.0";
char		 szSectionName[256];
int		 iCurrent = 0, iActive = 0, iKey = 1;
int		 cxChar, cyChar, iShuffledButton, FirstAppButton = 1;
HWND		 hWndMain, hWndButton[MAXAPPS], hWndCurrentButton;
HINSTANCE	 hInst;
HBITMAP		 hAppLogo, hNNever, hbBlank, hbKeyb;
HBITMAP 	 hbPressed;
HICON		 hSystem, hBlank, hPressed, hQuickLoad, hKeybOn;
HICON		 hPressed2, hSystem2;
BOOL		 bFirst = TRUE;
BOOL		 bQuickLoad = FALSE, bMoveButton = FALSE;
BOOL		 bButtonMoved = FALSE;
LPDRAWITEMSTRUCT lpIconDIS;
BOOL		 bKeyboardOn = FALSE, bExecuteProg = TRUE, bShuffleButton = FALSE;
short		 Rows, xSize, ySize;


int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
		   LPSTR lpszCmdLine, int nCmdShow)
    {
    HWND	hWnd;
    MSG 	msg;
    WNDCLASS	wndclass;
    short	xScreen, yScreen;

    lstrcpy(szSectionName, lpszCmdLine);
    AppSystem.SectionNumber = VerifySectionName(szSectionName);
    InitDefaultButton();
    IniRead();
    if(AppSystem.SectionNumber == 0)
	{
	AppSystem.Buttons = 0;
	AppSystem.Columns = 1;
	}

    if(!hPrevInstance)
	{
	wndclass.style		    = CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc	    = WndProc;
	wndclass.cbClsExtra	    = 0;
	wndclass.cbWndExtra	    = 0;
	wndclass.hInstance	    = hInstance;
	wndclass.hIcon		    = LoadIcon(NULL, MAKEINTRESOURCE(1000));
	wndclass.hCursor	    = LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground	    = GetStockBrush(LTGRAY_BRUSH);
	wndclass.lpszMenuName	    = NULL;
	wndclass.lpszClassName	    = szAppName;

	RegisterClass(&wndclass);
	}

    SetCursor(LoadCursor(NULL, IDC_WAIT));
    hInst = hInstance;

    Ctl3dRegister(hInst);
    Ctl3dAutoSubclass(hInst);

    // add the SystemButton.
    AppWindow.nButtons = AppSystem.Buttons+1;
    AppWindow.nColumns = AppSystem.Columns;

    // try to add enough buttons to fill all the columns
    while(AppWindow.nButtons % AppWindow.nColumns)
	{
	AppWindow.nButtons++;
	if(AppWindow.nButtons > MAXAPPS)
	    break;
	}
    if(AppWindow.nButtons % AppWindow.nColumns)
	{
	AppWindow.nButtons = AppSystem.Buttons+1;
	AppWindow.nColumns = 1;
	}

    AppMaxSize = CalculateAppMaxSize();

    if(AppSystem.Left == -1)
	xScreen = GetSystemMetrics(SM_CXSCREEN) - (AppWindow.cxButton*(AppWindow.nColumns+1));
    else
	xScreen = AppSystem.Left;
    if(AppSystem.Top == -1)
	yScreen = GetSystemMetrics(SM_CYSCREEN) - (AppWindow.cyButton*(AppWindow.nButtons/AppWindow.nColumns));
    else
	yScreen = AppSystem.Top;


    if(AppSystem.SectionNumber == 0)
	AppWindow.nButtons = 0;

    AppSystem.Border = 0;
    Rows = AppWindow.nButtons/AppWindow.nColumns;
    xSize = AppWindow.cxButton*AppWindow.nColumns;
    xSize += (AppWindow.nColumns+1)*AppSystem.Border;
    ySize = AppWindow.cyButton*Rows + (Rows+1)*AppSystem.Border;

    hWnd = CreateWindow(szAppName, szTitleName,
			WS_POPUP | WS_VISIBLE,
			xScreen, yScreen, xSize, ySize,
			NULL, NULL, hInstance,NULL);

    hWndMain = hWnd;
    SetTimer(hWnd, ID_TIMER, 1000, NULL);

    LoadAppMoreResources();

    strcpy(szBuffer, szTitleName);
    strcat(szBuffer, " - ");
    strcat(szBuffer, szSectionName);
    SetWindowText(hWnd, szBuffer);

    SetCursor(LoadCursor(NULL, IDC_ARROW));

    ShowWindow(hWnd, SW_SHOWNORMAL);
    UpdateWindow(hWnd);

    while(GetMessage(&msg, NULL, 0, 0))
	{
	TranslateMessage(&msg);
	DispatchMessage(&msg);
	}

    Ctl3dUnregister(hInst);
    return msg.wParam;
    } /* end WinMain */

/*------------------------------------------------------------------------/
   FUNCTION: WndProc()
/------------------------------------------------------------------------*/
long WINAPI WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
    {
    static DLGPROC lpfnSystemDlgProc, lpfnAboutDlgProc;
    static HICON   hIcon[MAXAPPS];
    char	   szDropFile[MAXFILECHARS], SystemSection[256];
    TEXTMETRIC	   tm;
    POINT	   DropPoint;
    int 	   i, iDropButton = 0, iDropped;
    HBRUSH	   hbrush;
    UINT	   DroppedFiles;
    int 	   xPos, yPos;

    switch (message)
	{
	case WM_CREATE:
	    tm = RetrieveTextMetrics(hWnd);
	    cxChar = tm.tmAveCharWidth;
	    cyChar = tm.tmHeight;
	    if(AppSystem.SectionNumber == 0)
		{
		AppWindow.nButtons = 0;
		hAppLogo = LoadBitmap(hInst, "AppLogo");
		hNNever = LoadBitmap(hInst, "NNever");
		lpfnAboutDlgProc = (DLGPROC) MakeProcInstance((FARPROC)AboutDlgProc, hInst);
		DialogBox(hInst, "AboutDlg", hWnd, lpfnAboutDlgProc);
		FreeProcInstance((FARPROC)lpfnAboutDlgProc);
		KillTimer(hWnd, ID_TIMER);
		DeleteBitmap(hAppLogo);
		DeleteBitmap(hNNever);
		PostQuitMessage(0);
		}
	    LoadAllButtonIcons(hIcon);
	    if(AppSystem.Border)
		Ctl3dSubclassCtl(MAKEBORDER(0, 0, xSize, ySize));
	    for(i=0;i<AppWindow.nButtons;i++)
		{
		xPos=AppSystem.Border+(AppSystem.Border+AppWindow.cxButton)*(i/(AppWindow.nButtons/AppWindow.nColumns));
		yPos=AppSystem.Border+(AppSystem.Border+AppWindow.cyButton)*(i%(AppWindow.nButtons/AppWindow.nColumns));
		if(AppSystem.Border)
		    Ctl3dSubclassCtl(MAKESTATIC(xPos-1, yPos-1,
				AppWindow.cxButton+2, AppWindow.cyButton+2));
		hWndButton[i] = MAKEBUTTON(NULL, xPos, yPos,
				AppWindow.cxButton, AppWindow.cyButton,
				ID_BUTTON1+i);
		}
	    SetNormalChildCursor();
	    DragAcceptFiles(hWnd, TRUE);
	    return 0;

	case WM_SYSCOLORCHANGE:
	    Ctl3dColorChange();
	    return 0;

	case WM_CTLCOLOR:
	    hbrush = Ctl3dCtlColorEx(message, wParam, lParam);
	    if(hbrush != (HBRUSH) FALSE)
		return hbrush;
	    else
		return DefWindowProc(hWnd, message, wParam, lParam);

	case WM_SYSCHAR:
	case WM_SYSKEYUP:
	    return 0;

	case WM_SYSKEYDOWN:
	    return ProcessSystemKeys((int) wParam);

	case WM_KEYDOWN:
	    return KeyboardInterface((int)wParam);

	case WM_DRAWITEM:
	    lpIconDIS = (LPDRAWITEMSTRUCT) lParam;
	    iCurrent = (int) (lpIconDIS->CtlID - ID_BUTTON1);
	    hWndCurrentButton = lpIconDIS->hwndItem;
	    if(iCurrent == SYSTEM_MENU)
		{
		DrawIcon(lpIconDIS->hDC, 0, 0, hSystem);
		if(bQuickLoad)
		    DrawIcon(lpIconDIS->hDC, 0, 0, hQuickLoad);
		}
	    if(iCurrent >= FIRST_APPLICATION)
		{
		if(hIcon[iCurrent-1] != NULL)
		    {
		    if(AppButton[iCurrent-1].ButtonLook)
			DrawIcon(lpIconDIS->hDC, 0, 0, hBlank);
		    DrawIcon(lpIconDIS->hDC, 0, 0, hIcon[iCurrent-1]);
		    }
		else
		    DrawIcon(lpIconDIS->hDC, 0, 0, hBlank);
		if(AppButton[iCurrent-1].ProgStatus == ALIVE)
		    DrawIcon(lpIconDIS->hDC, 0, 0, hPressed);
		}
	    break;

	case WM_TIMER:
	    CheckProgStatus();
	    if(AppSystem.StayInFront == 1)
		if(GetActiveWindow() != hWnd)
		    SetWindowPos(hWnd, NULL, 0, 0, 0, 0,
				  SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE);
	    return 0;

	case WM_COMMAND:
	     // If a button was clicked, then it is the currently selected tool.
	    if((HIWORD(lParam) == BN_CLICKED && AppSystem.DoubleClick == 0) || (HIWORD(lParam) == BN_DOUBLECLICKED && AppSystem.DoubleClick == 1))
		{
		if((wParam >= (UINT) ID_BUTTON1) && (wParam <= (UINT) (ID_BUTTON1 + AppWindow.nButtons)))
		    {
		    iCurrent = 0;
		    while((ID_BUTTON1 + iCurrent) != (int) wParam)
			iCurrent++; // just increment i !!
		    if(iCurrent == SYSTEM_MENU)
			{
			lpfnSystemDlgProc = (DLGPROC) MakeProcInstance((FARPROC)SystemDlgProc, hInst);
			DialogBox(hInst, "SystemDlg", hWnd, lpfnSystemDlgProc);
			FreeProcInstance( (FARPROC) lpfnSystemDlgProc);
			break;
			}
		    if(iCurrent >= FIRST_APPLICATION)
			{
			if(!bQuickLoad)
			    {
			    CheckProgStatus();
			    StartOrCloseProgram(iCurrent-1); // start and close programs linked to a button.
			    }
			else
			    {
			    if(bShuffleButton)
				{
				bShuffleButton = FALSE;
				SetNormalChildCursor();
				AppButton[iCurrent-1] = AppButton[iShuffledButton-1];
				hIcon[iCurrent-1] = hIcon[iShuffledButton-1];
				SaveButton(iCurrent-1);
				InvalidateRect(hWndButton[iCurrent], NULL, TRUE);
				InvalidateRect(hWndButton[iShuffledButton], NULL, TRUE);
				UpdateWindow(hWnd);
				}
			    else
				{
				bShuffleButton = TRUE;
				SetShuffleChildCursor();
				iShuffledButton = iCurrent;
				}
			    }
			}
		    }
		}
	    break;   /* end WM_COMMAND */

       case WM_DROPFILES:
	    if(AppSound.EnableSound != 0)
		if(stricmp(AppSound.DropFile, "<none>") != 0)
		    sndPlaySound(AppSound.DropFile, SND_ASYNC | SND_NODEFAULT);
	    DragQueryPoint((HANDLE) wParam, (LPPOINT) &DropPoint);
	    iDropButton = (DropPoint.y/AppWindow.cyButton);
	    iDropButton += (AppWindow.nButtons/AppWindow.nColumns)*(DropPoint.x/AppWindow.cxButton);
	    DroppedFiles = DragQueryFile((HANDLE) wParam, 0xFFFF, (LPSTR) NULL, 0);
	    if(!bQuickLoad)
		{
		if(iDropButton-1 >= 0)
		    {
		    for(i=0;i<DroppedFiles;i++)
			{
			DragQueryFile((HANDLE) wParam, i, szDropFile, sizeof(szDropFile));
			// add szDropfile to existing parameters.
			strcpy(szBuffer, AppButton[iDropButton-1].Params);
			strcat(szBuffer, " ");
			strcat(szBuffer, szDropFile);
			ProgExec(hWnd, AppButton[iDropButton-1].ProgName, szBuffer, AppButton[iDropButton-1].StartDir, AppButton[iDropButton-1].ShowMode);
			}
		    }
		else
		    {
		    for(i=0;i<DroppedFiles;i++)
			{
			DragQueryFile((HANDLE) wParam, i, szDropFile, sizeof(szDropFile));
			ShellExecute(hWnd, "open", szDropFile, NULL, NULL, SW_SHOWNORMAL);
			}
		    }
		}
	    if(bQuickLoad)
		{
		if(iDropButton-1 >= 0)
		    {
		    iDropped = iDropButton-1;
		    AppButton[iDropped] = AppButtonDefault;
		    DragQueryFile((HANDLE) wParam, 0, szDropFile, sizeof(szDropFile));
		    strcpy(AppButton[iDropped].IcoName, szDropFile);
		    strcpy(AppButton[iDropped].ProgName, szDropFile);
		    SaveButton(iDropped);
		    DestroyIcon(hIcon[iDropped]);
		    hIcon[iDropped] = ExtractIcon(hInst, AppButton[iDropped].IcoName, AppButton[iDropped].IconNumber);
		    if(hIcon[iDropped] == (HICON) 1)
			hIcon[iDropped] = NULL;
		    InvalidateRect(hWndButton[iDropButton], NULL, FALSE);
		    UpdateWindow(hWndButton[iDropButton]);
		    }
		}
	    DragFinish((HANDLE) wParam);
	    return 0;

	case WM_LBUTTONDOWN:	// Allows moving of a whole window
	    SetCursor(LoadCursor(NULL, IDC_SIZE));
	    bMoveButton = TRUE;
	    return(DefWindowProc(hWnd, WM_NCLBUTTONDOWN, HTCAPTION, lParam));

	case WM_MOVE:
	    if(bMoveButton)
		{
		bMoveButton = FALSE;
		if(MessageBox(NULL,"Save AppMore's new position",szTitleName,MB_YESNO) ==IDYES)
		    {
		    /* horizontal position */
		    AppSystem.Left = (int) LOWORD(lParam);
		    /* vertical position */
		    AppSystem.Top = (int) HIWORD(lParam);
		    strcpy(SystemSection, AppSystem.SectionName);
		    strcat(SystemSection, "_System");
		    sprintf(szBuffer,"%d", AppSystem.Left);
		    WritePrivateProfileString(SystemSection, LEFT, szBuffer, INI_FILE);
		    sprintf(szBuffer,"%d", AppSystem.Top);
		    WritePrivateProfileString(SystemSection, TOP, szBuffer, INI_FILE);
		    }
		}
	    return 0;

	case WM_ACTIVATEAPP:
	    if(wParam == 0)
		if(GetActiveWindow() != NULL)
		    if(iActive != 0)
			{
			AppButton[iActive-1].hWndApp = GetActiveWindow();
			if(AppButton[iActive-1].ShowMode == 3)
			    SetWindowPos(AppButton[iActive-1].hWndApp,
					 NULL,
					 AppMaxSize.left,
					 AppMaxSize.top,
					 AppMaxSize.width,
					 AppMaxSize.height,
					 SWP_NOACTIVATE | SWP_NOZORDER);
			if(AppButton[iActive-1].Close)
			    AppButton[iActive-1].Close = !IsDosWindow(AppButton[iActive-1].hWndApp);
			if(AppButton[iActive-1].Close)
			    AppButton[iActive-1].ProgStatus = ALIVE;
			else
			    AppButton[iActive-1].ProgStatus = NOTALIVE;
			iActive = 0;
			InvalidateRect(hWndCurrentButton, (LPRECT) NULL, FALSE);
			UpdateWindow(hWndCurrentButton);
			}
	    return 0;

       case WM_DESTROY:	// kill the whole program
	    DragAcceptFiles(hWnd, FALSE);
	    FreeAppMoreResources();
	    KillTimer(hWnd, ID_TIMER);
	    PostQuitMessage(0);
	    return 0;
	}
    return DefWindowProc(hWnd, message, wParam, lParam);
    } /* end WndProc */
