// bardoc.cpp : implementation of the CBarDoc class
//

// (c) Copyright 1994 HEX TECHNOLOGY. All rights reserved.
// This sample code is provided as a example implementation
// using barcodes.dll.  You may only distribute or modify this
// code if you purchase a license for barcodes.dll.


#include "stdafx.h"
#include "bartest.h"

#include "bardoc.h"   
#include "barcodes.h"   

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBarDoc

IMPLEMENT_DYNCREATE(CBarDoc, CDocument)

BEGIN_MESSAGE_MAP(CBarDoc, CDocument)
	//{{AFX_MSG_MAP(CBarDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBarDoc construction/destruction

CBarDoc::CBarDoc()
{
	CString settings("Settings");
	
	m_sData = AfxGetApp()->GetProfileString(settings,"Data","12345678");
	m_sText = AfxGetApp()->GetProfileString(settings,"Text","HEX Technology");
	m_iDisplayFlags = AfxGetApp()->GetProfileInt(settings,"DisplayFlags", (int) ( FLAG_CheckDigit | FLAG_ShowData));
 	m_sFontFace = AfxGetApp()->GetProfileString(settings,"FontFace","Arial");
 	m_bBold = AfxGetApp()->GetProfileInt(settings,"Bold", FALSE);
	m_bItalic = AfxGetApp()->GetProfileInt(settings,"Italic", FALSE);
	m_iRatio = AfxGetApp()->GetProfileInt(settings,"Ratio", 0);
  	m_iFontAdjust = AfxGetApp()->GetProfileInt(settings,"FontAdjust", 0);
 	m_iStyle = AfxGetApp()->GetProfileInt(settings,"Style", 11);  // EAN 8 for starters
    m_iHeight = AfxGetApp()->GetProfileInt(settings,"Height", 21);  // 21 mm
    m_iWidth = AfxGetApp()->GetProfileInt(settings,"Width", 31);  // 31 mm
    m_cBarColor = RGB(0,0,0);				// black bars as normal
	m_cBackgroundColor = RGB(255,255,128);  // light yellow     
	
}

CBarDoc::~CBarDoc()
{ 
	CString settings("Settings");

	AfxGetApp()->WriteProfileString(settings,"Data",m_sData);
	AfxGetApp()->WriteProfileString(settings,"Text",m_sText);
	AfxGetApp()->WriteProfileInt(settings,"Bold", m_bBold);
	AfxGetApp()->WriteProfileInt(settings,"DisplayFlags", m_iDisplayFlags);
	AfxGetApp()->WriteProfileString(settings,"FontFace",m_sFontFace );
 	AfxGetApp()->WriteProfileInt(settings,"Italic", m_bItalic);
	AfxGetApp()->WriteProfileInt(settings,"Ratio", m_iRatio );
 	AfxGetApp()->WriteProfileInt(settings,"FontAdjust", m_iFontAdjust );
 	AfxGetApp()->WriteProfileInt(settings,"Style", m_iStyle );
    AfxGetApp()->WriteProfileInt(settings,"Height", m_iHeight);  
    AfxGetApp()->WriteProfileInt(settings,"Width", m_iWidth ); 
 
}

BOOL CBarDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CBarDoc serialization

void CBarDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		ar << m_sData;
		ar << m_sText;
		ar << m_iDisplayFlags;
		ar << m_sFontFace;
		ar << (BYTE) m_bBold;
		ar << (BYTE) m_bItalic;
		ar << m_cBarColor;
		ar << m_cBackgroundColor;  
		ar << m_iStyle;  
		ar << m_iRatio;
		ar << m_iFontAdjust; 
		ar << m_iWidth;
		ar << m_iHeight;
	}
	else
	{
		ar >> m_sData;
		ar >> m_sText;
		ar >> m_iDisplayFlags;
		ar >> m_sFontFace;            
		BYTE b;
		ar >> b; m_bBold = (BOOL) b;
		ar >> b; m_bItalic = (BOOL) b;
		ar >> m_cBarColor;
		ar >> m_cBackgroundColor;  
		ar >> m_iStyle;  
		ar >> m_iRatio;
		ar >> m_iFontAdjust;
		ar >> m_iWidth;
		ar >> m_iHeight;
	}
}

/////////////////////////////////////////////////////////////////////////////
// CBarDoc diagnostics

#ifdef _DEBUG
void CBarDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CBarDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CBarDoc commands
