// barvw.h : interface of the CBarView class
//
/////////////////////////////////////////////////////////////////////////////
// (c) Copyright 1994 HEX TECHNOLOGY. All rights reserved.
// This sample code is provided as a example implementation
// using barcodes.dll.  You may only distribute or modify this
// code if you purchase a license for barcodes.dll.


class CBarView : public CFormView
{
protected: // create from serialization only
	CBarView();
	DECLARE_DYNCREATE(CBarView)

public:
	//{{AFX_DATA(CBarView)
	enum { IDD = IDD_BARTEST_FORM };
	CButton	m_Preview;
	CString	m_sData;
	CString	m_sText;
	BOOL	m_bBold;
	BOOL	m_bCheck;
	CString	m_sFontFace;
	BOOL	m_bHorizontal;
	BOOL	m_bItalic;
	int		m_iRatio;
	BOOL	m_bShowData;
	BOOL	m_bSwitch;
	int		m_iFontAdjust;
	BOOL	m_bVertical;
	CString	m_sStyle;
	UINT	m_iWidth;
	UINT	m_iHeight;
	BOOL	m_bSpacer;
	//}}AFX_DATA
	BOOL m_bCentreBarcode;
    int m_iStyle;	// we maintain this variable ourselves..
// Attributes
public:


// Operations
public:
   void UpdatePreview();
   void SaveToDoc();
   void RestoreFromDoc(); 
   void OnDataChange();
	CBarDoc* GetDocument(); 
	void SaveStyle();  
	BOOL DrawBarcodePrivate(CDC *pDC,CRect rect);
// Implementation
public:
	virtual ~CBarView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
    virtual void OnUpdate(CView*, LPARAM, CObject*);
	// Printing support
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo*);
    virtual void OnInitialUpdate();
// Generated message map functions
protected:
	//{{AFX_MSG(CBarView)
	afx_msg void OnBackground();
	afx_msg void OnBarcolor();
	afx_msg void OnKillfocus();
	afx_msg void OnClicked();
	afx_msg void OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct);
	afx_msg void OnSelchangeStyle();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in barvw.cpp
inline CBarDoc* CBarView::GetDocument()
   { return (CBarDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
  class CBarFrame : public CMDIChildWnd
{
	DECLARE_DYNCREATE(CBarFrame)
protected:
	CBarFrame();			// protected constructor used by dynamic creation

// Attributes
public:

// Operations
public:
	void Resize();
// Implementation
protected:
	virtual ~CBarFrame();
    virtual BOOL PreCreateWindow(CREATESTRUCT &lpCreateStruct);
	// Generated message map functions
	//{{AFX_MSG(CBarFrame)
 	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
