//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code removes an ACE from a security descriptor.
//***************************************************************

// remvace.cpp

#include <windows.h>
#include <iostream.h>

VOID main(VOID)
{
  BOOL ret;
  LONG err;
  SECURITY_DESCRIPTOR *sdData;
  SECURITY_DESCRIPTOR absSD;
  PSID psid;
  PACL pacl;
  BOOL byDef;
  BOOL haveDACL;
  DWORD sizeRqd;
  SID_NAME_USE sidType;
  DWORD sidSize;
  UINT x;
  ACL_SIZE_INFORMATION aclSize;
  ACCESS_ALLOWED_ACE *pace;
  CHAR str[80];
  DWORD strSize;

  cout << "Removing \"Administrators\" "
    << "from HKEY_CURRENT_USER..."
    << endl;
  
  // ----- Get SID of group to remove -----

  // lookup SID from name
  sidSize=0;
  strSize=80;
  ret=LookupAccountName(NULL, "Administrators", NULL,
    &sidSize, str, &strSize, &sidType);
 
  if (sidSize)
  {
    // allocate memory for SID
    psid=(PSID) GlobalAlloc(GPTR, sidSize);
    // actually get SID
    strSize=80;
    ret=LookupAccountName(NULL, "Administrators",
      psid, &sidSize, str, &strSize, &sidType);
    if (!ret)
    {
      cerr << "Unable to get Administrators SID."
        << endl;
      return;
    }
  }
  else
  {
    cerr << "Administrators SID not available."
      << endl;
    return;
  }

  // ----- Get the existing DACL -----

  // find out how much mem is needed
  // to hold existing SD w/DACL
  sizeRqd=0;
  err=RegGetKeySecurity(HKEY_CURRENT_USER,
    DACL_SECURITY_INFORMATION,
    NULL, &sizeRqd);
  if (err != ERROR_INSUFFICIENT_BUFFER)
  {
    cerr << "Unable to get SD size."
      << endl;
    return;
  }

  // allocate that memory
  sdData=(SECURITY_DESCRIPTOR *)
    GlobalAlloc(GPTR, sizeRqd);
  if (sdData == NULL)
  {
    cerr << "Unable to allocate memory." << endl;
    return;
  }

  // actually get the SD info
  err=RegGetKeySecurity(HKEY_CURRENT_USER,
    DACL_SECURITY_INFORMATION,
    sdData, &sizeRqd);
  if (err != ERROR_SUCCESS)
  {
    cerr << "Unable to get SD info." << endl;
    return;
  }

  // ----- Create a new absolute SD -----

  // initialize absolute SD
  ret=InitializeSecurityDescriptor(&absSD,
    SECURITY_DESCRIPTOR_REVISION);
  if (!ret)
  {
    cerr << "Unable to init new SD."
      << endl;
    return;
  }

  // get the DACL info
  ret=GetSecurityDescriptorDacl(sdData,
    &haveDACL, &pacl, &byDef);
  if (!ret)
  {
    cerr << "Unable to get DACL info." << endl;
    return;
  }

  // ----- Search the DACL and delete ACE -----

  if (!haveDACL)
  {
    cout << "Security Descriptor DACL is NULL."
      << endl;
  }
  else
  {
    // get size info about existing DACL
    ret=GetAclInformation(pacl, &aclSize,
      sizeof(ACL_SIZE_INFORMATION),
      AclSizeInformation);

    // remove Domain Users from DACL
    for (x=aclSize.AceCount; x>0; x--)
    {
      ret=GetAce(pacl, x - 1, (LPVOID *) &pace);
      if (!ret)
      {
        cerr << "Unable to get ACE."
          << endl;
        return;
      }

      ret=EqualSid(&pace->SidStart, psid);
      if (ret)
      {
        cout << "Deleting an ACE..."
          << endl;
        ret=DeleteAce(pacl, x - 1); 
        if (!ret)
        {
          cerr << "Unable to delete ACE."
            << endl;
          return;
        }
      }
    }

  // ----- Add the DACL to absolute SD and install

    // set the new DACL
    // in the absolute SD
    ret=SetSecurityDescriptorDacl(&absSD,
      TRUE, pacl, FALSE);
    if (!ret)
    {
      cerr << "Unable to install DACL."
        << endl;
      return;
    }

    // check the new SD
    ret=IsValidSecurityDescriptor(&absSD);
    if (!ret)
    {
      cerr << "SD invalid."
        << endl;
      return;
    }

    // install the updated SD
    err=RegSetKeySecurity(HKEY_CURRENT_USER,
      DACL_SECURITY_INFORMATION,
      &absSD);
    if (err != ERROR_SUCCESS)
    {
      cerr << "Unable to set registry key SD."
        << endl;
    }

    // ensure that SD has been updated
    RegCloseKey(HKEY_CURRENT_USER);
  }

  // release memory
  if(GlobalFree(psid))
  {
    cerr << "Unable to free memory." << endl;
    return;
  }

  // release memory
  if(GlobalFree(sdData))
  {
    cerr << "Unable to free memory." << endl;
    return;
  }

  cout << "Done." << endl;
}
