//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code demonstrates the GetComputerName, GetKeyboardType, 
// GetSysColor, GetSystemDirectory, GetWindowsDirectory, 
// GetSystemMetrics, GetVersion, and GetUserName functions.
//***************************************************************

// siinfo.cpp

#include <windows.h>
#include <iostream.h>
#include <iomanip.h>


/////////
// needs user32.lib
/////////


void main()
{
	BOOL success;
	int result;
	char s[1000];
	int bufferSize = 1000;
	char computerName[MAX_COMPUTERNAME_LENGTH + 1];
	DWORD computerNameLen = MAX_COMPUTERNAME_LENGTH
		+ 1;

	success = GetComputerName(computerName,
		&computerNameLen);
	if (success)
		cout << "Computer name: " << computerName 
			<< endl;

	cout << "Keyboard type: " << GetKeyboardType(0) 
		<< endl;
	cout << "Keyboard subtype: " 
		<< GetKeyboardType(1) << endl;
	cout << "Number of function keys: " 
		<< GetKeyboardType(2) << endl;

	cout << "Border color: " << hex 
		<< GetSysColor(COLOR_ACTIVEBORDER) << endl;

	result = GetSystemDirectory(s, 1000);
	cout << "System directory: " << s << endl;

	result = GetWindowsDirectory(s, 1000);
	cout << "Windows directory: " << s << endl;
	
	cout << "Number of mouse buttons: " 
		<< GetSystemMetrics(SM_CMOUSEBUTTONS) 
		<< endl;

	DWORD version;
	version = GetVersion();
	if ((version & 0x80000000) == 0)
		cout << "This is NT \n";
	else
		cout << "This is not NT\n";
	cout << "Version number: " 
		<< (version & 0x000000FF) << endl;
	cout << "Revision number: " 
		<< ((version & 0x0000FF00) >> 8) << endl;

	char userName[100];
	DWORD userNameLen = 100;
	success = GetUserName(userName, &userNameLen);
	cout << "User name: " << userName << endl;
}
