// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code demonstrates a stack DLL.
//***************************************************************

// stack.cpp

#include <windows.h>
#include "stack.h"

void init(stack *top)
{
  *top=0;
}

void push(stack *top, int value)
{
  stacknode *temp;

  temp = (stacknode *) GlobalAlloc(GPTR, 
    sizeof stacknode);
  temp->data = value;
  temp->next = *top;
  *top = temp;
}

int pop(stack *top)
{
  stacknode *temp;
  int value;

  if (*top == 0) 
    return 0;
  temp = *top;
  value = (*top)->data;
  *top = (*top)->next;
  delete temp;
  return value;
}

void destroy(stack *top)
{
  while (*top != 0);
    pop(top);
}
