//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code shows how to add a key to the registry.
//***************************************************************

// addkey.cpp

#include <windows.h>
#include <iostream.h>

VOID main(VOID)
{
  LONG ret;
  HKEY keyHandle;
  DWORD disposition;

  // add a key for the new vendor
  ret=RegCreateKeyEx(HKEY_CURRENT_USER,
    "Software\\Interface Technologies",
    0, NULL, REG_OPTION_VOLATILE,
    KEY_ALL_ACCESS, NULL, &keyHandle,
    &disposition);
  if (ret != ERROR_SUCCESS)
  {
    cerr << "Unable to create key"
      << endl;
    return;
  }

  switch (disposition)
  {
    case REG_CREATED_NEW_KEY:
      cout << "New key added to registry."
        << endl;
      break;

    case REG_OPENED_EXISTING_KEY:
      cout << "Existing key opened."
        << endl;
      break;

    default:
      cout << "Key disposition unknown."
        << endl;
  }

  // close the new key
  ret=RegCloseKey(keyHandle);
  if (ret != ERROR_SUCCESS)
  {
    cerr << "Unable to close new key"
      << endl;
    return;
  }
}
