//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code adds a value to the registry.
//***************************************************************

// addvalue.cpp

#include <windows.h>
#include <iostream.h>
#include <string.h>

VOID main(VOID)
{
  LONG ret;
  HKEY keyHandle1, keyHandle2;
  DWORD disposition;

  // add or open a key for the vendor
  ret=RegCreateKeyEx(HKEY_CURRENT_USER,
    "Software\\Interface Technologies",
    0, NULL, REG_OPTION_VOLATILE,
    KEY_ALL_ACCESS, NULL, &keyHandle1,
    &disposition);
  if (ret != ERROR_SUCCESS)
  {
    cerr << "Unable to create key 1"
      << endl;
    return;
  }

  // add or open a key for the app
  ret=RegCreateKeyEx(keyHandle1,
    "Sample Application",
    0, NULL, REG_OPTION_VOLATILE,
    KEY_ALL_ACCESS, NULL, &keyHandle2,
    &disposition);
  if (ret != ERROR_SUCCESS)
  {
    cerr << "Unable to create key 1"
      << endl;
    return;
  }

  // Add a new value to the registry
  char *val = "This is a sample string value";
  ret=RegSetValueEx(keyHandle2, "sampval",
    0, REG_SZ, (CONST BYTE *) val, 
    strlen(val)+1);
    
  // close the keys
  ret=RegCloseKey(keyHandle1);
  ret=RegCloseKey(keyHandle2);
}
